#!/bin/sh
# This script was generated using Makeself 2.1.5

CRCsum="3903234617"
MD5="9b6c62d65fb2248dcc1d9eaaca712cf9"
TMPROOT=${TMPDIR:=/tmp}

label="Systembase PCI/PCIe device drvier installer"
script="./Install"
scriptargs=""
targetdir="sysbas_mpdrv.v24.1"
filesizes="32150"
keep=y

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

unset CDPATH

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf .
    done
}

MS_diskspace()
{
	(
	if test -d /usr/xpg4/bin; then
		PATH=/usr/xpg4/bin:$PATH
	fi
	df -kP "$1" | tail -1 | awk '{print $4}'
	)
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
Makeself version 2.1.5
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [--] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --noexec              Do not run embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --nochown             Do not give the extracted files to the current user
  --target NewDirectory Extract in NewDirectory
  --tar arg1 [arg2 ...] Access the contents of the archive through the tar command
  --                    Following arguments will be passed to the embedded script
EOH
}

MS_Check()
{
    OLD_PATH="$PATH"
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_ARG=""
    MD5_PATH=`exec <&- 2>&-; which md5sum || type md5sum`
    test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which md5 || type md5`
	test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which digest || type digest`
    PATH="$OLD_PATH"

    MS_Printf "Verifying archive integrity..."
    offset=`head -n 402 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
		crc=`echo $CRCsum | cut -d" " -f$i`
		if test -x "$MD5_PATH"; then
			if test `basename $MD5_PATH` = digest; then
				MD5_ARG="-a md5"
			fi
			md5=`echo $MD5 | cut -d" " -f$i`
			if test $md5 = "00000000000000000000000000000000"; then
				test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
			else
				md5sum=`MS_dd "$1" $offset $s | eval "$MD5_PATH $MD5_ARG" | cut -b-32`;
				if test "$md5sum" != "$md5"; then
					echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
					exit 2
				else
					test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
				fi
				crc="0000000000"; verb=n
			fi
		fi
		if test $crc = "0000000000"; then
			test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
		else
			sum1=`MS_dd "$1" $offset $s | CMD_ENV=xpg4 cksum | awk '{print $1}'`
			if test "$sum1" = "$crc"; then
				test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
			else
				echo "Error in checksums: $sum1 is different from $crc"
				exit 2;
			fi
		fi
		i=`expr $i + 1`
		offset=`expr $offset + $s`
    done
    echo " All good."
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 224 KB
	echo Compression: bzip2
	echo Date of packaging: Thu Jul  3 16:38:16 KST 2025
	echo Built with Makeself version 2.1.5 on 
	echo Build command was: "./makeself-2.1.6/makeself.sh \\
    \"--bzip2\" \\
    \"sysbas_mpdrv.v24.1\" \\
    \"sysbas_mpdrv.v24.1.sh\" \\
    \"Systembase PCI/PCIe device drvier installer\" \\
    \"./Install\""
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"" = xcopy; then
		echo "Archive will copy itself to a temporary location"
	fi
	if test x"y" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --dumpconf)
	echo LABEL=\"$label\"
	echo SCRIPT=\"$script\"
	echo SCRIPTARGS=\"$scriptargs\"
	echo archdirname=\"sysbas_mpdrv.v24.1\"
	echo KEEP=y
	echo COMPRESS=bzip2
	echo filesizes=\"$filesizes\"
	echo CRCsum=\"$CRCsum\"
	echo MD5sum=\"$MD5\"
	echo OLDUSIZE=224
	echo OLDSKIP=403
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | UnTAR t
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
	--tar)
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
	--noexec)
	script=""
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --nochown)
	ownership=n
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    --)
	shift
	break ;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    tmpdir=$TMPROOT/makeself.$RANDOM.`date +"%y%m%d%H%M%S"`.$$
    mkdir "$tmpdir" || {
	echo "Could not create temporary directory $tmpdir" >&2
	exit 1
    }
    SCRIPT_COPY="$tmpdir/makeself"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2 -- $initargs
    ;;
phase2)
    finish="$finish ; rm -rf `dirname $0`"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir" >&2
	tmpdir="$targetdir"
	dashp="-p"
    else
	tmpdir="$TMPROOT/selfgz$$$RANDOM"
	dashp=""
    fi
    mkdir $dashp $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 402 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 224 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

MS_Printf "Uncompressing $label"
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15
fi

leftspace=`MS_diskspace $tmpdir`
if test $leftspace -lt 224; then
    echo
    echo "Not enough space left in "`dirname $tmpdir`" ($leftspace KB) to decompress $0 (224 KB)" >&2
    if test "$keep" = n; then
        echo "Consider setting TMPDIR to a directory with more free space."
   fi
    eval $finish; exit 1
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "bzip2 -d" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
if test "$keep" = n; then
    cd $TMPROOT
    /bin/rm -rf $tmpdir
fi
eval $finish; exit $res
BZh91AY&SYp+A R@ ")`b &  6 o*Sܨ
]nmvv]O҆qQ}w>})w{ooQ= *{VvoNnl׼;juKWJ﻾\] @ +o}N{}岷=c}:{_7GmO(v`˾7q:ﵳڍnֻ{y]}˽>|;|{;wQ}wsםe:ۧ#/74VJؽnۻk}!$Qu)w>
{wѵ뾛KY;}}۝Vwf}}{qמqzN2[c][ު묱﷼/|_K|.{^MЩS,9Uolk}ό}A  4ѡ2'iқ#FF
yGPH"4!lbMA4?T#F bڍ  H$DCH&(mz2O4Oԏ(@
&4 B44M14I?SS&JyOSjz44HF44	hhML44z 2h(@&Bzi=SiM44m@=G   ЋSM9oY&G0Phe@@
bs?D_u饁Fi0V^l^Zfmr
CÒJHDM
R%	`3EH3HQӈꍙQĦAP5 $$ \r zDAAl_T#!B$߽*A 5 'L:@JcaBz)J?*IQ(2<&mTwNB$b3
Z*?dѯ<OwV=w33clzzs/YU?Py9qasF\I؆Osrmjg!oƂ0vtGr{Oosd1!CFP"E S -+2L<EfAL5EPDh&bVB$&&!-`DN8:$)
Hai"fJ$i$W0`Y$bFi$`
h"Xeb( !"Hh(
a
V>.2y*,"#$9TCiP(Q$e׌ cQ\t`!}KjnDٕ7PfJLF
t^9D1#
+KTf:vMzQ_:T'9 ˿1N,U׺0?`68 JZ" bkUg,o53q's%'Y3C*/.zb1Fqq6$[BKa!>n& \栗%0\.pb.ɔeNj{B#Nh*o@!H0D?
&LTA$WG4G;Q,F1
!N"'Xg)dPRLԑK)3RRDK$E,̕15TA0QMACJ(

[KLwa
HB=(`EHE4P}ԔAMPPLK15
0!;MM݉d`\`LA0REE!LTP̅)H1P+UCBĽ#$%hfX +Ͻ'pJ
|"*)%!*H	) ")H hb	iiZT(0 
fxJZR)(&A	JB%hFT$)R*@	i :Mk79RTSH6-i痙WvwB022Z0M68l7ے&l4ႮNڵٌEh.fI5V=[Xŗiܹ&6x̒ArƘ. ;6.JMxYc5FQGm
'>A3X7h|q=5HjHB3fE<]N9|:q}C3ma[ۚz5ư
F^.s3ˬ1Ǔ<r5n$[m
.HqllD8Z1߆ё
f&
58ufvq2hw(UtmMt"Le{ԙ.7U6NDj# fS\Ӥ5'v
ދ4Jraa1$"ӎ&+#I/xil	
(`c3XVێaveۛ"&EI61eB9+!lc!;]
N6
}yvF$]dUV r
X`tL3lԖA0?>~uPk<sL$:vhsۥ1k^qrRH^'fnH,2Pj}ICV a-bwoQc l]B&u,q6+l%'#8ppgRx:(7	5CNF]utt8n8"[)q
nVi3ΟkWG'6Z|XUը8CkE:5DͅLC1t+˹$Q> gC!;O!	~7C}Ҹs
j:J!#O)
fXNYhcCLUP
&"^pᙍZ04:<ԃ|oq:j魴=L*9ՊjjD^9;]#Pi
+cAb|R ad()k3(Z
$J^:T!oh(zAia)M̥2÷4dS߽i8ԛhuHii8u1%7MoZȲm˹L	6ANow6or:QG5*J.dvg%*r
aMkKO:Ɏg˹?Wхjȯ3mP@x(ّ2][+^CMMkswelOZ1lkn8F8ιpD:I+0b8 ܔ5S~tV1v6PWt4s>	cbbҦWGq2ԤDfm"e62Y3\|kY91яsdA<sCØfHaҔUA8wy/?W&oR+["ΪO;lwҺwbW#Z-^sBI';e뻠⭘%$`9m'G8-zg:.Ml$KE$BP L@?=W7z^k|#k͑ƈ>t80$>|cmom|LLn>#p	~}9]l̨N1Lǉcw&WL2tʾ~h%׹[eRpM]׾
l}Z"#OlCY4p푴Xpi0îmhklK
^}Ce)y:cK? ]^|Z1t>҈o;AI}[G/f3Ceks9,%xBn.erk;V!
7$D@^=.z_yk;b5U0EU\fvUh}9qmK[ne~'G묪23*{k5Wk"lѭ[XaU[W[o%m
\$1&ND99ijFWeswq78Ek\BFk](!H/{;hw!&ͣG?Z?Ce81A Gp(}~-Tǻ祴1<7I1D}G5X]}#d$=c?-jo 7W4ϲ^qAÓ{/ex"~ӗ׵q{=7Gz13Ƥ@n
D7!Ǌ}wIG]c*5iL?]|&spoZ +zs硚fNh5U/-[l
PxOQ@LV(H|>cmA@ZrT2+vx'w{^hRsY	o^4̖
B9s>J }m:F.R=f=<Aպfk?ÑqINq(Z?g1T/6e/䍬ɧA)Aη0l.}Qa	EfC->b`	S"`wywJ%4Mnxrn/nNvZw7]᧕xs5}~«lY}M :8iܢQ5vi>97><7
a;YFRRDYHH$!8?dqAB^8%?1	
=3 tn{,x<!+`!M6_XP%P胬#B&!Ve$!ǈьP博vtѳdfDO94<HvL:hNa؄:9B.cEQl{GU[=ې !xLBMyIT@q`vE"V 3TihV
vZUE5B0!9_ErtIPjZ7嗶Ы~D~*mێOqJYfYVocm$/)*qԐ
Rt@uY҅Al
HY=4.KJo#@

ǦǺF<i8b:-qR:Xa:v[Q(Ws¹D,
k()RO簢"J>|?ar[Ϗ
Im=^kL>n?U%ӣru.^RzϜ9j;~,qnL,ԇ47m=$`תy`
+fj;y
gMZ)
#ɜm4**"8x&Yf7|Q)Fn}K*"<Jg럇7N)kݟS	e#Ӌb7*JތIO+
k$]WeߑI<h:`c8fG$QM`"m
屶z6l9:
:CN7)O_~> I!`=?+gϻCd\~C*٫*r76ƽ1D!iR#
̽_ĥHH]qׯSڹ?ZXoeml3{FJBC$^gQgj2L~4&
jfsiXOdVo\okH2VKq{q$Iv'w@κ@;vTvfܩ'Ǟ.#\=ܼq7$V>a$=jp4򋴽t[E7O1mn	Jh3(}ߊSJşj(^^gg50іZnDzVGGZWI,\#yEH+!_wx趁lA{7S~~,"tbqT&q!8L㛨SnOfoNtA@1Ӹ+C~z/!)釟;1q--:QB)l5;=]hᨇIMàcх
?B(K^Wv]Y
}=6)DI$NK/.ynN%>R*3n+>^8g{ٖFA2e8%DuՅH1f&13vaK0+jy&\F񞓂~($(_J'ƍ2c=E=o3Eƨ"m! #A&qLmk!QD%\~qgCp9/FGE袊("
" 59 "(##0;$?3+FC3| !BFq<m`^o hE,nH d3=QR;oNU~<>0zGUoz_A$l% p,DA	!
$AdsRlpȴ4HAD4}ټܞmTu=#o3)OfKigDjفI*с:&'*2ۏHC;$iQvY8&*LCmhBwr jf1bT`GGQAJE,$x#nH`gHhS*<8$m
ra,L!=z<Ȧ/a,D:FclQؘibbG\ Q|39{_vzoʓ
Gg˃qh)w6G_jb٣׵ n}sE+8(I>sGc++`"h6.ׁ
8.6PS~o%ʚ[Kn2#gxH`UA[
Pfu;6?LLRQ0Ml9NP
1</~#PJxKVݼ4*\엘D*!R'=Ƕ8U,Y`n(ˠ|==ϟ&&&q^@`4g?.'G	msO-#qyObSJF4.1KGkjȕX
Qc˘: M7^px|uW*&[$31HB,R 
  łLR5K(<~MrȽ+vw̷9A{JB92te{Dy:"[|C1\Rmv, b=<AL4zL7%Hr׵ 
g;riI3!êe10"a&+d2a AD!VB`E1mQѷbv,X668 M2yuꍚ3

(t,/k0*_M44	"
҈8tn=A'̧#1& -
#282t"sk	BH:@Yj>d):j2}4Zp]]r9jq1/{p͓6VkM(ˁ{=x̱(6%xy$S!=UAx{Q--)(J&~R5-RH<0B>`gƱ\V2jRR3,/
('mvyF߅M7ԦZ i%QFI
@azFZ0xu/Lv	7>!AY ƷtX#7*E2HYLLiQ=Zxb1)lPĔ
"B$C=^(SѢp
$$䭑OSv	}꓃U9ί^rl~Dn2a4jRq4:
C
3)6HvL]2u~8Q}Z`Xf,鼎Fa-)-) MA
wvCo1Zcۇ1]W^]/́0"!0"!
W9V%gW{{SnHaঀ(ar	&7J(g~bN
?b?"GVW?5bڊ53I$)/7#
С+ZV}wB1n5gaYe<C77!>)">?
nIk$$6 oѓ/#ζ$B8	3cS:H}SI}K^w%1\MN_ҒN
ޕEߘÂuB,1+$~ƀ;Y8-bAbsD tvyDZ7k/0R=?qב"J*$p	&1&CM&I$P![c睷x̓zcP!(IBZ t
(#҆"-0;>R(/'c򚋳3nlNG3VJR b	 <{͝4Д$4Q#0Ias~/C<]k?#f
 
_mz1'FCd!!	В@Øxa/
D.b/(gUH?*b'>moIk[:8W*I
S!O;*XgyW8dx@?
PO\X`Qb;}1@	pe
94hxL'!fYYn{S~6
/\wur
ցo;C7lm|pT[!_U6jͧZXzNvk
`9WsrOE9#
b
AɃVP\GsJ\`o_Tړdbof	2MAPd.Ѿ[
Pew9Q-Gd+.
o)܋#(\Šp"7@qle}8Ӂ{J8BF2jpI	'l_~!{EoiP!!!$aK-J56[F<8J mؐ?vAbֶc[fCLnC1UcRN-5BVuׁt*cB|˧\?YIYT*"S	qabpFe- F(HF\AADcj9	v}I&mǊlqQ6	:)D;u;Ll``qfFwn
vEć 0E2^'k^-hPgu)0giƕ?z8tVd*0笁#[j&'yÜ9ONt/S6G)n_嚈W;\ƛ9t|e"hߪ44Q'Yrl^p_10P-c@c}I6d5<"A?1FxW%g6X
Om{g.`	_7DtI!D*c09mkvN-Wx)'oE_T07+gPɽ
J_׹wC3ST!_{	j'(u}Ⱥ\_RWeҸt<_>z.h)Rˆ%RjT^[2E<tV6ݲrsGqp,CsB~Y@%(6-G1)h?/LMnÜz*
{B%oe^9q\pik5˺8-"Rz]uA6	ݵ?Y3ٯ_2|uꌞ?z)UZ-Mԍ&;VkK[MOf"Z8'OJ[UΟ$=7_T|eݔ,r)O{-v)^EZv;y|cͻ*F$\2"b_( ͗6ܒT2MFK	^&i弞chig`$ob]yħnrߘ.~lFn==Oպ{?5^QկţUxnh )'S1N>\n*uնNG4qjP]|#	+IFѼύѢ?
Tnnچ̃FW#MΓY]MMUZhEQB(~+U-ۏCצt,,͛-vW%:vQ27APTfiٷC=dޛgck6tBX`Pwj7
AHQbu7~Ww|\9쇠wM󏏖+D&Vj;e>jO1)fUz~z7ѿx6l$Q6FU7[rS^8eLKXrR6YElpEV]tَwy7$\|,#+:ǾXSg
{,ʜj1e!bJ\!11f{Lh*ǐk3Ыb0crr퉳!!d4W]S͛WmyQ:}yaWB9s>WY![1fPUsM+w*> N;]ijG
^g5j/Q8Vٷu}ߞ0^_&c^=WY"!tl'%ywt=gmzXi#'ëz)`A|5]rW<w߁T0up䐐VE( B )Ji),J4L!|*MBz (p
n^.GV
BfLD)	`\	V?_*
 pYV/(6	wǣꢮ:-ɌAHbr
Zxzq۫ϑ`MkK,ܦڞ,tD+=)rgnt<ؑmkzj7-F!I;aqSMZj)*|ﺒĐcY9r_rv݃0ۄLk@Ԁ{m9
tsruD$@7b>WۿZ9[E&aY`>&)bsgƺÞjd1+UlfCd4q A"޺);u~i'rTpaDx]y^ZI7t6VӭܖPOKKσpW쮽xOq̯	Ǟd*2	s6ŮGY)
LcI{`dawp[ָd(ڔ$+fM;1$^plW*Pn`QF|tԽbI?hjRXWM/	6ʷ*5c2R
k6ѷ#Cx%≘r+Ͽb !Xb-u8$[(۔̱cn67w?}ˡ\ksWf:%.-	E8HF_aZ}khA,v*Xyn{#LpؒHf&#A4?~V6P'`t0j9ܚx8$4BJYXBvrOL1sYz)*RCEGB -HkHkSP4(jF,dkC"QĥXjRw$N,UA34ʐD pbp G
h6b
((oЄ0U#RPa.O& iNmϫ51x>s1~yys[kͶ1
z1~x?$B_i]G˜_2fVC@$F]y: B
IM'(SqUETUDy9?_5宗"*`Fζ/3[g>^n~X%.5eϪU37<qZb1&
],d0`ZkFXQ4Q}ȴjy7n;m*m+b2X<i	Ua2[W,+?.rH(1ChW>Bp2g$ʗdH66DAa0G?fTMTADBDR?QLaᒇ`uIw#%X#k$
;?gm8߯{FsMo7t&@p
hd	21mw0)*(4:DHDQF3&}>	i%蚩%RO6:fDQEΟ]!v]klSD^ڱE萠JX02@E:kpN8r!oQ7=n'ZߦpkBo6rQ6by>Sb,׸&~vъW=Q\pYWǞ3gslPT~Ws1Qnv->-VyNBe*F%S
L%I5XӬjb̂mڵHX%euH#I9l̒[d
u6d.Q8ה}d?r>U*R4k
d8M!RA^rkPIpmRGF"$B5j%P+^j/sI#\_d.S6.%]g _h@9mV{ A|]|QF{||/mMg0ESF! l\ 	T){!!x4r/)ؓFPVWWBeH5f$um%UUan0ʂ2)
f5UUUUUMQgH|?\O)?5av	r"a!Cۣ9{vIyXŌk驏y	ʖ3Ï_WG%|53f_BhmJvd$*Kt؞/$ݞh
4 6*)1ZU+] -ah/Rxalp|v)=.A>F_(7?
6!ѲmE	7xM^8Xl]$"E@W
F
==ݒL![?wXƍ0%JnLګI}im1#
LZ+}Bh{I$%z"E{IE-oV/QTkgiV~ZPj>8hҒKș%w^ CIds ̓4 DdI|_'᧏K屃Zx[8+/$a(v$5XQHdZ"A&[gHh<ζ?a{3rOu^X
gB.n{acH3лRd@G**I[AOlI;y5dh6H3foX
JY;fscb9IF˃Ac|ii0j	I34Lq'R(kEGTG+q3׊HdEN>[lng)
YK6 xlTr 1
a:/ɿh!	ߞSbEQ-ryC%覻Ŗc	\0־st0C]"'MmPo1CGMx.)Q$j(Iw}^ǫfXya'Z5BmAv3TB*E"`]Í!u7\^D81!<3xQ=b_a {X-TN>:ruԜuZƻ1]<|Zw8$$j$p^/ǋ"%*岩5:ev"ɳr8{gY2#2} xazHὊP`^LvbQrDzX ۍ1VnG'A )Jxd^LGL\ͿExi_-tte䵋-Fajq=XS(FEFXJL
_6I}T7ޒOM߳I4w2\
#yMH&,j0W >? 6zy,V17c#=Yſo'@FKm_~<Jޖ_G%؍hbLݾ__3"GЛ޹LfFBם-G*03 I
lds$õl5]b3s$n
7iCǭp0cGl?P3E
E^m,@ߕh1|ţc:fjSiE,MȂ+%}8葵u/KĘ_j~6.]kP{)"'槫O,tF@A]z4h{yrL}ׯ=YGӯv2Kkz3D^GQ8WFIvZKd,9/
f_d9jf?ثIJXbiZ!BT(ywʃ	șz*^ΌP:(XpA+@A//Vo.SOtO'YTTluSN	iE:G.iQ~Ng+\=W4g1Y6vOTf=d%ꚇw3T%om[4ZSoJ,	l ڹԩ̀t-
*^_=	yu:xGi`FyRgB4EA2tBN|wONRq5}wDwU;lM4KlZuɶ-JjoHؑFَECAδ8p\STP~q5(۩Q".iD*1]"tvm/jQF=H/
lJ Vba{y'aZ nRn-5Q͵d@ >5Śɿ,.m1:^<!u>=`>ȏ_ՏV!e~zІ1ϥy@K=Mbf<jZ5_t¨]Oz֛?k及,NLﺭ~XǃY#uXFͺv<^mhƒ<=r(A3>Zm'Yñ9$;V9c3o7gW5:άe_gmfkv(O⎞{a8
z&ڇݍr/i05Eńb~ ~`"h(R!TgK:~,	|w,ae$?JL$;Z-gPIsgR7B&
X8!63cs~cT(PH1CދM8>6@nbbb
GǦ%m$ZP)SW(~5sq \a^vaݟY߭<QM=53#qV4!iđrLmi$BB%٥(dRX@\` oNC}X:@`|,${<|= oA7Õy'bC5`yG lll7)D!5@v*ouoc&jJd'UȨ!@w}q\X'
x"\\Xtd&+bVG!]0긕~_lmw(M\tW ~hqѣRu^
)bs}Zr x2` L!_Ǯ#&ʶAHJJ=!Bn'9_l?7K"%OG΢$ '"_b0qAoTC(`q=&N@"bQBC"|pk&,>mMpp&MM
B	7[ym㢉j
! ފ%l
I&#: `<
_fl5ꌣB"Jaah &!gDs]}$j4m&0lrAǠerJbhpdiJC7 -
DH=i6sUP#V-~RsF-
b23gQpcElOFt@Yd9g%99ke}HZd5Oq"2;#Ѭ*;	Q	C|3J,}bM
6āYu]/p7L?O`Cm
Cr zb Q3	LDL湶32fy]B&W# :X

ʐ`~WlJDD?z^).ŭ2BA';vO`cOlu/h9m5G*`dg:L#ʷWq*`o{
U2]xhᏚs	#\aoSD(u!gAzWճGߥTVXdTH6h
#rcQ"ԵJ@N݈p:z{QlzE:d55DT8IT0U <]"{Qb(^,Tdaw T
GyI{Qz8d! Jl9\:;&lPGAy^nJrkJ	QNܯ
Q
0lI
j_K@X 9=EQĦ,!Ok'W"m;=0`?2sHjRMk7!+E).;55T]1ѥ`E^H [N1J⟌#1k۟E3P6#
wkC_u@piJ0ª.K 0a+{
 Ta[^8tM*;Η@${PM%7<Rq
$YA"=&c 9 	<0m5 Ur{}5ɓȐ5	 C䂅 v9TISH~*"<f$/D'w1ՙ$rx{^&[*F4-
}dzs[݀؀ul57#A(TA}Wѭ(@&NQ΅me
ѝ
`(
S|}@#{5 HObyZӨ뻖Gx`$s  HUC]>%C$1j($j*<>]	.vVXDj d
A3G1o$j>FK{ZJC,ɳDSD_ܪp&:SͦF'S`IƑȿK~62Ɵ(`EHH,&>>+$x0"$paCAFXCh,U!|OCP$v	!zB `!F#wOaT4~ꣳ-G65<\$l:],ȞhC/b;NaD&kDHu^!cnl^BÇ7WXbX;m$D
l 71'`z@1H/lZ`
)jXn:TJbQ,Li.]P./T\&RiQ1F|
+IJ>saehr731
()qL31I&P7ڏXb|g)KfcY"Iu'y"|"=);ʂMŉ=~F;01 j[!@9a9P#EmaVJЮ0`(
% Ne](ELӘ?S>RƯpWDx`88[Uz-33^ؐq;`ϞZՂNob5Xgh"Z[xPHsC;qk	/)O995ViǷo9UQX4V2`gN#GKFA,Gcmy$ "ă&A+\~<){dI(Dn>OְP
q5CW$I76*hAA1u=ާ2J
;P
h}&e^FE4SsZi8PPf0&Xqz0ɮp4z#N+Z:a"VAh .!">`ï'(kuPwr+@
a;#ĎZBhdzbvO#g0#fTDu,*fVab-xV&)BDXADNwnM$s>)%)`^ґ$/0.&=vͮew{[:YM
.עh:=^'Rd(6E
(`&^>\F;HhR۾ց.havC̞GZ}rgtQB
B!`RjǛZ,31Dx[CD4àUqQlVs<oq1v $ =Kb+pC;2үf#!ob=ҹ	 ժw%hzs>L;U1FAu$֍lRUyfhlΌE"'0RZĜ7(ERI`mHmlaAIAAHRQBPܲVA
3͋)-A%l@̚mcvB"CC:>U51QL+%4
"rYE2A8;nH\6-XL>R8ɱlRl 6tYu^(`wJUH
![ELó>bsk^SHS5ƳxE!0eAWR#sP;b$E>8B'/cLy6!(@Hh{}Z3F7IȦ9Q]7Sa4 wPmE
!beDQy)ݴSgGq
a,>pYMaT牀v2w9f T	"();"bnBÇVAsAia808' _DK䒴OW*Oeg9%.
<3^m7H.umPVƆjR~<:g&YY,S`ʵ(0mxCZ-꒐z=~h*~)D_\;?CqufmHkH\-
MXjAo,WYFϨ{@I'ᶢJqjB$B!yB<cjU%_@lpqC񘁿t&	ɣ|CUUAKUT0DIU$CDԆhdla
	'МCBCi9dڌ](\)Gs@GD-@rP$MQ0]dKmpx8
8l<=GJTw@Ⅰ);wم:z@"(" 8x"
Rb*f***bcȁr**=o"9;A</,;gXHlX
i1<
 {	ʑn0QAh$B@I97׻O 
ICcV()Be aF	
: I643(`(є̰͠0 H`r{M]1$qp4
FiRG+\QY@7,nq;
		1QPU]/a\1̸8N/\\Ht3!Q
oHߑ
 MlLb93lzQ%XEu9<Cŀ>at]T~q
Bô%V/@<

$'pW ۲;wꍁ.BBqOBnJQ9EMӢ3,dDxyy3^y&5:P 26g$oʊ/LzQCة+.BXecmS m"BU$λ6N0p+Dq۵4f]6sₘƈcl}W!
0+D!ФY-7ڙ@y
gB@LcdՖ)ggq
F Ő1E@}Y,j=S;/|DCiLxLK<HV¦aI11V\:
7XbĶ115ݰeyju)*.0ڣAMugoaZSO0uzkn)vٸ8mRj@BF?ç
^%ʟi^5f}ʛ 69?ni}CD0WB	<s<y?fHˁ??n:h;:@UHd* E 
k>a㑀1v@ef1N" C@	@lYaʇX@h8s"К~H2 @Rp})h{^	:MH U"~n*B")B*$" ̓{_NM>N]AQ8]?qJ;EdH %;ߝ
$H H
!",~i]'fˍ!rɕ]gD^Sb;"
K+BA**aFrf! .9!F;>rUxEEXC!XQ|B#jDAumR	+YM)`!6䒒@r__IpT.eI). x#$lv0X	~i/a7;'^ D4#PxlYP;Tu @b'a8f.@sܤ*)s?D Y0 U"EҏAerVí<GyybyXQ`ឫ39y:lRBh!hh6TVXrtoG(g4KĆjRopjCeAz'^&$<^OG^y.3Z`*`(&k<fa1GG؃~![RZ;iH2dFI ry`;x}`}!̣,h0#2l"bU 
[Bv)1M'zX<;]m!gW:
iQe@_n_Y^)btơ00AT]\*BH,024l;<@
 #=>膭{Wv^LP̯)
,n_8ĸ
#RsIW K[E2:B&u7DJqĳ^%)%BB^ubFQ7˜}~cXQB 3&6{~5ַ[r)*h3@?>RE$JQfPw2W2#ZH^=wm
zx`i\ffO1}TPbp]B cH0NViZh3gFiOMAm:8+: Ș(:udcF,F5@A׊ED}.Y6q6yq&#!gfEDrY6y!ޠY*
@"[?@Y' :n^$xf0vJ(.W!Ҕ;Hl.t[PB2hJ^	%U
|`9rCd6`DNs``	}{6\{0"!?unf{ DKHɘ(aX<S{8Q}'GTwIXS!GDp96*tGia6>4g{/pڝNS2Z>0uvQ:'D	B:!" p<E
"CMq@"o>uNa){^!rĠUB.lN`Da&tn|tZu<ݺx6tQtsR	ZС8D17ity7G ՘9"%7 )7(esNȭ	0%Ǉ<;G$)F(+kr1tD$l㲵"AgX`m۷te5""Ecc$fcsLlqb64A5	 2uUUUUUUUUUUUUUT%Qgwc`tѱi(! (cS56s)iC8pQ׳STlacXwH- tA*b;
kkL&vfCL3l&e)1Ur0NNt`$V%>qsVhƞzL!κ,J+wAL)ZliCuėv'tgDdu7e1VVsCYrfZ7$tA*SI$p\l~zÅ2I[cFq%*
7u4uسEэFL
01H7M+	]F_FrP]$0B++waiQ6TEܣbPPUv`%+eEXü`$X	ʢϼߣ 	3x	$H	Om5.0t
0{ g7"y00@1G-mL
+ci4GSE	񶐚#L!h:S
l	PvH
˦݁ŲȈ^	=O˚?^xCF$s
KK!A}y[cX)mt|1R=KI/NBZ?0։?WVs쾉DH!I1ܹ(dx#Dar  6ʮ,6<ua]nI"TLq*Qa=ᝤl`oz& w
E1iْq66Ʉ"2+!![RC6$ %ȣ`?).q <l.#8D%d: ;PD"Wzk "@Hhtႜ""		kF$FBu	C<2DDdKQEUTS%S%UDc ClJ04 p7nJ h J  wm@$1QqR1vm!?xzia݊z.Pl,!>af@pXkF!2Fgᥢ:1(X$N :f
c&:"CCQDu`A3&9")=x"wiQݤ!vϚ%|>'|h1B2 !:Q^R-opEQ(1SZs:0ٽ|h2N0(LFU4)! L$_~sQ6AT'Ru;ʵAQQ

5Esz]ԹOS+s~W+_]5TY>@	@G0fNui5m$U_E`"IbUƘ1৞WTA>{B"ZH\3}::FƉ4A@^ X8O0(К)6J(24\ak(4IPG`x>8a"@oyF!#Ё(%U$
9xf^@B H`:1?m$I.426ޝbZ.]6"'R
蟿	 0\ݚ9@_	Q;:Ds4?hƁ8MҮRiO̝#QX9<r2#? 	'+FQBϚ`|ݚhPe%H%$IEp|...0TE:z7MhڑI:qwt㾙8aBL
 d
H&Br->YMT3a*=ģC
R!J8.qd1u dKv:H rJdd="7p`'sˀO!^nCrh904DAJ"|TgIpfK`؉	=eQ@I5]1M@'g2hbS ^|?a1>J~@D	]2韸&(E14~	-DoAǇ
T;YxD+{_i[A e4]^7xɇOAKހL`L6f"s巈#BOm`O9XTw8%@hbmA*>Jc	"
`iщB!H,(a$ I#Ll>?L
HL,3
	5L+kbzOZ<gs	$ic444ى#{>lwSt$,liqWǉ|Cqu
uxc;
AĘ+Ay_cWt&ybL1Ҭ_ Hn09Ԟ}BEZP`rdì1?dM}D
7#2!1vfek(,-:Bt!D͔F4@bb$#틒
_}Wk%
3QբR_HӁƹ9"s3g(u.A%攩Ch"VH:N1g18h'l5ھןB`Orİggb#NޢMvea
5xK1P"jixs@CʄaljѷM(7&+ B#ɣCwэui/Ǿ`Қ@v%>43e?%EGB?Wc@
ЊW`Op耸4!Šj7FQHL GbɼpW
6ѯe$/3u_Fo8v06jvx n*b7f/\䈯7Rwpz@az$ܶP|\T¬ ^3/֜I3G||ڨ!5RIU_885;#h~D<qد7 <D̽ow;<TB ZP:7x׻V串u{Aq
\!j_L
.߿Z9 knCsVŕnD6T`i_ ۠Y'WB#J=p"ɀ
i
|bvRg LS+38|
N4]z ro"
WH#$NM=͆Ϋ(Tz$DKH'~̓0Xk)KOPI0`$!9Đ2wڎY
~6@>(bR	°W5GY2 o	A~)q%sg pÓe(!D
) ׽--xiAPTV|Mƈ28O hPKj+UIj:'2МGARRJ;@K3 sƘYS&P
j֖ԚZ'Ȍ6"`5czԉt
++l!%PUՆV152`/`̶j
Awl"V)
@de) 
y^3=s!NvnPi ]$HӁaYW {G("yS) 
PY$bDWkK*1ԪC3A%GSAASv`%<'=b2kBUJqR6
׳i1CdO	
xH3x/R].Up$]D^$M(w<NKHLK1r$\2 T2hHv
JEjq)I;I	@S 
apN4|CMW B^> bR#14pE.2f<
 \B8:qb[ag?!:`j8#`Jd"(,t$Q+R9rQܦqun@Sް
۵nUHa?LEQG
h8
\&gҏjԝnV28xEB
U42>3/*	)ڬ11Dj0"~obD75C3emt/Mw`	%n06#Qy1]4\ū ?D)s₢3֡\?tq.LdSR++*BAQR	S ;KwxyF.|A8]@bXϳ]vpq0U0b`%**Z"
7(x
[iu*7r>v(d޳

Q:I&7ݝ\>ЇBA+,PMvН
y;x6t߾:p&0 *8'13`bkN!JCaň@1dQI!bT0GOj.np8GKInʯ Ϭ%@z;?X3}S%5?HDH1r7-jǙUNω^40rOd 9NckO`pݤp@RPS;Fe97˻}H)J'IU5iL2աmTH	I`jMF=οfdۯ]z
<2:fskZ 6565-j"y[PqWk
7SQDZTl$fzhT8fx:몉Pcmj<HfzT@>J`#34o@qYmD	$п5`Mfy=-\,;ou! F64@@خ5ZCbdHT> b=Cf~<EB^Fde}hy-H6kq(В)yXPqy俔)L$EjEi;rs?L%ԖCQНo)1HH`1;b\,X-lM=3j$k'Zt:6j+ADJ߉0 ͙+jUtĶT;7n2%ƌI
a1,r]k'hcYM.EjTHEq
cT]%`Lt	h,N豨0=&d@])A\#)F 0S+y~3
JLK)8i]M=Ɔw
L
?J
9p>3~(,ZZHs110fvdɂe&pn!&(J
F"wq(!Yms Ԋ@m+ vDJ#ߤ5LMm?<(wG4WᖃNa2SiꠃE@~Լ< 5Q$R%:^pA E(| 7xRzvy~$(h4g$T؃3 ?2IEUTo5P2P&D1iRsk1O9|{կZȁ @ [lu?/hTc߆ ֐A@C"M(4A	**DA"T2@D% &TII=Q*<l̦Т!L QRKK"}g[D(pAw0ِ%	%ǋ
3rL	
D65VABwc)s%FEȀWalg_Ɖ|m[n,
񕱓s%YM,XQD
B1k|kihwM]6ɋF*Q5B*Z<pB+|9
I3p=;
<؀m. ĩ:74)Dȥ5>
@=ߏ$!_Nc F}`ܡX={0Mpo~66qa",4'mcDgwbWE˛ $j(BHlCf`$"É@ G]Eex|.\O(q74=^86r1/_?4:$#P=BSYW;@ut:d;}<!Ƴj,;6(
i&n{<a6 QOP$뾱5ڢ/D!RI'm\4`}[F6> yatMrD 6qb$C@XTQ!!v¦kģiCb"G@mRbA:]*'6ן@#8fR[A8g#kpb_1h6f<ie!"oTq-*VHOEcݵ4r۵gY7!~ۘQ*E3;ꊪd!r@0)[
6pD zB% CbܪkL.S%̷<ĸ'|?W"tMǽ))`sEgRҹ@:6%*m8ZU#aC8¸1CN|=썆4@e[SW8s gJ|됄p1x#DcZzwை	L|-x̔'$fO#HٰGH VKbcDBHAFL&.)ۓB~ XXo8I4r0.14K
C'jl
r%A%4$8reֹ&h"Il#
%gZLH
U1y:ӮtRd:GP 9i'k79,jH(4q$DK7
.PsĆZ	RB[02<J*i=vpF)$HXءt`B6S|~w_kM>nd(0
2%D-ͿG],N-"wthCBOM-rYr1l2.ckXJ8O;UiQZ,6d3%oB7gmhCk2Li,	hLE`"$P!&h14;`m' 
$0ݵ$!^8rٙt`C7kpK_k#Ͱ)XYk5Ë#H{F-.hc*-3 `bKXx:FBl4.MPԑI@BЖ5!81N$CC.	@jP^~a
>! u)m(BRL	8DLU
>o=8	`D/@y	fbbEy)6J#6(eT}p9E,'&uSE@"2aZJ%?0BH\@ʵC)GC֑e	#Э.}{]?.K̈ˇݐ ]hKcrmI$P G]΀ .!z9;O\v#dN%/>) 'N; UEJVbHv 8>9	iRt`େ<pt2 
[J{=KT=p%@U 
JUUU]yt!b I ʈA7bkCm6x]Gp8jm&<`0_9=O_8>(v(dDeL4z6U`pm[7Zm ӐtE>ԡEPBjߋppe$AP&G߬Mq/tE)Q|qNgNg"Zge!, 	4`&A-
<?^㯶Z: 1a0hvݯ9oVf=p/־Ho.aZ <kCx "cFM$~.:btS"'~4NuEޫ9 H%`pU",`~~bp0x~Rq?޿h{.h!_<tLA|є4#,1>21RN6@B^s:7<1TtHIR8d-s۟ r|R>@ zm
Wv
}V'`~D/#")!4@Pȁ" H=w;ؾr
֢rnOto:1$j""bIaE%
f'GgXKԓcAk4;gƞbIz4 N*7֧l\<	۾,s,AdU! 
`ي-:YJ8+!CPΪ^QCz`$UIQؼ R|=a01v
ECi>l&W?4>Vfo/fwPi,Zll#B/۰Yw%87|e#a@`waa
DW} C
'9_ѧ)! 	"_7L7>;vh%i"

ԔM$Gi@ Bj
"<[Y ^!oLvH:Q[,j}%/&&b")IH*32Șslpq$)#0?2D#IJA9T90`\,*h?4RBJAB $W1Mϰt49m 9W4'ab4IoP(hM:L47q4_٘k:QU$>koվB/J琺Fcpܠ+p.0"w$S	 