#!/bin/sh
# This script was generated using Makeself 2.1.5

CRCsum="748682993"
MD5="b129539d44629c28e17f3d9258e8fc24"
TMPROOT=${TMPDIR:=/tmp}

label="Systembase PCI/PCIe device drvier installer"
script="./Install"
scriptargs=""
targetdir="sysbas_mpdrv.v21.0"
filesizes="44609"
keep=y

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

unset CDPATH

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf .
    done
}

MS_diskspace()
{
	(
	if test -d /usr/xpg4/bin; then
		PATH=/usr/xpg4/bin:$PATH
	fi
	df -kP "$1" | tail -1 | awk '{print $4}'
	)
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
Makeself version 2.1.5
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [--] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --noexec              Do not run embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --nochown             Do not give the extracted files to the current user
  --target NewDirectory Extract in NewDirectory
  --tar arg1 [arg2 ...] Access the contents of the archive through the tar command
  --                    Following arguments will be passed to the embedded script
EOH
}

MS_Check()
{
    OLD_PATH="$PATH"
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_ARG=""
    MD5_PATH=`exec <&- 2>&-; which md5sum || type md5sum`
    test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which md5 || type md5`
	test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which digest || type digest`
    PATH="$OLD_PATH"

    MS_Printf "Verifying archive integrity..."
    offset=`head -n 402 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
		crc=`echo $CRCsum | cut -d" " -f$i`
		if test -x "$MD5_PATH"; then
			if test `basename $MD5_PATH` = digest; then
				MD5_ARG="-a md5"
			fi
			md5=`echo $MD5 | cut -d" " -f$i`
			if test $md5 = "00000000000000000000000000000000"; then
				test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
			else
				md5sum=`MS_dd "$1" $offset $s | eval "$MD5_PATH $MD5_ARG" | cut -b-32`;
				if test "$md5sum" != "$md5"; then
					echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
					exit 2
				else
					test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
				fi
				crc="0000000000"; verb=n
			fi
		fi
		if test $crc = "0000000000"; then
			test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
		else
			sum1=`MS_dd "$1" $offset $s | CMD_ENV=xpg4 cksum | awk '{print $1}'`
			if test "$sum1" = "$crc"; then
				test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
			else
				echo "Error in checksums: $sum1 is different from $crc"
				exit 2;
			fi
		fi
		i=`expr $i + 1`
		offset=`expr $offset + $s`
    done
    echo " All good."
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 288 KB
	echo Compression: bzip2
	echo Date of packaging: Fri Jan 15 12:15:44 KST 2016
	echo Built with Makeself version 2.1.5 on 
	echo Build command was: "./makeself-2.1.6/makeself.sh \\
    \"--bzip2\" \\
    \"sysbas_mpdrv.v21.0\" \\
    \"sysbas_mpdrv.v21.0.sh\" \\
    \"Systembase PCI/PCIe device drvier installer\" \\
    \"./Install\""
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"" = xcopy; then
		echo "Archive will copy itself to a temporary location"
	fi
	if test x"y" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --dumpconf)
	echo LABEL=\"$label\"
	echo SCRIPT=\"$script\"
	echo SCRIPTARGS=\"$scriptargs\"
	echo archdirname=\"sysbas_mpdrv.v21.0\"
	echo KEEP=y
	echo COMPRESS=bzip2
	echo filesizes=\"$filesizes\"
	echo CRCsum=\"$CRCsum\"
	echo MD5sum=\"$MD5\"
	echo OLDUSIZE=288
	echo OLDSKIP=403
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | UnTAR t
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
	--tar)
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
	--noexec)
	script=""
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --nochown)
	ownership=n
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    --)
	shift
	break ;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    tmpdir=$TMPROOT/makeself.$RANDOM.`date +"%y%m%d%H%M%S"`.$$
    mkdir "$tmpdir" || {
	echo "Could not create temporary directory $tmpdir" >&2
	exit 1
    }
    SCRIPT_COPY="$tmpdir/makeself"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2 -- $initargs
    ;;
phase2)
    finish="$finish ; rm -rf `dirname $0`"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir" >&2
	tmpdir="$targetdir"
	dashp="-p"
    else
	tmpdir="$TMPROOT/selfgz$$$RANDOM"
	dashp=""
    fi
    mkdir $dashp $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 402 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 288 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

MS_Printf "Uncompressing $label"
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15
fi

leftspace=`MS_diskspace $tmpdir`
if test $leftspace -lt 288; then
    echo
    echo "Not enough space left in "`dirname $tmpdir`" ($leftspace KB) to decompress $0 (288 KB)" >&2
    if test "$keep" = n; then
        echo "Consider setting TMPDIR to a directory with more free space."
   fi
    eval $finish; exit 1
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "bzip2 -d" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
if test "$keep" = n; then
    cd $TMPROOT
    /bin/rm -rf $tmpdir
fi
eval $finish; exit $res
BZh91AY&SYGB x˾g|A]`z t4{y!b mT{۪=^^ X   k<}owNPnk]^(5Bۧ}Ozm_n<醫scν}j
}*ׇ׺}Oq=< D  jΕrnHO
u{oz{>w}Eϱ]ǭM  (w=G>\[QfOgaٽݷ7}gq[wol%Tw<5Յ7}noUsj.Z7݇WϻIG2S2oov}}aǻ:ʄvl\A;w.w׽:_Ov7mϹLm5#Gwmn޹Jz}o&gO{jtݷm;Q^;g^;- m]ּ87kjͽLW`j]yuwozwvt}wv+_
uݾYG{]w;7@ޛ$ 	 @hИ4dɈѤ`dшI)=0M4LaКixЦL@Ёdh0L 
zFɔGԞI'Az  1@C@  h      $QF$
OT0zAM4h0

4 ѦQ44h        $!d&ie6OS$&LA=4zڧ<bmM=L6C  d zOHh C  h  4$5?M4<SOSl?S!Sy55ښFOMOLG0Si2fM2fLm4@&M
@ɠ4 !@A4i4)OOSjiMOjjSi5 ѡ     @     h e"sͩ>)?9Ϛo	yh?O ѺA>ր;g1"J 43!?@G@at R@T#hd|!Rʐll0R\c?1OlSv`GNB~C "NdQf2.0t>=ǿA)o-Քc۞dÕ㈔ҒP3ã,V-E|)SMlm[Kܦ#SIVUSewW)^/i>N:
]DQ`]<:8(N	,K^6yrdkTs=UիV&fjUJS*2*W13Lcb(E؞>.a5ۦhLtnѣ轢?KH6(HiSʿr锷awJy>7gybw~֔yWj>:oCu!\]Θ@AƧʒj=/A rn7Wj\:nUіY8R'Pg,Mo<W|Oo)YZCUeطq'/Si-VPp֗vp[בZU9$Ylȋi.Q:ůۗ8\oMnj-j]ҙi{,"O)7nvwm
Wǖ-W]S,pT`N	80#66K^7Ω(Uûj8ҙ_.
Ԟ.;
8Rxegj/ioMΏ{,ZY9zzORo+՜:_slM|# I7Rӫfzi>w>r;ѿt״\2<}>/EOڷ"	U5./MEE֭|$xMORAI7phlw7VɥRl ޫ	j"qH,mZcQU'3dƱG"qkb/
ڱr;#&J;> Ƨ5Ygٜ͗f]fʔo-[A;Zm7-\ 42
"9 [;h'Օ4x?qqw^|4W	y^G{gV.Y/."ί9?djbBWLzMbj`?ifISzgHBTxc	>NqA\_y]Oݼ/C3q:@b\ܽd@I&-?ܦ=_m^a6#sm `+@{f޹Q)mx> ^>8iyy?OݯD&NZnΨӀ 鏊i"EsY+Dy>FyDs^LI,>'{8K{bvSן7\_oja!v(C4h78JF=]})s)g=_,qs}gk\?`3-hC(\^݅ߣ?a?B	"B(DWd5U<fHv7w]#Ed~=}/#Jlb`<`cɍJL0a|w#?dQ>op?.A9u90 7Srˑ:Dm<Q`Ŷ`j?n}qikZڕ?4ZjǱӎ/&Eɘ2)&hš,
r*/38z39	ܰ63нr<ajh[෉j:?m;)%M>sjf7b_]/E</Sl9wZӊ_UMi|=3Y^TҳRtc-7U[\s}6K:gk~SMs;DO
2bMt]4kQrWi X)Ȩ'Uh@BO@9}2 /bgHHOmQ8IRbӑdִQDXiR
li2B1`$j4o<b!(`" rhN?aM PIp0T
JP
hy5>y<!
Ri4Tm0	b'b0 !8	 'SH*`XZUU `BA=zS*i֐
 G&GP !*^LapyIVŎq w\I}BE7ӈT~CL(2@)&V?Hl)U\L`j |<U`q2߷s**&2rZګ
Oګ4>X|'	Qwgkv͌Ur
t8L3SM#ɢRU9X1'y֍hYfa}{	)J4
ǺA}	dI3|<^o-U>繜G)xo*vo:^#
]iYp@}׷n{C#sꜮGS8nuyUM{+h
offDZ\T>0*c$֤`E3Y9/$pFÐX1ZTSɃjHQ6 72@^ǃ~|FXx?X1i,*32#
EBHSxlHȂc,LۀةW_XRXgk6QވLu:ݷ+Ƕi.|{'[oӷGm^]
PFaatÃ7po8 #xu?3aPcY~c,"0{UCR*̃Lp C&\݌]]h`(}%r27Q261]YG<M';K۵.6mבڑNufq4אX}VCCB`NxR/'pN[R(/f
8L.D[8q%z|Z|E}hw@;H}X>L*DTg{Ug;{&
A#ՠf^	*44Eԉ#}&C1Ʉ3J5)@/y:j:< AK[ʯ<zȏ;3m ]E1DQ$USU@UTU!@Ą@ĤIB	BFaXW*ա ~cJ
2Iy_촽õkqW׻K_3Oιi:
|>ϙ]/HB:|AUYALу{ߟgsoPB~Y$a+}K`4R=  tEpT ^9?|?$FA_mjxj`-Vpwgj6^	?U#KOk
TG?I  A{w냺wb6ItɁ6܀wWЈzgQ>ԅ~q C >i/<@A~]}QP<rseLݔgi~b~(y,BTA 8 }a{հ/k>߇;8c<xW
߭
Ry><i@ѯKCCxe~w*}<NE_Y08dFJP[@ErBEiԔB
 !DX9ÑQt~^Ú>vGיu7\-/=>[cm{mNwi_	м	Ҥ
45d
?2A"'i 񽚕9㐼pI%OC777\>@+c& ̳؟jm!0Hd`;72{Ll?'i=7yN3?K?q=[w~~_F0~Z(@SNT^ϧ3W>$q\<o&pv330@6
)FbE azMH	I"*aM 	3V&Qփ=s2g\6'$		XDZ\	0#ϭ:"&_SA3$LQMCC,LERQ0DIahHD${뼿x?;x̻YiC=_v?ywc[љaK[F4 Pj3&w|=Iʃ*GyBg9γd{L
C|XYIZO(?^yt/sw={d|CX5{Ŏ#ԠZ!6w=#l}vmMbss{DȠfAf͚w7WMmK"궵}vh)J;Nuކ}@jьl"@lsyZpdwܗV(p>gxz)2{ KpbÚH鸑}\9Hh8=ASq]_濢{~?,N<.
'B;pLL v8Xж8ִ'%'цju4:I$H>d$b܆ozߵ|M7昌]>NL.~[
ݴ8I0}s(>6\i2=89?Qu9Lރt͎
U.EB!82l
@RZ_MS;|Y]Bѫ@L
07&)D L%E~jC*h>K_?:A:JB*H(ȉX$S}oM!/z(Jx~7]?}yoʿlڏLer9c8s#ɆU{BMGzϗ1s>mZUV-lQ3ynSc4|+Ԡj㍱`vE	r>NYФMhحƭbd_Mz/>+Wi2?p 
dH
dfU	r()	"Sa
SLĬAI0LMU	TI!M#0V23f
%Y:puIRSU4TDSGcU%ISDE30DM&0`YKHTM$MKET4DS)
L$UJK1**	2"2CQL9~@d!Q(IAE%/mܜ,5t̍;Ցq&kW[ȫ2|0ưD^8;dhIZ7'.39:j31=ti+c/oҪ*?z͑U!jZ/\ZayDΒ C!(h׏;`[my.0˙ưƓiY#2nϔoC#K4Fs56R.~'
hD&9+n^_F3:[﴿kZ\=w
z
HЛC%Td\dp7!L

d5LPEyLo!DBc,E$T2v8ED:>#{A)2a"
()"Rf
( I$
&X	*
(bj"j)(}d! ,!i@ï2g3E.TEA$SAA
")
Z)b&"]jnLK'"f	 *()di

R(b&Vy0HJ2AM4W	U&8e%=Ȇ"h"JIj%Jf*HB)Ai#Y`fxJZR)(&A		JB%i%(*RD	BH˱ϗ?;__5|?KW"ƿ'{3aH-! fb R':P=5b#9iXx}5k,͓fR`-*CZ
!1d2BiTNCL&NץQk=5U
"T-F*n}I #Xh6\@v.ҚaZ gaEDDb3Zwf#rx!#݌4,T|Q]V%k8H*dɈ89=dƲaq]ǡN\k0hc;15frE%`"Q.mEKgl^SlDç3(k6,nKFFL)Tdbl'j7۳&pW"ӭy:	7͢Gnb+ޤqraRko{qmDwBd`7ҍ>fWN$Bn#SW,,18_hS}UqpVFuh1ɔŲ%hD(GBsdDȠ&=H1XЦEd-d'd#Ia$4']+A)M;B
	8]\)!{HteM">

fcxvzKiuϜhiϿZ&1t]{ۥ1k]8êr;4L2r#1Ƶ 
͹Ã̌;$;ag"h) E\MJ6J
N&G,q)8'\EcZ-P;3Sy:9lg֡
5G$#cFiHd a
B6CToM$|yx6
bcmWVouJ֊*9sj#k
\Nbܻc{OY``d_ѮՈ} L?6j׮yZkln8SULy)(H,v57!,Eʎ	U9G#YiW~4vonT/8fcVfimI5[9WMm{sqU1b#ojjss!xvCv`RqH3 +3(db
(i*tWlҜv˫2lr
kF()B}S*\u35kQ,h61
GQFmO'4-c
j\aT9J$m4(
p7ن:QGwڇ??oC_< )8W@$ܽ<(OX|[v6@@c[󯥾-
}.$NF=X;;t
ll]2d繶>vmLU	r%ygǝp|Gmۋ
8_QSNzmx?7σm-!äo	FoAMV`3I4R;p_`{MmzKTNy+ll^('q(ۍL"$8~6$T<vFWV
AF4Ŭm@35rHR
bUA8Qy`y8NA
[9)a{~8o
ވrӹSc6%Ӑ.&[sU7io}{{/Ӊ;ᮔl8ojʚ0rNH>!KVƶ}6;#ˆVQDRD%@PXY'gcSEItt8TS,Z:g~d`Jg*z锽iPihӬ_bwQLsǲvAU|]
8;*ؘw]uIFB8gpo#iWߐëUNdZ3[ډ.pa"ВB ^'"c `85WxEf?lcŧ˓Ks e!v}*|λ{w2܆u,
%b~/ѓ}F	$	BI#'eVeⲫc^MՕUVƋ[nx7y=p6UQUUng;UUZYUUEUUVʪjaAĬ'U*)Nqa5$FC:&5	չNFŤ)`a=+UgG?0]C
674aE	tdA;9 TdBEs}XާjW4w@uvm7k??Fzܩ\MW,fFҁ
 sB*`x-5_Vj{քP|`1ֽ4__k_{7ȻFX	p=o}ʹ
H `<ABĊhq /41(pzZ3;DS-_k׍/v~l047ΠZ-EpQ	7Q`꿛a 0Af%	Fqݾ[4
w@+dL&L+6[;6TsmJ%Dh8=5u
ozڵfg`q&(;%bypN+Rgsw])ޫw=';2zl+KPƌ$:{Q|Z3lg܁j!ny%3q<.|Vٞy?4n~|;U؃$$NⓄ?^~WGoiǉ{ُ{
vxK#?囈s0̷.M`'fq337l2c-!P6kT.VAg&EQTf73?ש３jE{z+rQXJCr{Fds-{wӈI
`/}C`z1c\F`f٦6c=\ڔph(]xO>'W}{stS?{i^уƫ2o#$+|	 lޣJ/[DdPgߨ@_ C f=2뺟L?xz7/N W̼ذtNICz>1=9#3ؙ\NX9;dU%ıfdNz0(=rkducM|ԾBLPTڪ?y텹<.)@CB{{քfJ`H+@}
wiY= kiH
{AdЄC}itɥImkTπG<S3ţt2"ܽ܂agn'Vfr5M s?U9aiq?Sv;˿,T&~O	_ 6FI
ÖgfMʦ]~})HrNs{o/S=lUNn`#0#VK|kjFx|F`"zSMK(dgnc]	u&%QJnKʺu}G}轕mC>E}N;SR ofՖfx7W.~1rhf!r!ɿ.{-VOhd4Ԗ~Ցq7=[60tS_,Ѧhyl۷j(7TkWft=Xod;<Q(LAB1(០{E#O[pݰۦ{/uE@R3= !pi^y\Q/JTW|qrzM
DZ}aHc|^
ap>=VbsaI X|P	ӛ@-4Z$zA7$&2pCMZ[Cچ&Q8CPm_*hb&Eх>μ
fYy|2wۆ@GZJF"d$d
kÝ`X"C?ƾlGߤQY?-~kϺ^o?]C'{~sc6zUmT;KAXrJ$d&$Xk<	UT;l'%[ubb$"x >S Jq QjܺahͼZa]~
fC8c!Zg'P8h0, yF:w1㌩&[)vZ0rOQOȰ"J8\iG6G FݤMX9҇>h_|^˝;8=VǓ黯sۆt@פ6"TiIÇ
;!,Z2
vTj%)xPj]<ùT40
%8?70y@mh..+M	l11)nk棁V+ƿe!Z'EsIlgBYTZc*2f.ǹ<$\
WgP̂o\	t?MWj7=؃$ A<ijkcAË$,D^Pxfmi~
2T/>زod
-ة__d?R
"x	IUmZP^ڃ)״ĦTL	65 (ԬΪVQ1!8۪<{XKB2\$ָq4QBE:I&X53A3ceK!ΧQ~BC$lﻮ9H'ri *^a	 /<U׀nU2~pY`UhQP

¹$	'C,QճϛZٍ!Y"v,P'bldeIO]V3$~}xX5ay\RBIf5~"I1>J_)).г둶Kb!c`2ZDHh}5P!q*7)gu<N^ٰS-zrD`ˤ77RL?&bb|aI)WR\i

 8"[TsX($0aQq@#v,A!Ñg9i0R͏`%)uaF_Dv#]+`<'zSEm͍9:ENiqGBd;%j!';/\Unx#>-BiLwcڪ?@}h	s/@BJ%9?o`c=o[<{};>A/I$[{K=:ջd`KYXCE8	t'LfZΧVH˿nC=	mQh>APPn2fo'ymT f#~,9s!6H8Ԥ)Z0{
Z/rVGr( #hlPDEHȐ6g^I;GfehfoR4U4@耕jg] o>"vO`ʨW;%w<b|k>{	a?_GLAbI$퓄_ň!0"B7m!NHW(	rrwL{^-6#ɻ\tݐx|	 &J~ӱh+M yQP` 5F\
ogR,5wę\xqn L_Wd:?.z㻔)y,Ũ4 XI#2(F6q*Pъ(U8$m2VVI4ǣqݍEnGd:а!|5!X6S-
LтM#̺nK.ih֝skZŲ\[_E~u2YoW;r:I/7
pͼ;xc*Lfiah%Rɓ"yI&=y+{̙&qL>1ēTTw!ǕkVa(sk +΃]sx
&~JqZÌj6gj86x#SfDٺNω5Z!$r>SsD,W7y8CZٜ,SEJ%)UP<_<,5AL}puW F-+PZgd-%;[w>R;N>G#:29W	t0Gkٯ8
E'&N6@>́wQu(ˉ#q窺#MDsFg	ٝЙWזxR4Ⴘv:5sfbd_a5jnOn{z0ۆϰPak`10$ XD`QN,bX`4DDFALoK-9{53p}`"}waZfr_u>8:8l 9A[I{gr-JPi͸4/5Mn׬

7=_AZa%av}}z\6}0 DGHR,(0"+܌=`@޶"0" +!AtF`DE
<d9g|e|dPd$)HHN8+"5SB(
(z<]\2`-AhZfw=\tPz̕|j}A#	u%DIa.9x5<䮇pxkxM~rc#
1~*jK!ڪY38?fXAzQ{x˙D;'tGokBL.nJP]w3Y37cv׶[}ְ˹;Lmޱ%+a`蠕߻_O?/K][hɿ6Ģ0:_,/sl{K!zS8!ù̣/İA!蠣HPBB;%6&k
.dh7];V`duqyfxc`LPVW
䗅(;[5C!.p!DB~4ZPWס^/gGQЊ=qtӷ	->F;9IYSLf<!v"v^a{Zup%oK44S-`|QC`<#kV#@wC!%S(x~z7GwLzlT!	]|Y.Xtc>`7>Af|cmZKC] HT]j#$Xqr|2SBv~862¯
<=>{_u:[G=k?? =I'x<N}O)?kH M2w|vH'
lC3*uZlaٙ{:r<B6̼F:VsÞ3ڳ6HZm6[6Or
c%]i "i;L\ [Uiz9z!c$0c
lėU.<Foh't?r s%UQUUEUUQUERUUQH8DIXgBȢ=>hi،	&>6d'o؟4#Yҳ<o{}xG/7Édsh9J"б"<U
LTڂc@>8ahAT
mz
[N}G7
v09qF39aAL@íЃ9Gɉ٬Qx!
?	m͒7墅^ XjHA
!?6$W><b:!B#_sAG"-=Mbd$4%IDM0,e%RfI
nյ>!_:?6>pC_M۷i]
Ł<dd0'2?ƳNvD?!Vb 5DU	<ZhJ;m(?.s۰{叿5Ϡm^{d+;
glB)O<4]'
@kAG~b7!έ 3˽>:⑻`%!R0ޅ OaK-AG,kc<kܢ#Bs6@n8<	 TqE6a(̝,?F]7f;ˤQ!f Op~fAPR9aÃ&
ȹr9PՍ^!Z`	`عcg`71uCoxX8fV"(	eӓ9*I@TMo:`Ik zG5gg+rdC.&>^!3Zqyw)(\Šp"PK^X;墵drN#j~/meRwE
QlLK]-IN !T ɰC^x5f3;bq<
	
jPsR\MP_SЩC-N-57O2A^CY/
"H)B}P+^Pd|nRM?F$w"usR@68ďAB}T30P9tpӝK^PIr @tqӆ9
0/X<Rla:
0o
3^SA.bZ='Yq F}GjcĘIWƏ 7#xWk*rKX0B`8y5IZƜ-. 8pvjܑe4qKsG_)3Dy/g*&e.|_NӷӅ~tۣ|$>|Mџ]wpݦo,裫$>9#LZn%ʴ9-^ҽDeڀ5DͭpGǶ\ԟp:{-nOUe]ώB%("u=
jSqKiU"QYpaT}"#ךa7228t>^Wz8yB:>wSg33O -Y禍Άl_=.*LULӦ֍)_v[	ٶdDqGcv]Rg:#<ɏ`&dވ	IG.bCmEt3,9):mRiøމ*(nTVuY%XQvk֥ywq$
CAx[]6#T>8EKG<ƺh"o8ms9ʎa{)r~ꝯwqRWy
l:z/>|
=M.~iZ2_C7ÇsՖ㷛=<?HG_N
.]|its/݂0o
( Gagf"3{Նk/Pf$.gT$SwR#,.6p6|Ul`D[91\ݺhξvQ-@]giÒ x_$E1 ՝7'Խ6zU{0.]b.W)TV\ȴ}=?XMkgSsuj{泿T!!Zx2w\c?6\9wFߦ:*߮'v$A'jܰ;^ޥz{n<@>tc#>۶χ.yp\({7 \,%Gr|x_ؿ8=!ߞxTgkd7tW][="mÕ{ecxso<suxܰ(_]ywP^}ESz_?2zۥY]ƧVR˗ZZ4_Rz|܎BKw2>,^hυP[܊^y]jLߊڷ9f-gdVoCJ(Bd2b6x7o6}q߯j-˩W~nYqtoǠ;+4.{NQU+~u(߾iO7m_	2Y'C9seU~_?NJQZn	N2&V@pÑ]_{;C&P{pv)00gVи\؝aJFT3\gݚJP,@R*-HX(RDDRJ@I0A@r@jH"{`D^[9([L
)RA
ܽQKlE.@0|- ߡ]N"~\dQ<^WuZ\&se2{*"N'e.阝]GU4$A"	/.⫢-}ۥBWg.\݇җ|Uy-yܾxzv%&!קKO"W9;YcVGKb~|86ШW_g]r}B1(|S4oc؟F$7s_P^"V踍
@I l/9
8 H$E QFk%y&ё|-ܤPCUOJM<}yӞ/>64$wȓ.
B7,3F9L	DMŎ[~hq'vP&^53Dѻۯ<ɫveTt45yswށiܶx֜Mö̫ݑJ
cՋ@CAcw:C@4C04:wNpEJ!F<#o̏Hqvkn8"rq!յya>| 5"tth*Б$zzK;mT$iH!DeكhҘm0k$61~%)TsƕevGoxt]̻pl%8H0˚".Y^9&x>-sT6zEА4\%"#M'9C*B!k㷭D.:`%,K(i5zَ	!6"$؝a<xB(pYrU8ĥL&ȨJpb]v9:e@dayb!AphN,UA34ʒD8 nbns#}b4hsPa&D@بke
<Jz/IjgYU{*Cғ¼XM!,U L,,jEqflLCaݝ 0)^m&CvTwiV8ϟz`Y}8Oq&"_^i1Lq3	`&\'80b-AZ0Ô	;m;8@fȒRB;33hhy9fsLkgl0&CVhG4TR96onhWof?"IOf;i|tz/Z13(LA*P7
HJNQ4QȶG(
a&Aցeĭa[~kg4&E&G6[#[BfIe)	
7G0[?VXgjD:ؽfNJ3L!fթI=L/2s5QQfk֮8306_}/Q$E s#QTMTfADBDR> v(o?Wx%۸FS%smd!Gkl{].'͝v]RpFaTS7SFB~#
\)*!ф"2RUXϬ<M_XrA=+kNp>,B¡Z@M|qj4Qq1l8;=Wj|Ԓ!BSҞ~p{HocUV0ïgԴ1͜^ת鼶Y)Cs^lٶLRV)QS%ޞYK\*χCf? 4~hH8Aiħbn_rT$P'Xvߡ_h9/=m`PlHRߜaxLo۩))(XD2ͦ\w0&*=ou\m;ٙ$kǚ
r6d.S)y9DmT^b>L:ޒY}$QT!yq2yC<R)MgfW&\ZmÐrt>vgũuo
P#^Qt夃Q)O613N2ja)ZW.!ɘef0O4oEy	0mUm$8Q/	.1ES
MY 0S_zaDypN/;c59B٬3ӚКLm,yILlJ7Ol/HwߏORZIhh>Y/6C&.5ec;-]Ek/֋hóGmB\¨I*99TU~Rg־=BYO0:P]$67Rve/yOdٽ藪1':x9
\߃%}tқqLP~ Fǅ_+<` cfϽl5cwwZ%,Fnm-d]M
Hٳ",8:\z28k
!~v,kdd"Y$Kt`#9,:X!90H=8QlQ{g6czyKl VL fAs\6Xj2G{1mؿ8?]Ҽ	qI&IMJ*yS\=QI1-^rlQ,K7tFE_ӮLxb6VKtS<݉㘢Pٰ5wO:N*cԹo䰟t:)bG*9̜үWD@y#;#1&p{ׇUGq3D`96/~+LH͵I'*o/_akX6dm :d DQ:,X͏ &
⋢b1_PZJR-)]X+3+\RXl཰[%H$1v(B15ŪpzBCtǂ=\pJ*p8UE x("Y$X	6{Ahׯ=w
T
vA }C78z.Y5tAC&(AxuCs`iυwmV:lF6_KMuh˃`geyr,0\%XpI3GWx	.J=[|er;#o w^_1)F2ЂN=w"]K*J/%*󊰂vy&re``yj2cmٯ4"J@9N^ l;٫6Rvm6oVwL2&-7Di	 0QlN&8?&ht;L8c2IRs0Ad6L8gvܶ]eˁMl69^sf*T6)4|xޮ75vYmch6a@{C8/OH߁-yDAN^EU(`'zn
bj&t[5mR,wVK
DiFȃW✣QEIO\c]Mƫ
|}TNqs]ΙfKTM>拜'S)8?ls[ۦX?&r	.ٶn#wtR3@`w8v$z Cnrmgx/3 ,v<c1F>}ݻP55})K~@CIP<;Q3zEsgY?'p_W'ls3zع>{3ߓY@R3]K_qy }9h)eWk ^㣦qr9upASWȄ3Z2
=dǻoH~]pܝFъvݽ9G~5@<4%p]ֻۭZ/ePP	3Z%Ts{s|9k䜵`qEѓ#ݨa+i&uQQٳf͚թnc*tM2ܴOX8e5A_zf-w{w.?XIRn^jÙ<>|Ǎ\Ebr̗uhC#x\^_9z䫊4I"
baRzo~)΋&Gs=tZD܇zFR!V$tr{;2/΂{:nמּg(YaIH
	LUskdd^,Pz!,@a5`<RUWP:z #tǵ卫ٶyM}1By>tq'hB_ӿĭ:dsZ3&$Wwo5~B9XvMy{QNz{::-MzNbѱ\:m⛵w&7?xp^r%eO:*(IxQyEK/>-싳\zӈOuT֒(τ?Lɻg:w=.h;wwBЕ`mOOWfNlq;'Zٓ=jcVfUR],)GE}$35d?DGW<
nHk{=W:mWտ'nP4!'5qFyr:fG-7¦SV4MO
I!l,q|m!:Hv!o!XQOW҉NGO/,Q#
lf0:@~2w_hAn/(\jOrkm	larmx0̫MdDPBaț/!f Hz;?z =BRPA*,/{1.{t$K/ؓPa
t#^4eqҒ38#>!;g9c6Aq`-|u eN% xbƍ{!0[LLLV-2=kX䭠#DHR3:íT槕tn
7vC;tw:|׭}<OygӶ6Tq>1C Z<9Bƛ\IG$JF\@*2U@wϪ3
]QRMza8Dx|?Sz8y6"#
vC7}vbߑr5.@n[ !1gr	EBP.`P쉣 X.ҹHfd;P?3{ szsd	 @O#<<XDT}8p?y-A]WSw3sp@=w
,߸l]ݒ(6SƔ3n
IVg>em{)ÇnS6Ѹ\u9lXr0؂/vTjYRiX4ܴ[o^Aegxsd6lͣj!s4,2N6mUdgtcg>\,6k\׵6$ANϾf՜kf7jڊ\Q]S`s)أg!z.te2Ӛ<gk|:4ؼCi#T3&bI#3jfUE96荹hGr07M2¢_V7'վRBL:Qcfn,+,i0긅_KF ^/B֮DپT
j	㡀mXeS-)6!a7z`4$LT˚?k.@IЯ4,}>6]O1	'lE,3U*K8Te;:M[u)Tl3#Z)ʍ%<p;:12R0#I14Fژ$]Ae3@#͎UdzT!gS!YBU`M.m\Zk>\gQPkfw)$a԰'ZVWcPh)3\8g7q #1i7ʢY`D5 LHq){ntkF"*afȑݎ<ddKP䃏C(ǡ+AY*&3xbšHIsp%>ˮ:/MfdR瘣_:!\t0^7F'*a
OBC]둉 Ʌ0R\oqhLR;\y(z׽O~2ԦRW)ua+o%Ѱ"V
($&Dx]He`A=ɒB-bJC05[@SX.f(Xdto:2b w8XLljEh7=TOF
-r֎(8H j I$R[P144!>H{Y~g6`cx03ޱ.
,|}e},.pF""ОsW{~n6bFhnxfu9]L&#5Rz	p3@9k4`oh"<\nh[6H=)7- ,!k
)0]ViDYehAzu+|A(k/P $ؓw9d55DT8IT0U ##S@Kޑth	:HV2 
D[B9-k7NO?@00 @h@```A#h_B{
 	E1A~H:C֏&KE%5?rbbzSC阕bTSe|M
s{\@`bP+[y) sD^ç3Lek@:RI0@HC*T
/?q0>y.o!*rǴ0IVuͦ]a]3ƭUq? d)4R7N
i
Ts||\BuK2e9WᑊXUe&cɆU1%j!7JT! &H9_哌xAw[G>kB$+$<9t$9xJHhC$/^0(I!;NF	C
\=OvC
)C$sFSp{ajJ.=43a4<3bp߃1
Q[Pb"
Q|{00T^ȇƌ2C :Ns>/(c¹쟴,gl\l1!+Z\n#+VaF;\DC8$Fie@#zqD QM=6C!vj΍l?\ݸ8H Q鱁}แ|P:'
be%!Te0WPyJ"3oY
!B{/Ouo o30$ts x94K:5Ԏ:Ca CلOI~	IbZa`'an}}PJ*ƪUm챱ϗdCCƝ=øpBp:[ ];Jí̠/()$$gb'MK|08*g E;^ݫ)X6mBy[6 lPM`յp}wUA5 @Ѱ.Mզ0|FM ԭG40`y[9i̔(K
62NkCa^*9c%d\19z;IPf!(`vCc(ǩGQLBV /K<ʛt)vD%"A`#yJ)D ')e!I:u!Bȓ!E/WyyƳq%4hD`Zo
/[)g$+ 8ȣx@F9"tDfTTt"-~|vʣy`&cLtAg3[ljKIɹ;+Pl	/f7pĤtH1(s88vwGuBo)H__Xd\P=iSp4 `z@F$;0ٓ]=
) )`LDh8*%1(@ ]ڼm)rQxC>ȁ`k
VH4	2pTJ+Qׯi(]U# `w38>IH_k6U[(BvwBɜ0l)r"șT- "<)EAc]5<!߽IfB&r
;XYfA6ϺfpF
em)]qN;4)>g< :rYaǷZՏN0RU_e¨ʵ
wAd"G400RZ(@KcݎV/ǣ%=z΀`|~U
l8`@c%͌pDZ1"Buf÷3\Er%ĊPH=wy{vkU`h(z
lc8*FaeKRIz3l`TMlv8w҉ŒCɀs
arN01=_њsugt	bȐTZcaGK?[`oL-acޱ]
gɵ1:ⱗ+hay~v$˚ՂrۀntH<>2!\eGuBĎ:a"VA1[0	$&̻KR<FO6$ a:-C@
Y;#J#
Ÿv"|P#fTDt,*fVaJl	)rem= p"sQ\
s8Sv"u;U_ٸ0Ys-#_ۑT$F$OHܹ@q\mq<&>;BeYNm%Fk#lΠ~0'Rd(6"v('		d3ߵN&[w_61D(@M]^D Ӯ:tZj55́!DX'.9AH1FR(zѤBbj<-a*h3jKZV	Rl;PUX6'
#SCf86**!Տ2'ΌfTTp2IB2L{ϩ3uE{{ys2m"hI𸽜fr0AYNU@H5)fҤUk+:5"/b0{=aB5n63Ġffk)(#*4=i=()(()
W
(I :RTW)B
:r5:_,wӉN4:Y0hp!굫֡;

72j¢CIܭ!p	8,CCNnrV$>$5&HE.( <^Z¼t. (PR`AP-Q+'f-pO؛!<p86c
`k{8f ;
SHRu*7&2rQͱٓWO gտg90' .JNc=Dd9bbj*tE :@3@뇴k`sS^U}@m<~O[\@}0yD4ؾW;-4ԑzQ p{ a2eЕ,kqTGpV)*Ó*TH*i
&6@@D)Wԯ
;>>{]Pa9^pxð~ =*xH9JeNt^M]GPLtӖ"!(^!.mN88x՘{-
h|AãOpz0p1}TaS8dՁ"$?#heڶ]evҡw
 d64[<cR*~炲/chۖmtd&OSB23LK4ôC11s_>o>{߱<gX[nD\2GަGld@!+*'mF'|)g#o9]#lqp<#qg[î|ymi:Tb0	r=>FB*J.?|en@V"\s_гsWZ*W(sX1I5^fą#TqɈ5[mI$)j **(haAaF0,%Z۷MX30d4$1&&iΜ.w:/[dCHk@,{LM\ƔA@&.KC`wH^s#h{1%HX6Cvcq<$JTvvwC[д45GiQc33:y"("s߂)I3j**=bu;3s6#
bl"YRppa\ 2RkPDAo6/ǈqpN̸
eAfrF	V?D]@Bir`(? FAZPAD	&nC8(9aF^ҝ`LES1{
~L!HGIBCZ"%@P~L0SA4
FiԖ[zs#~)!~|L7v	 $OI"|U}4R:N׆$c̳ACH/xvzGđpp6աiP;u9"pn\zLe[ ~`0I	vy}٬PT4V
wj5CR~#|*V0l3o|v9	T$1|x@ ́	GN^<

$^̐	&2O_[
_iƝ6:G)"Vu(x+\Ƀûn[^`ӈGa*v<>K%fXD	CBwRxPGa+Ac`r܉	"%(v\na06ۛB$b*ET/WLjc)X#ݬɬ	Kh]DI	f3K[!Tb hx]Hh sxkSG!aކ`l`3$	4=Jé=ل&AWŜƭQJSRi'NB
(L7m&8U
чk;DF$@U
3FƃL$ML:5hmssVsSNCh&؄RK=;;nnrrDD@@$($:tN3XaÎ}Lafn9+`
kH-7rCSQ G6	@ZT(~/U&ӅOѰ@`G|ψaqPhɚotȡӛ trAȊEO=B
Ȅ$	mXqS;ʂHcwPC?;AKj#} qlRP[Qy,; ;8Ih7&v8@: 7Q<62j
F.4ca%r)PL)Bd$\Mݕ2TyDE QD@A0t\GѠ']SX=ؠ ^CLM<>ԃ{iGpGi	U!A%<k>BeZA`(VD #2 b&kwFl_I_@ @phH%C!"v9FYʌzhC!=Ahu "`@rk(|w,"<&E`@`?<YʄDJo҇9s8ruapz# vFZ%c2Y	/4ER罤k\LJ uI4ȆTC!h]@z!dPCLa7LՐ 6hRcKhDCU`/p|^|l[o&f[vv^ن.g\<%A9V:`,1zĜ<87"o |<$&Qd;j$LZ;YVXpYfltїuAs[m
$ ®2 E9V^4tWT
%`c;`!$6<NcS.-HujKCs:t"7$<$	nj5Am@ՙF`aFdDX$!$S!<HxAhS`t*ۍhb9TYGD0BKni@U11oxby3 uDae.ҋw@0oΏ@#-D3V"ڏ;H,Bb&xDrxK;cgB9,{Ug+u .<JxBFI$	 tB֕]0 ǆ"S~jB)J%
ҷ	X[MYfdo1 /g&`~s[VՑaRT1eff#>Tғ?IA{e$H".tzCTC̡
{*=0eˬ#IRUb)mDpGT*ܪp]@T*~ּK֡L9.Z,
tSaB!3ȭ$
RDЉ͜٥> 8j6 @
c0X(MAQilUMkL
L6g<Eֲ؁ˍKծdHw$j 
U3MO)a
M$3Vr:AU٘.ٕx l^h TdFOC!/MXKm2MI#&pJV&.r[\|;"/Tc<S>s(u`B(@(w<0$@*\?}#;[rc	!
Ny>|Yv "Of碆pGcxx,5\X2ƈi& ]8@
A,Hĳ& Uad5O"<-9M8;Ry"
Bs!L6{TE9El!%
p-D^GM\;bp~<]ppC̉LJ>XhsO0]:"<\&eǨVRZVלՆVn6zˁ?{bmrBQsٟLզsoday	Laz|5iW mο)k79ݖ1sqΕ-X &hc5Ȑ	!.@B8G{OÒ-!2qv
Èv00zNѪ-Vb."ŇbĒwz@|`ў} L^
(}F+NHMlڦK0[+UUUUUUUTUUUUUUUUPQE]
E˹4SLDM@DEDi6"(db(*ncy4Tbgű++-A^se푽5~{U(dp[bD0ad*	$hBL#dI#A{""
lBYBbCuYJD_2h,T
Kxd&W"FُG߻0k.I"% 
	Q޻$fjVUoZ9jyrf\i#db@4`+"(~rRL˘ØǗǉUNۭTCTSsLHwK=E\݂S*AHFqRLa:!LBD*&x53dC!s`C'S×uᓤ]YfW
(75PfktWDbn/ t%L,LzD UdDg>!9ҡ"儋Bvmjbzݖn.`EU[i%:k20iZZ;d[nu22 0HP?D}MB0]%}:H)KSB{A,XZ)HPzc{$"b|Ew)%A2Gֈӡ LڊK_zxVGX "i"B_}R̚;;yC"R.DG`wCiÛ˷rPb4A_ar"v^66|	̩M\EԑP~CyT5@]bfx
))2Vۉ=bANEM`BE`eB  Ge=4/H"e<M8d:Qf	l ᄄ$CC
|vLXY|_M
) , 5
#V!xiCOL!Q1$EUUTUQ@y^
Ns(J h  }@M t]%"*Od/0HbC.}#3!$0C?fVٞG%S4Ua,HiY0(98UHLv@ģ=- !%A)yfZM͏ӊ ',h #c
ӿ/pԛ舦R'm],Gl.ϊŁIx^Z
*(  N1 Q[3,K]ˈ_B^y$=aBA0d FM-K(^zI'*v  ~srQ r6Lf}Ovz8u$@Mq!pؘmHQUe4,К"Y[AQxx]uGECּ
ZHad$vx\|]\TLp3ڄ8HdO&FBrHF#yβn;#ljdbxxfd#,K#
`Q!_b wkaadU<BhI.nw15Ɔnu\Z1EB*ONոtBD#
sZ5xWq+W
~!6~Lx;|o
T!  t<|H[TJ#LdWm~>n#
Q$`FXpD(y;
u݁zayG%	CJhCGaCR7pb
F4'_*Җc@xg!]Mk)d#0W%T%t̙"
&B?i8]GM"ă|d;{[@J
Y3NydRYI!a { B
+^P}p7B*cީ	"xgH0Tn8I	!#qO3A˿ZC؄ 0O!½nX>x WOt @ |_ԅȤ΋@~5R;
 C~A=rtaB y a0s^p6I!))^Ԟ3``-G>Gu0X?tQ>۾1xn_4ITx0w`TǑDuɉٖo R"cJs8=%,&]6sbHKwwFI$4ȃPaȯ-+`b3@Ɖ[~y_zKBWkC]B%gyfB4/aC0],˒{c+c`!fA&q$#Bi1" cl0bFၧF%""RnL$܀p
gyn6'k-י[rAK--ɍF#4D8vEIX`u3,r8CzJHg)
"{@yu',ٽGh@ǬM{+}˚~Q-%v/:wBg~d,!Gd8: ^
iQt=M:Ac`fJ0B%Dk	#v6BXh]!8Ghmֆ6$GF`03+*!Gx~xN>	7}鈠+`>BW!ׅ%p8NO0uѡ4xAE23
]
mx^'Y4pL@&χ%0.JeKU"x+TZH`:mӳ()\XgQnC߿Faش8Ih
<EJ񍥋jP
1Z 1

b@I.@e;jیhbݽ5Mi&V6g-#*IP@h	O<(wds78Ʋ׍y6M=) 8<KN<`(Tch!1hPqY,1`PG 13:h`#)%=E%/[ؘEO1s|v6˛_`񋷬O>m6f	0^UeAǱEv"PO :v_X5԰`7:&${)瘡Qf!}<+a?
UB$&I*xq:"t[ٸW
k߳/
ۭH4 k7́ `a,ڧJ3d*CjޡF3-Cp
y9`=\HvmU!==*;٨6ʓ֒/Cj	=$ꤹl6R{YSgbm*@ JLؼB)
R	ظ2Cbt{rpXӘ@zxr_C7o|F$v&NHb*;~BNU `թI Ij927ɱ lq("B	°WH&@
]g77]e;6
cQDPBCL0lLa5PTVzMƈ28Oz hPKjgr
w)zݎ'/b<Ĥ! ,Z<@K2!o{>ku<XB{W<zƝ:BebjNWwHQlD-Ehaw-HIV8>q_ؠAZB{l!h@T@a }X֬4KsSMxlJVuN	9pY]RbM
?#)\MΒ^3B!ՀbfH`35)"Q(1S(!@HR0urap,6lQ
%B-y!c"3CwV`!E)&ģ%HPCІjlX
A
`
LS/ Cxf+!bOM@62L5N^^^>#"NP_"&U<NNKH&%9@dJ
 HZiDRDM mPp$cjIN i	ER J ΁Ǹ({6W_y<9zmJ=*/juC @qiX*d8S@8=0Ta5՘}dv{s. t5	tpO!r:R4`& Jb3@ jOt@"ׯ<ҏfA?DmA>A>aOoqbq!eRTQElTZr1;ڏHzxJAl	dR=e(s.(s9q#*MNļЉk0yi#)hb6o+al[MmuGP	rŕB@s#WN`>kB,liP))jc0mpپ&8E/nwu#c!MPU %r!RHRQNC
}"`@G@xfʢ6جԈnCy6VH=C=ȻxԄc"{ImkSD
d}LXk'B$+l~
;^@sm3Or#a3g1e
?L)H2
^3Yq,-@hBA+,PMtН*
hNL8<T&#B ؃mmlda_Z*;1;bd;$P,82	,,
zgQwÔwx!+Xōح-4hZ*vJ:	=Qa3a %!gb6h@$5<^BՏ)U	+2KeNnx 1T@usPD.["y7-
7E$7`l>GebWǜ
*
km10l&zҒP5Au[%=d2ِ+!v_YRM ƹƾK W92Xi""֢a$L0B E rͶ
V(1ZqٞGX$p3aN"od*)пXl :8
@NhΌ|/=t :	4$/a먪2o~%ꮖλyN=ߥd̦* %Dw2n%pb;VJ d	:G @=v, x@SC}yW+ct)XŌz,?1$e|4pXY@Q%RT%+>0;ܷ9A9[pY5G=qltS	A%F{J`h3pL$`jD@f%ł9Ă10YBG#PUײؐmiɕtŝXG<+BDZw'lAa͉a \	Ardu:id|wbz_&P6W4-SvҢ@L4id@n&B7`9̴&Cp
@|(#$BGQ;ta":>0;Ҷ! d(LK)74-E
s?7'Ҧ|?a]H{7)((L|0!{;!Ys1Xs3#xP)vU09c<5fA0DC]\m*W^܊@m+0LҗH86J%6]H1 `5c.J"TV=t8/^X@/ioQD<G	Y (U^@v dSֺ$a`@J~b/H,`5P*("+ɂpAي{)u~G72ȡơH;gEȶV^
`|22^10] r|
iP)	D
TTU
D"P `Da&	 DE%弝`^|#`^SH&H 1%Vh9vf5E+yƼ~bO/_	%dHֵIYKXM*vM0T$LtWbh0i
(]7%B
9
QB4LZ-1~-sIҲU4;].p5̹ZWd4hP1oZ&V5l
XYg%L\V qd0&fPmӵoA31Rv{J^nn
QuE_c
H$CLoy`g!WxXܔGً3u`7;D {
"OȇX{/u.xhKn9<n6@s?HasqUH+DuAk1
\uXH$<%7aCӣgђ֔g!O$ zқw0t@$0
\;w|)CfFA9K6	r_VE`DK6H/?:~VөPO7-gQ*Tl%*a5Ą`A`ol=ARC^BrK5N
AyHDd9
xD$.p\Q2S%D0]73z |ˀꍶ!!ļ
ðTSK7R7 KhR!Y
G?:%T"I
W`ymwz] 4s-8}1dp.FĽQh6f<ie"{Mm:Dg 	OEE&{@f<HbM5fC ZQŊjo;vEUWtd!rU%Ւmill'J@}15Y&@z_ r(dBqCuM!ZYTǔyCq2	xGs` hIE+&"uDmڒL(`C[
* q¸1CZ#a!66
l+Xv ۢ<p M&vNl}U|C(64_Fw<{ B$;mA~$a:XDMs3OhGJrn7CL>xFP=hrMz27M1\mՋUˍi&3! E.Wh8PDv-Z`fLh *!H&!>CbOwxs\P$BC,Z3f\fbISK*ʛ4CnzKw]̈v'p:šmrtЇ AmUĚ,b+Z`4q$'΃XzsG@bA<AOVXUQsFNl@Ii85MA] 3"e2]GvD]S! Q:D<8FiOM
8FXƱ4ƌ844ezikr-¨5G.2BP'̬'mV%RʣRpzkt0pm4SaAlDj7`bi6Bll1$R RDT(4WÖ@O$i8)69)
À'4T[Px
"ִ	i-47gfilM⚠t=
:ŚY]YC8w31nJ-Q]5yknjIP	xCG1,ѱbATz8 BiR0N&@˂P x!p0  lSm!̨DAXEKƂD,u}(T}{<A4=`D`ElG` 8!K~Q1 CRp5PJ	JFVXd.yTH
yCeY@B|(yp*2OR!G56,T=c	b+KS!rq0aOSW A֯՗pN^@`NL+3tB!ruUvT
B49X&E>p#!] 
BW0:]&P7+`c<~p2!He)Nn@P053E^ERC	133*d:}}0N@T6Tchv:*j͚`XY<0H܎))oZ};H<Xl|(vSt2"L%4όiiWOy\%ORm9=I=wЃ	T%3&׷N8F$=Y^9;js`RyvJ-4BV(.nC	D
(Hfd(ـ a()y969؋{0
ۚxcJp{^"(	(*Z4eɛ<"	eǗ;n؍-壨c
!0QIYŻ䆏J('E 1HENȅDk7
{<^詠'ZgubHX?U
,\JLGhM@H0溼k=s5zҴ:>S iP҂J 46E!ߌۓFFhl#![Pa#<sa$*{sP4|zbXOA@*'@m
0׽d|FAs{"R
R
ĐB!V=AWPATP*Heteeeo6k!G;xf)$j""bHaD%! 
?l(zR	bcA]1=kOb|zœ 1h%{M&(zh	6=(C:
(>x×]*wȑ!"`(W"B.(^C6tL&^҂ƫ
X\x&dnHm>>x
k-TZ>t^|q1R{EѳqpCA֎
0eh9`
OUMeևEC$,4N҆Dt14."QQJ;l{hHmKSy\}`4EVLXd_Nԍd zx_q!цKHD	ؔ h%G	O0Uhh0H>R7@BP#c<N#ݡTvka>QzX.KM\Ʊ
(DbDPRن$EQdLDScc$@d19"ZQcL>;B<|(W$CAcvfb)~d,P(JR@HxG4匳U&$
2	qVMItHĝ`rZ {΄4RЛ@:~2Й&lCmNǯӛnr"->Ҟx\oOH]uOc+&? ` =QړrjnXz<N3b~`jw6l5:n8-۵\ԪSX5(Rut\Nq}IaKk5SUAQ@v.!ϒ=^ +!9<e<^yp!0J
[v\hFAXT(a*Rd (0C(1hT9D:$<iqJ5`mt%p<ϊ'Aq҃<3Ό,xq3Up6ڦjx3;!|tm60^~YN4'31TCMQQAE>퇼vg.{zZq9;m7_adw!z #	ԡ"ر?b?2KC|A4ӭ׻녊/p!!gv+kB E0xC,h  <3f>A-Gxd\C1t
= 0KXq,cy$!'b|)d!ƹ]?_]luYƝPI*4MrqPEG Гh,ˊ\:'ʖuQ glV²ui*%	V5SmA"蹫EѦ3>d0	r¶>Iq2mU8!Ge:ܓf(ƑAFqʥ1Y)lsu11_UpѪ6K#*(NPGs7Z-F
N3Nu6`ٰS0w	2,RGNشeQVB.(,W)phU
:II.zs84`zZ7GXߘ2no::{!c`cTQDCNժ0퇟o@+`UD9E8XC#7 _D|ϼgRbW?nds-7m^v8´jR6^Plߌ {OdrFG=f7Өb3;`p.Gx
)xU:ak}żt`xqf7y|WEapF8*,+}BJr?zv 9.&]bb߇⋘kl: E@ѩhfpLb=o J\42z/msspP?[jqCSbђ݄qE8OsW>H@ 4!>0:Y|oRoɿbacYSۏ=!	Zi@N3dMA{՚D {>E_TqĜКc=1>%Cmr@E)*r߱٤pm!Qs~ѳF
~Y7!o:ځ`׍,ڴI5$'StVlBsP_hhSW2#=O*kѠH\
/TJcT$008:Yvgs>y[ , erIcOɟ
vŇCxersgθv"$LLJ<\ 
!	kGLƸr-fANIQkCmag+.p"ڬj2,`ZvTg*EـoʐwD!uP_RPą)9C6y B21Fg%զ+w]Ar1
$ `
&&hM'M)}#*ʄU":wI#(
jtgLC\\UZנx۵&UMcB?o;o;9}NҢ1ŝp0w
n诩pz-sҥ{u*=C4_>LMJ6}+?nq8~k~ 4OWpp؁e	=/|G.{Sޖ3Yﾗs#}y}b&qw>=<S;:
}+k|cCz!?bC^tI97a,?i<zy+		dV~cq܌s <yN6bq`(a} &N0i%g;釿	?XT(6fa""/@_~w|܈fffa#s;??zg|"
:q.{m}Q3UpNxZ:mʉ-4I'%E86Pl>b > ~C' ь"!R\ `ǨO@|l8nALPL
Ӝ0ZEA2IBMv~0f/V
b!-u3RIUgwV(3Ég±9mI[  2wxD`Ie)B3$-G/|J#-mazT(gܭfdʅA't+[Z_-Mkk#bdQ7iW4|LS*i_,D'&ZcZyԃFae"
`0ǂ|S!qCyq4@Mtzp(&YPBV0pnJ ⨆*t_Sm#~uU_6m	&Лmkyk뮻ma& d S@44444)CH4.p!