/*
    File Name : winerr.h

    xHC Utility Driver interface defines

    * Copyright (C) 2010 RENESAS Electronics Corporation
*/

///////////////////////////////////////////////////////////////////////////////
//
//      History
//      2010-07-29  rev0.00     base create
//
///////////////////////////////////////////////////////////////////////////////


#ifndef __WINERR_H__
#define __WINERR_H__

#define ERROR_SUCCESS   0x00000000
#define NO_ERROR    0x00000000
#define SEC_E_OK    0x00000000
#define ERROR_INVALID_FUNCTION  0x00000001
#define ERROR_FILE_NOT_FOUND    0x00000002
#define ERROR_PATH_NOT_FOUND    0x00000003
#define ERROR_TOO_MANY_OPEN_FILES   0x00000004
#define ERROR_ACCESS_DENIED 0x00000005
#define ERROR_INVALID_HANDLE    0x00000006
#define ERROR_ARENA_TRASHED 0x00000007
#define ERROR_NOT_ENOUGH_MEMORY 0x00000008
#define ERROR_INVALID_BLOCK 0x00000009
#define ERROR_BAD_ENVIRONMENT   0x0000000A
#define ERROR_BAD_FORMAT    0x0000000B
#define ERROR_INVALID_ACCESS    0x0000000C
#define ERROR_INVALID_DATA  0x0000000D
#define ERROR_OUTOFMEMORY   0x0000000E
#define ERROR_INVALID_DRIVE 0x0000000F
#define ERROR_CURRENT_DIRECTORY 0x00000010
#define ERROR_NOT_SAME_DEVICE   0x00000011
#define ERROR_NO_MORE_FILES 0x00000012
#define ERROR_WRITE_PROTECT 0x00000013
#define ERROR_BAD_UNIT  0x00000014
#define ERROR_NOT_READY 0x00000015
#define ERROR_BAD_COMMAND   0x00000016
#define ERROR_CRC   0x00000017
#define ERROR_BAD_LENGTH    0x00000018
#define ERROR_SEEK  0x00000019
#define ERROR_NOT_DOS_DISK  0x0000001A
#define ERROR_SECTOR_NOT_FOUND  0x0000001B
#define ERROR_OUT_OF_PAPER  0x0000001C
#define ERROR_WRITE_FAULT   0x0000001D
#define ERROR_READ_FAULT    0x0000001E
#define ERROR_GEN_FAILURE   0x0000001F
#define ERROR_SHARING_VIOLATION 0x00000020
#define ERROR_LOCK_VIOLATION    0x00000021
#define ERROR_WRONG_DISK    0x00000022
#define ERROR_DEVICE_ALREADY_ATTACHED 0x00000023
#define ERROR_SHARING_BUFFER_EXCEEDED   0x00000024
#define ERROR_HANDLE_EOF    0x00000026
#define ERROR_HANDLE_DISK_FULL  0x00000027
#define ERROR_NOT_SUPPORTED 0x00000032
#define ERROR_REM_NOT_LIST  0x00000033
#define ERROR_DUP_NAME  0x00000034
#define ERROR_BAD_NETPATH   0x00000035
#define ERROR_NETWORK_BUSY  0x00000036
#define ERROR_DEV_NOT_EXIST 0x00000037
#define ERROR_TOO_MANY_CMDS 0x00000038
#define ERROR_ADAP_HDW_ERR  0x00000039
#define ERROR_BAD_NET_RESP  0x0000003A
#define ERROR_UNEXP_NET_ERR 0x0000003B
#define ERROR_BAD_REM_ADAP  0x0000003C
#define ERROR_PRINTQ_FULL   0x0000003D
#define ERROR_NO_SPOOL_SPACE    0x0000003E
#define ERROR_PRINT_CANCELLED   0x0000003F
#define ERROR_NETNAME_DELETED   0x00000040
#define ERROR_NETWORK_ACCESS_DENIED 0x00000041
#define ERROR_BAD_DEV_TYPE  0x00000042
#define ERROR_BAD_NET_NAME  0x00000043
#define ERROR_TOO_MANY_NAMES    0x00000044
#define ERROR_TOO_MANY_SESS 0x00000045
#define ERROR_SHARING_PAUSED    0x00000046
#define ERROR_REQ_NOT_ACCEP 0x00000047
#define ERROR_REDIR_PAUSED  0x00000048
#define ERROR_FILE_EXISTS   0x00000050
#define ERROR_CANNOT_MAKE   0x00000052
#define ERROR_FAIL_I24  0x00000053
#define ERROR_OUT_OF_STRUCTURES 0x00000054
#define ERROR_ALREADY_ASSIGNED  0x00000055
#define ERROR_INVALID_PASSWORD  0x00000056
#define ERROR_INVALID_PARAMETER 0x00000057
#define ERROR_NET_WRITE_FAULT   0x00000058
#define ERROR_NO_PROC_SLOTS 0x00000059
#define ERROR_TOO_MANY_SEMAPHORES   0x00000064
#define ERROR_EXCL_SEM_ALREADY_OWNED    0x00000065
#define ERROR_SEM_IS_SET    0x00000066
#define ERROR_TOO_MANY_SEM_REQUESTS 0x00000067
#define ERROR_INVALID_AT_INTERRUPT_TIME 0x00000068
#define ERROR_SEM_OWNER_DIED    0x00000069
#define ERROR_SEM_USER_LIMIT    0x0000006A
#define ERROR_DISK_CHANGE   0x0000006B
#define ERROR_DRIVE_LOCKED  0x0000006C
#define ERROR_BROKEN_PIPE   0x0000006D
#define ERROR_OPEN_FAILED   0x0000006E
#define ERROR_BUFFER_OVERFLOW   0x0000006F
#define ERROR_DISK_FULL 0x00000070
#define ERROR_NO_MORE_SEARCH_HANDLES    0x00000071
#define ERROR_INVALID_TARGET_HANDLE 0x00000072
#define ERROR_INVALID_CATEGORY  0x00000075
#define ERROR_INVALID_VERIFY_SWITCH 0x00000076
#define ERROR_BAD_DRIVER_LEVEL  0x00000077
#define ERROR_CALL_NOT_IMPLEMENTED  0x00000078
#define ERROR_SEM_TIMEOUT   0x00000079
#define ERROR_INSUFFICIENT_BUFFER   0x0000007A
#define ERROR_INVALID_NAME  0x0000007B
#define ERROR_INVALID_LEVEL 0x0000007C
#define ERROR_NO_VOLUME_LABEL   0x0000007D
#define ERROR_MOD_NOT_FOUND 0x0000007E
#define ERROR_PROC_NOT_FOUND    0x0000007F
#define ERROR_WAIT_NO_CHILDREN  0x00000080
#define ERROR_CHILD_NOT_COMPLETE    0x00000081
#define ERROR_DIRECT_ACCESS_HANDLE  0x00000082
#define ERROR_NEGATIVE_SEEK 0x00000083
#define ERROR_SEEK_ON_DEVICE    0x00000084
#define ERROR_IS_JOIN_TARGET    0x00000085
#define ERROR_IS_JOINED 0x00000086
#define ERROR_IS_SUBSTED    0x00000087
#define ERROR_NOT_JOINED    0x00000088
#define ERROR_NOT_SUBSTED   0x00000089
#define ERROR_JOIN_TO_JOIN  0x0000008A
#define ERROR_SUBST_TO_SUBST    0x0000008B
#define ERROR_JOIN_TO_SUBST 0x0000008C
#define ERROR_SUBST_TO_JOIN 0x0000008D
#define ERROR_BUSY_DRIVE    0x0000008E
#define ERROR_SAME_DRIVE    0x0000008F
#define ERROR_DIR_NOT_ROOT  0x00000090
#define ERROR_DIR_NOT_EMPTY 0x00000091
#define ERROR_IS_SUBST_PATH 0x00000092
#define ERROR_IS_JOIN_PATH  0x00000093
#define ERROR_PATH_BUSY 0x00000094
#define ERROR_IS_SUBST_TARGET   0x00000095
#define ERROR_SYSTEM_TRACE  0x00000096
#define ERROR_INVALID_EVENT_COUNT   0x00000097
#define ERROR_TOO_MANY_MUXWAITERS   0x00000098
#define ERROR_INVALID_LIST_FORMAT   0x00000099
#define ERROR_LABEL_TOO_LONG    0x0000009A
#define ERROR_TOO_MANY_TCBS 0x0000009B
#define ERROR_SIGNAL_REFUSED    0x0000009C
#define ERROR_DISCARDED 0x0000009D
#define ERROR_NOT_LOCKED    0x0000009E
#define ERROR_BAD_THREADID_ADDR 0x0000009F
#define ERROR_BAD_ARGUMENTS 0x000000A0
#define ERROR_BAD_PATHNAME  0x000000A1
#define ERROR_SIGNAL_PENDING    0x000000A2
#define ERROR_MAX_THRDS_REACHED 0x000000A4
#define ERROR_LOCK_FAILED   0x000000A7
#define ERROR_BUSY  0x000000AA
#define ERROR_CANCEL_VIOLATION  0x000000AD
#define ERROR_ATOMIC_LOCKS_NOT_SUPPORTED    0x000000AE
#define ERROR_INVALID_SEGMENT_NUMBER    0x000000B4
#define ERROR_INVALID_ORDINAL   0x000000B6
#define ERROR_ALREADY_EXISTS    0x000000B7
#define ERROR_INVALID_FLAG_NUMBER   0x000000BA
#define ERROR_SEM_NOT_FOUND 0x000000BB
#define ERROR_INVALID_STARTING_CODESEG  0x000000BC
#define ERROR_INVALID_STACKSEG  0x000000BD
#define ERROR_INVALID_MODULETYPE    0x000000BE
#define ERROR_INVALID_EXE_SIGNATURE 0x000000BF
#define ERROR_EXE_MARKED_INVALID    0x000000C0
#define ERROR_BAD_EXE_FORMAT    0x000000C1
#define ERROR_ITERATED_DATA_EXCEEDS_64k 0x000000C2
#define ERROR_INVALID_MINALLOCSIZE  0x000000C3
#define ERROR_DYNLINK_FROM_INVALID_RING 0x000000C4
#define ERROR_IOPL_NOT_ENABLED  0x000000C5
#define ERROR_INVALID_SEGDPL    0x000000C6
#define ERROR_AUTODATASEG_EXCEEDS_64k   0x000000C7
#define ERROR_RING2SEG_MUST_BE_MOVABLE  0x000000C8
#define ERROR_RELOC_CHAIN_XEEDS_SEGLIM  0x000000C9
#define ERROR_INFLOOP_IN_RELOC_CHAIN    0x000000CA
#define ERROR_ENVVAR_NOT_FOUND  0x000000CB
#define ERROR_NO_SIGNAL_SENT    0x000000CD
#define ERROR_FILENAME_EXCED_RANGE  0x000000CE
#define ERROR_RING2_STACK_IN_USE    0x000000CF
#define ERROR_META_EXPANSION_TOO_LONG   0x000000D0
#define ERROR_INVALID_SIGNAL_NUMBER 0x000000D1
#define ERROR_THREAD_1_INACTIVE 0x000000D2
#define ERROR_LOCKED    0x000000D4
#define ERROR_TOO_MANY_MODULES  0x000000D6
#define ERROR_NESTING_NOT_ALLOWED   0x000000D7
#define ERROR_EXE_MACHINE_TYPE_MISMATCH 0x000000D8
#define ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY   0x000000D9
#define ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY    0x000000DA
#define ERROR_BAD_PIPE  0x000000E6
#define ERROR_PIPE_BUSY 0x000000E7
#define ERROR_NO_DATA   0x000000E8
#define ERROR_PIPE_NOT_CONNECTED    0x000000E9
#define ERROR_MORE_DATA 0x000000EA
#define ERROR_VC_DISCONNECTED   0x000000F0
#define ERROR_INVALID_EA_NAME   0x000000FE
#define ERROR_EA_LIST_INCONSISTENT  0x000000FF
#define WAIT_TIMEOUT    0x00000102
#define ERROR_NO_MORE_ITEMS 0x00000103
#define ERROR_CANNOT_COPY   0x0000010A
#define ERROR_DIRECTORY 0x0000010B
#define ERROR_EAS_DIDNT_FIT 0x00000113
#define ERROR_EA_FILE_CORRUPT   0x00000114
#define ERROR_EA_TABLE_FULL 0x00000115
#define ERROR_INVALID_EA_HANDLE 0x00000116
#define ERROR_EAS_NOT_SUPPORTED 0x0000011A
#define ERROR_NOT_OWNER 0x00000120
#define ERROR_TOO_MANY_POSTS    0x0000012A
#define ERROR_PARTIAL_COPY  0x0000012B
#define ERROR_OPLOCK_NOT_GRANTED    0x0000012C
#define ERROR_INVALID_OPLOCK_PROTOCOL   0x0000012D
#define ERROR_DISK_TOO_FRAGMENTED   0x0000012E
#define ERROR_DELETE_PENDING    0x0000012F
#define ERROR_MR_MID_NOT_FOUND  0x0000013D
#define ERROR_SCOPE_NOT_FOUND   0x0000013E
#define ERROR_INVALID_ADDRESS   0x000001E7
#define ERROR_ARITHMETIC_OVERFLOW   0x00000216
#define ERROR_PIPE_CONNECTED    0x00000217
#define ERROR_PIPE_LISTENING    0x00000218
#define ERROR_EA_ACCESS_DENIED  0x000003E2
#define ERROR_OPERATION_ABORTED 0x000003E3
#define ERROR_IO_INCOMPLETE 0x000003E4
#define ERROR_IO_PENDING    0x000003E5
#define ERROR_NOACCESS  0x000003E6
#define ERROR_SWAPERROR 0x000003E7
#define ERROR_STACK_OVERFLOW    0x000003E9
#define ERROR_INVALID_MESSAGE   0x000003EA
#define ERROR_CAN_NOT_COMPLETE  0x000003EB
#define ERROR_INVALID_FLAGS 0x000003EC
#define ERROR_UNRECOGNIZED_VOLUME   0x000003ED
#define ERROR_FILE_INVALID  0x000003EE
#define ERROR_FULLSCREEN_MODE   0x000003EF
#define ERROR_NO_TOKEN  0x000003F0
#define ERROR_BADDB 0x000003F1
#define ERROR_BADKEY    0x000003F2
#define ERROR_CANTOPEN  0x000003F3
#define ERROR_CANTREAD  0x000003F4
#define ERROR_CANTWRITE 0x000003F5
#define ERROR_REGISTRY_RECOVERED    0x000003F6
#define ERROR_REGISTRY_CORRUPT  0x000003F7
#define ERROR_REGISTRY_IO_FAILED    0x000003F8
#define ERROR_NOT_REGISTRY_FILE 0x000003F9
#define ERROR_KEY_DELETED   0x000003FA
#define ERROR_NO_LOG_SPACE  0x000003FB
#define ERROR_KEY_HAS_CHILDREN  0x000003FC
#define ERROR_CHILD_MUST_BE_VOLATILE    0x000003FD
#define ERROR_NOTIFY_ENUM_DIR   0x000003FE
#define ERROR_DEPENDENT_SERVICES_RUNNING    0x0000041B
#define ERROR_INVALID_SERVICE_CONTROL   0x0000041C
#define ERROR_SERVICE_REQUEST_TIMEOUT   0x0000041D
#define ERROR_SERVICE_NO_THREAD 0x0000041E
#define ERROR_SERVICE_DATABASE_LOCKED   0x0000041F
#define ERROR_SERVICE_ALREADY_RUNNING   0x00000420
#define ERROR_INVALID_SERVICE_ACCOUNT   0x00000421
#define ERROR_SERVICE_DISABLED  0x00000422
#define ERROR_CIRCULAR_DEPENDENCY   0x00000423
#define ERROR_SERVICE_DOES_NOT_EXIST    0x00000424
#define ERROR_SERVICE_CANNOT_ACCEPT_CTRL    0x00000425
#define ERROR_SERVICE_NOT_ACTIVE    0x00000426
#define ERROR_FAILED_SERVICE_CONTROLLER_CONNECT 0x00000427
#define ERROR_EXCEPTION_IN_SERVICE  0x00000428
#define ERROR_DATABASE_DOES_NOT_EXIST   0x00000429
#define ERROR_SERVICE_SPECIFIC_ERROR    0x0000042A
#define ERROR_PROCESS_ABORTED   0x0000042B
#define ERROR_SERVICE_DEPENDENCY_FAIL   0x0000042C
#define ERROR_SERVICE_LOGON_FAILED  0x0000042D
#define ERROR_SERVICE_START_HANG    0x0000042E
#define ERROR_INVALID_SERVICE_LOCK  0x0000042F
#define ERROR_SERVICE_MARKED_FOR_DELETE 0x00000430
#define ERROR_SERVICE_EXISTS    0x00000431
#define ERROR_ALREADY_RUNNING_LKG   0x00000432
#define ERROR_SERVICE_DEPENDENCY_DELETED    0x00000433
#define ERROR_BOOT_ALREADY_ACCEPTED 0x00000434
#define ERROR_SERVICE_NEVER_STARTED 0x00000435
#define ERROR_DUPLICATE_SERVICE_NAME    0x00000436
#define ERROR_DIFFERENT_SERVICE_ACCOUNT 0x00000437
#define ERROR_CANNOT_DETECT_DRIVER_FAILURE  0x00000438
#define ERROR_CANNOT_DETECT_PROCESS_ABORT   0x00000439
#define ERROR_NO_RECOVERY_PROGRAM   0x0000043A
#define ERROR_SERVICE_NOT_IN_EXE    0x0000043B
#define ERROR_NOT_SAFEBOOT_SERVICE  0x0000043C
#define ERROR_END_OF_MEDIA  0x0000044C
#define ERROR_FILEMARK_DETECTED 0x0000044D
#define ERROR_BEGINNING_OF_MEDIA    0x0000044E
#define ERROR_SETMARK_DETECTED  0x0000044F
#define ERROR_NO_DATA_DETECTED  0x00000450
#define ERROR_PARTITION_FAILURE 0x00000451
#define ERROR_INVALID_BLOCK_LENGTH  0x00000452
#define ERROR_DEVICE_NOT_PARTITIONED    0x00000453
#define ERROR_UNABLE_TO_LOCK_MEDIA  0x00000454
#define ERROR_UNABLE_TO_UNLOAD_MEDIA    0x00000455
#define ERROR_MEDIA_CHANGED 0x00000456
#define ERROR_BUS_RESET 0x00000457
#define ERROR_NO_MEDIA_IN_DRIVE 0x00000458
#define ERROR_NO_UNICODE_TRANSLATION    0x00000459
#define ERROR_DLL_INIT_FAILED   0x0000045A
#define ERROR_SHUTDOWN_IN_PROGRESS  0x0000045B
#define ERROR_NO_SHUTDOWN_IN_PROGRESS   0x0000045C
#define ERROR_IO_DEVICE 0x0000045D
#define ERROR_SERIAL_NO_DEVICE  0x0000045E
#define ERROR_IRQ_BUSY  0x0000045F
#define ERROR_MORE_WRITES   0x00000460
#define ERROR_COUNTER_TIMEOUT   0x00000461
#define ERROR_FLOPPY_ID_MARK_NOT_FOUND  0x00000462
#define ERROR_FLOPPY_WRONG_CYLINDER 0x00000463
#define ERROR_FLOPPY_UNKNOWN_ERROR  0x00000464
#define ERROR_FLOPPY_BAD_REGISTERS  0x00000465
#define ERROR_DISK_RECALIBRATE_FAILED   0x00000466
#define ERROR_DISK_OPERATION_FAILED 0x00000467
#define ERROR_DISK_RESET_FAILED 0x00000468
#define ERROR_EOM_OVERFLOW  0x00000469
#define ERROR_NOT_ENOUGH_SERVER_MEMORY  0x0000046A
#define ERROR_POSSIBLE_DEADLOCK 0x0000046B
#define ERROR_MAPPED_ALIGNMENT  0x0000046C
#define ERROR_SET_POWER_STATE_VETOED    0x00000474
#define ERROR_SET_POWER_STATE_FAILED    0x00000475
#define ERROR_TOO_MANY_LINKS    0x00000476
#define ERROR_OLD_WIN_VERSION   0x0000047E
#define ERROR_APP_WRONG_OS  0x0000047F
#define ERROR_SINGLE_INSTANCE_APP   0x00000480
#define ERROR_RMODE_APP 0x00000481
#define ERROR_INVALID_DLL   0x00000482
#define ERROR_NO_ASSOCIATION    0x00000483
#define ERROR_DDE_FAIL  0x00000484
#define ERROR_DLL_NOT_FOUND 0x00000485
#define ERROR_NO_MORE_USER_HANDLES  0x00000486
#define ERROR_MESSAGE_SYNC_ONLY 0x00000487
#define ERROR_SOURCE_ELEMENT_EMPTY  0x00000488
#define ERROR_DESTINATION_ELEMENT_FULL  0x00000489
#define ERROR_ILLEGAL_ELEMENT_ADDRESS   0x0000048A
#define ERROR_MAGAZINE_NOT_PRESENT  0x0000048B
#define ERROR_DEVICE_REINITIALIZATION_NEEDED    0x0000048C
#define ERROR_DEVICE_REQUIRES_CLEANING  0x0000048D
#define ERROR_DEVICE_DOOR_OPEN  0x0000048E
#define ERROR_DEVICE_NOT_CONNECTED  0x0000048F
#define ERROR_NOT_FOUND 0x00000490
#define ERROR_NO_MATCH  0x00000491
#define ERROR_SET_NOT_FOUND 0x00000492
#define ERROR_POINT_NOT_FOUND   0x00000493
#define ERROR_NO_TRACKING_SERVICE   0x00000494
#define ERROR_NO_VOLUME_ID  0x00000495
#define ERROR_UNABLE_TO_REMOVE_REPLACED 0x00000497
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT    0x00000498
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT_2  0x00000499
#define ERROR_JOURNAL_DELETE_IN_PROGRESS    0x0000049A
#define ERROR_JOURNAL_NOT_ACTIVE    0x0000049B
#define ERROR_POTENTIAL_FILE_FOUND  0x0000049C
#define ERROR_JOURNAL_ENTRY_DELETED 0x0000049D
#define ERROR_BAD_DEVICE    0x000004B0
#define ERROR_CONNECTION_UNAVAIL    0x000004B1
#define ERROR_DEVICE_ALREADY_REMEMBERED 0x000004B2
#define ERROR_NO_NET_OR_BAD_PATH    0x000004B3
#define ERROR_BAD_PROVIDER  0x000004B4
#define ERROR_CANNOT_OPEN_PROFILE   0x000004B5
#define ERROR_BAD_PROFILE   0x000004B6
#define ERROR_NOT_CONTAINER 0x000004B7
#define ERROR_EXTENDED_ERROR    0x000004B8
#define ERROR_INVALID_GROUPNAME 0x000004B9
#define ERROR_INVALID_COMPUTERNAME  0x000004BA
#define ERROR_INVALID_EVENTNAME 0x000004BB
#define ERROR_INVALID_DOMAINNAME    0x000004BC
#define ERROR_INVALID_SERVICENAME   0x000004BD
#define ERROR_INVALID_NETNAME   0x000004BE
#define ERROR_INVALID_SHARENAME 0x000004BF
#define ERROR_INVALID_PASSWORDNAME  0x000004C0
#define ERROR_INVALID_MESSAGENAME   0x000004C1
#define ERROR_INVALID_MESSAGEDEST   0x000004C2
#define ERROR_SESSION_CREDENTIAL_CONFLICT   0x000004C3
#define ERROR_REMOTE_SESSION_LIMIT_EXCEEDED 0x000004C4
#define ERROR_DUP_DOMAINNAME    0x000004C5
#define ERROR_NO_NETWORK    0x000004C6
#define ERROR_CANCELLED 0x000004C7
#define ERROR_USER_MAPPED_FILE  0x000004C8
#define ERROR_CONNECTION_REFUSED    0x000004C9
#define ERROR_GRACEFUL_DISCONNECT   0x000004CA
#define ERROR_ADDRESS_ALREADY_ASSOCIATED    0x000004CB
#define ERROR_ADDRESS_NOT_ASSOCIATED    0x000004CC
#define ERROR_CONNECTION_INVALID    0x000004CD
#define ERROR_CONNECTION_ACTIVE 0x000004CE
#define ERROR_NETWORK_UNREACHABLE   0x000004CF
#define ERROR_HOST_UNREACHABLE  0x000004D0
#define ERROR_PROTOCOL_UNREACHABLE  0x000004D1
#define ERROR_PORT_UNREACHABLE  0x000004D2
#define ERROR_REQUEST_ABORTED   0x000004D3
#define ERROR_CONNECTION_ABORTED    0x000004D4
#define ERROR_RETRY 0x000004D5
#define ERROR_CONNECTION_COUNT_LIMIT    0x000004D6
#define ERROR_LOGIN_TIME_RESTRICTION    0x000004D7
#define ERROR_LOGIN_WKSTA_RESTRICTION   0x000004D8
#define ERROR_INCORRECT_ADDRESS 0x000004D9
#define ERROR_ALREADY_REGISTERED    0x000004DA
#define ERROR_SERVICE_NOT_FOUND 0x000004DB
#define ERROR_NOT_AUTHENTICATED 0x000004DC
#define ERROR_NOT_LOGGED_ON 0x000004DD
#define ERROR_CONTINUE  0x000004DE
#define ERROR_ALREADY_INITIALIZED   0x000004DF
#define ERROR_NO_MORE_DEVICES   0x000004E0
#define ERROR_NO_SUCH_SITE  0x000004E1
#define ERROR_DOMAIN_CONTROLLER_EXISTS  0x000004E2
#define ERROR_ONLY_IF_CONNECTED 0x000004E3
#define ERROR_OVERRIDE_NOCHANGES    0x000004E4
#define ERROR_BAD_USER_PROFILE  0x000004E5
#define ERROR_NOT_SUPPORTED_ON_SBS  0x000004E6
#define ERROR_SERVER_SHUTDOWN_IN_PROGRESS   0x000004E7
#define ERROR_HOST_DOWN 0x000004E8
#define ERROR_NON_ACCOUNT_SID   0x000004E9
#define ERROR_NON_DOMAIN_SID    0x000004EA
#define ERROR_APPHELP_BLOCK 0x000004EB
#define ERROR_ACCESS_DISABLED_BY_POLICY 0x000004EC
#define ERROR_REG_NAT_CONSUMPTION   0x000004ED
#define ERROR_CSCSHARE_OFFLINE  0x000004EE
#define ERROR_PKINIT_FAILURE    0x000004EF
#define ERROR_SMARTCARD_SUBSYSTEM_FAILURE   0x000004F0
#define ERROR_DOWNGRADE_DETECTED    0x000004F1
#define ERROR_MACHINE_LOCKED    0x000004F7
#define ERROR_CALLBACK_SUPPLIED_INVALID_DATA    0x000004F9
#define ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED  0x000004FA
#define ERROR_DRIVER_BLOCKED    0x000004FB
#define ERROR_INVALID_IMPORT_OF_NON_DLL 0x000004FC
#define ERROR_ACCESS_DISABLED_WEBBLADE  0x000004FD
#define ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER   0x000004FE
#define ERROR_RECOVERY_FAILURE  0x000004FF
#define ERROR_ALREADY_FIBER 0x00000500
#define ERROR_ALREADY_THREAD    0x00000501
#define ERROR_STACK_BUFFER_OVERRUN  0x00000502
#define ERROR_PARAMETER_QUOTA_EXCEEDED  0x00000503
#define ERROR_DEBUGGER_INACTIVE 0x00000504
#define ERROR_DELAY_LOAD_FAILED 0x00000505
#define ERROR_VDM_DISALLOWED    0x00000506
#define ERROR_NOT_ALL_ASSIGNED  0x00000514
#define ERROR_SOME_NOT_MAPPED   0x00000515
#define ERROR_NO_QUOTAS_FOR_ACCOUNT 0x00000516
#define ERROR_LOCAL_USER_SESSION_KEY    0x00000517
#define ERROR_NULL_LM_PASSWORD  0x00000518
#define ERROR_UNKNOWN_REVISION  0x00000519
#define ERROR_REVISION_MISMATCH 0x0000051A
#define ERROR_INVALID_OWNER 0x0000051B
#define ERROR_INVALID_PRIMARY_GROUP 0x0000051C
#define ERROR_NO_IMPERSONATION_TOKEN    0x0000051D
#define ERROR_CANT_DISABLE_MANDATORY    0x0000051E
#define ERROR_NO_LOGON_SERVERS  0x0000051F
#define ERROR_NO_SUCH_LOGON_SESSION 0x00000520
#define ERROR_NO_SUCH_PRIVILEGE 0x00000521
#define ERROR_PRIVILEGE_NOT_HELD    0x00000522
#define ERROR_INVALID_ACCOUNT_NAME  0x00000523
#define ERROR_USER_EXISTS   0x00000524
#define ERROR_NO_SUCH_USER  0x00000525
#define ERROR_GROUP_EXISTS  0x00000526
#define ERROR_NO_SUCH_GROUP 0x00000527
#define ERROR_MEMBER_IN_GROUP   0x00000528
#define ERROR_MEMBER_NOT_IN_GROUP   0x00000529
#define ERROR_LAST_ADMIN    0x0000052A
#define ERROR_WRONG_PASSWORD    0x0000052B
#define ERROR_ILL_FORMED_PASSWORD   0x0000052C
#define ERROR_PASSWORD_RESTRICTION  0x0000052D
#define ERROR_LOGON_FAILURE 0x0000052E
#define ERROR_ACCOUNT_RESTRICTION   0x0000052F
#define ERROR_INVALID_LOGON_HOURS   0x00000530
#define ERROR_INVALID_WORKSTATION   0x00000531
#define ERROR_PASSWORD_EXPIRED  0x00000532
#define ERROR_ACCOUNT_DISABLED  0x00000533
#define ERROR_NONE_MAPPED   0x00000534
#define ERROR_TOO_MANY_LUIDS_REQUESTED  0x00000535
#define ERROR_LUIDS_EXHAUSTED   0x00000536
#define ERROR_INVALID_SUB_AUTHORITY 0x00000537
#define ERROR_INVALID_ACL   0x00000538
#define ERROR_INVALID_SID   0x00000539
#define ERROR_INVALID_SECURITY_DESCR    0x0000053A
#define ERROR_BAD_INHERITANCE_ACL   0x0000053C
#define ERROR_SERVER_DISABLED   0x0000053D
#define ERROR_SERVER_NOT_DISABLED   0x0000053E
#define ERROR_INVALID_ID_AUTHORITY  0x0000053F
#define ERROR_ALLOTTED_SPACE_EXCEEDED   0x00000540
#define ERROR_INVALID_GROUP_ATTRIBUTES  0x00000541
#define ERROR_BAD_IMPERSONATION_LEVEL   0x00000542
#define ERROR_CANT_OPEN_ANONYMOUS   0x00000543
#define ERROR_BAD_VALIDATION_CLASS  0x00000544
#define ERROR_BAD_TOKEN_TYPE    0x00000545
#define ERROR_NO_SECURITY_ON_OBJECT 0x00000546
#define ERROR_CANT_ACCESS_DOMAIN_INFO   0x00000547
#define ERROR_INVALID_SERVER_STATE  0x00000548
#define ERROR_INVALID_DOMAIN_STATE  0x00000549
#define ERROR_INVALID_DOMAIN_ROLE   0x0000054A
#define ERROR_NO_SUCH_DOMAIN    0x0000054B
#define ERROR_DOMAIN_EXISTS 0x0000054C
#define ERROR_DOMAIN_LIMIT_EXCEEDED 0x0000054D
#define ERROR_INTERNAL_DB_CORRUPTION    0x0000054E
#define ERROR_INTERNAL_ERROR    0x0000054F
#define ERROR_GENERIC_NOT_MAPPED    0x00000550
#define ERROR_BAD_DESCRIPTOR_FORMAT 0x00000551
#define ERROR_NOT_LOGON_PROCESS 0x00000552
#define ERROR_LOGON_SESSION_EXISTS  0x00000553
#define ERROR_NO_SUCH_PACKAGE   0x00000554
#define ERROR_BAD_LOGON_SESSION_STATE   0x00000555
#define ERROR_LOGON_SESSION_COLLISION   0x00000556
#define ERROR_INVALID_LOGON_TYPE    0x00000557
#define ERROR_CANNOT_IMPERSONATE    0x00000558
#define ERROR_RXACT_INVALID_STATE   0x00000559
#define ERROR_RXACT_COMMIT_FAILURE  0x0000055A
#define ERROR_SPECIAL_ACCOUNT   0x0000055B
#define ERROR_SPECIAL_GROUP 0x0000055C
#define ERROR_SPECIAL_USER  0x0000055D
#define ERROR_MEMBERS_PRIMARY_GROUP 0x0000055E
#define ERROR_TOKEN_ALREADY_IN_USE  0x0000055F
#define ERROR_NO_SUCH_ALIAS 0x00000560
#define ERROR_MEMBER_NOT_IN_ALIAS   0x00000561
#define ERROR_MEMBER_IN_ALIAS   0x00000562
#define ERROR_ALIAS_EXISTS  0x00000563
#define ERROR_LOGON_NOT_GRANTED 0x00000564
#define ERROR_TOO_MANY_SECRETS  0x00000565
#define ERROR_SECRET_TOO_LONG   0x00000566
#define ERROR_INTERNAL_DB_ERROR 0x00000567
#define ERROR_TOO_MANY_CONTEXT_IDS  0x00000568
#define ERROR_LOGON_TYPE_NOT_GRANTED    0x00000569
#define ERROR_NT_CROSS_ENCRYPTION_REQUIRED  0x0000056A
#define ERROR_NO_SUCH_MEMBER    0x0000056B
#define ERROR_INVALID_MEMBER    0x0000056C
#define ERROR_TOO_MANY_SIDS 0x0000056D
#define ERROR_LM_CROSS_ENCRYPTION_REQUIRED  0x0000056E
#define ERROR_NO_INHERITANCE    0x0000056F
#define ERROR_FILE_CORRUPT  0x00000570
#define ERROR_DISK_CORRUPT  0x00000571
#define ERROR_NO_USER_SESSION_KEY   0x00000572
#define ERROR_LICENSE_QUOTA_EXCEEDED    0x00000573
#define ERROR_WRONG_TARGET_NAME 0x00000574
#define ERROR_MUTUAL_AUTH_FAILED    0x00000575
#define ERROR_TIME_SKEW 0x00000576
#define ERROR_CURRENT_DOMAIN_NOT_ALLOWED    0x00000577
#define ERROR_INVALID_WINDOW_HANDLE 0x00000578
#define ERROR_INVALID_MENU_HANDLE   0x00000579
#define ERROR_INVALID_CURSOR_HANDLE 0x0000057A
#define ERROR_INVALID_ACCEL_HANDLE  0x0000057B
#define ERROR_INVALID_HOOK_HANDLE   0x0000057C
#define ERROR_INVALID_DWP_HANDLE    0x0000057D
#define ERROR_TLW_WITH_WSCHILD  0x0000057E
#define ERROR_CANNOT_FIND_WND_CLASS 0x0000057F
#define ERROR_WINDOW_OF_OTHER_THREAD    0x00000580
#define ERROR_HOTKEY_ALREADY_REGISTERED 0x00000581
#define ERROR_CLASS_ALREADY_EXISTS  0x00000582
#define ERROR_CLASS_DOES_NOT_EXIST  0x00000583
#define ERROR_CLASS_HAS_WINDOWS 0x00000584
#define ERROR_INVALID_INDEX 0x00000585
#define ERROR_INVALID_ICON_HANDLE   0x00000586
#define ERROR_PRIVATE_DIALOG_INDEX  0x00000587
#define ERROR_LISTBOX_ID_NOT_FOUND  0x00000588
#define ERROR_NO_WILDCARD_CHARACTERS    0x00000589
#define ERROR_CLIPBOARD_NOT_OPEN    0x0000058A
#define ERROR_HOTKEY_NOT_REGISTERED 0x0000058B
#define ERROR_WINDOW_NOT_DIALOG 0x0000058C
#define ERROR_CONTROL_ID_NOT_FOUND  0x0000058D
#define ERROR_INVALID_COMBOBOX_MESSAGE  0x0000058E
#define ERROR_WINDOW_NOT_COMBOBOX   0x0000058F
#define ERROR_INVALID_EDIT_HEIGHT   0x00000590
#define ERROR_DC_NOT_FOUND  0x00000591
#define ERROR_INVALID_HOOK_FILTER   0x00000592
#define ERROR_INVALID_FILTER_PROC   0x00000593
#define ERROR_HOOK_NEEDS_HMOD   0x00000594
#define ERROR_GLOBAL_ONLY_HOOK  0x00000595
#define ERROR_JOURNAL_HOOK_SET  0x00000596
#define ERROR_HOOK_NOT_INSTALLED    0x00000597
#define ERROR_INVALID_LB_MESSAGE    0x00000598
#define ERROR_SETCOUNT_ON_BAD_LB    0x00000599
#define ERROR_LB_WITHOUT_TABSTOPS   0x0000059A
#define ERROR_DESTROY_OBJECT_OF_OTHER_THREAD    0x0000059B
#define ERROR_CHILD_WINDOW_MENU 0x0000059C
#define ERROR_NO_SYSTEM_MENU    0x0000059D
#define ERROR_INVALID_MSGBOX_STYLE  0x0000059E
#define ERROR_INVALID_SPI_VALUE 0x0000059F
#define ERROR_SCREEN_ALREADY_LOCKED 0x000005A0
#define ERROR_HWNDS_HAVE_DIFF_PARENT    0x000005A1
#define ERROR_NOT_CHILD_WINDOW  0x000005A2
#define ERROR_INVALID_GW_COMMAND    0x000005A3
#define ERROR_INVALID_THREAD_ID 0x000005A4
#define ERROR_NON_MDICHILD_WINDOW   0x000005A5
#define ERROR_POPUP_ALREADY_ACTIVE  0x000005A6
#define ERROR_NO_SCROLLBARS 0x000005A7
#define ERROR_INVALID_SCROLLBAR_RANGE   0x000005A8
#define ERROR_INVALID_SHOWWIN_COMMAND   0x000005A9
#define ERROR_NO_SYSTEM_RESOURCES   0x000005AA
#define ERROR_NONPAGED_SYSTEM_RESOURCES 0x000005AB
#define ERROR_PAGED_SYSTEM_RESOURCES    0x000005AC
#define ERROR_WORKING_SET_QUOTA 0x000005AD
#define ERROR_PAGEFILE_QUOTA    0x000005AE
#define ERROR_COMMITMENT_LIMIT  0x000005AF
#define ERROR_MENU_ITEM_NOT_FOUND   0x000005B0
#define ERROR_INVALID_KEYBOARD_HANDLE   0x000005B1
#define ERROR_HOOK_TYPE_NOT_ALLOWED 0x000005B2
#define ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION    0x000005B3
#define ERROR_TIMEOUT   0x000005B4
#define ERROR_INVALID_MONITOR_HANDLE    0x000005B5
#define ERROR_EVENTLOG_FILE_CORRUPT 0x000005DC
#define ERROR_EVENTLOG_CANT_START   0x000005DD
#define ERROR_LOG_FILE_FULL 0x000005DE
#define ERROR_EVENTLOG_FILE_CHANGED 0x000005DF
#define ERROR_INSTALL_SERVICE_FAILURE   0x00000641
#define ERROR_INSTALL_USEREXIT  0x00000642
#define ERROR_INSTALL_FAILURE   0x00000643
#define ERROR_INSTALL_SUSPEND   0x00000644
#define ERROR_UNKNOWN_PRODUCT   0x00000645
#define ERROR_UNKNOWN_FEATURE   0x00000646
#define ERROR_UNKNOWN_COMPONENT 0x00000647
#define ERROR_UNKNOWN_PROPERTY  0x00000648
#define ERROR_INVALID_HANDLE_STATE  0x00000649
#define ERROR_BAD_CONFIGURATION 0x0000064A
#define ERROR_INDEX_ABSENT  0x0000064B
#define ERROR_INSTALL_SOURCE_ABSENT 0x0000064C
#define ERROR_INSTALL_PACKAGE_VERSION   0x0000064D
#define ERROR_PRODUCT_UNINSTALLED   0x0000064E
#define ERROR_BAD_QUERY_SYNTAX  0x0000064F
#define ERROR_INVALID_FIELD 0x00000650
#define ERROR_DEVICE_REMOVED    0x00000651
#define ERROR_INSTALL_ALREADY_RUNNING   0x00000652
#define ERROR_INSTALL_PACKAGE_OPEN_FAILED   0x00000653
#define ERROR_INSTALL_PACKAGE_INVALID   0x00000654
#define ERROR_INSTALL_UI_FAILURE    0x00000655
#define ERROR_INSTALL_LOG_FAILURE   0x00000656
#define ERROR_INSTALL_LANGUAGE_UNSUPPORTED  0x00000657
#define ERROR_INSTALL_TRANSFORM_FAILURE 0x00000658
#define ERROR_INSTALL_PACKAGE_REJECTED  0x00000659
#define ERROR_FUNCTION_NOT_CALLED   0x0000065A
#define ERROR_FUNCTION_FAILED   0x0000065B
#define ERROR_INVALID_TABLE 0x0000065C
#define ERROR_DATATYPE_MISMATCH 0x0000065D
#define ERROR_UNSUPPORTED_TYPE  0x0000065E
#define ERROR_CREATE_FAILED 0x0000065F
#define ERROR_INSTALL_TEMP_UNWRITABLE   0x00000660
#define ERROR_INSTALL_PLATFORM_UNSUPPORTED  0x00000661
#define ERROR_INSTALL_NOTUSED   0x00000662
#define ERROR_PATCH_PACKAGE_OPEN_FAILED 0x00000663
#define ERROR_PATCH_PACKAGE_INVALID 0x00000664
#define ERROR_PATCH_PACKAGE_UNSUPPORTED 0x00000665
#define ERROR_PRODUCT_VERSION   0x00000666
#define ERROR_INVALID_COMMAND_LINE  0x00000667
#define ERROR_INSTALL_REMOTE_DISALLOWED 0x00000668
#define ERROR_SUCCESS_REBOOT_INITIATED  0x00000669
#define ERROR_PATCH_TARGET_NOT_FOUND    0x0000066A
#define ERROR_PATCH_PACKAGE_REJECTED    0x0000066B
#define ERROR_INSTALL_TRANSFORM_REJECTED    0x0000066C
#define ERROR_INSTALL_REMOTE_PROHIBITED 0x0000066D
#define RPC_S_INVALID_STRING_BINDING    0x000006A4
#define RPC_S_WRONG_KIND_OF_BINDING 0x000006A5
#define RPC_S_INVALID_BINDING   0x000006A6
#define RPC_S_PROTSEQ_NOT_SUPPORTED 0x000006A7
#define RPC_S_INVALID_RPC_PROTSEQ   0x000006A8
#define RPC_S_INVALID_STRING_UUID   0x000006A9
#define RPC_S_INVALID_ENDPOINT_FORMAT   0x000006AA
#define RPC_S_INVALID_NET_ADDR  0x000006AB
#define RPC_S_NO_ENDPOINT_FOUND 0x000006AC
#define RPC_S_INVALID_TIMEOUT   0x000006AD
#define RPC_S_OBJECT_NOT_FOUND  0x000006AE
#define RPC_S_ALREADY_REGISTERED    0x000006AF
#define RPC_S_TYPE_ALREADY_REGISTERED   0x000006B0
#define RPC_S_ALREADY_LISTENING 0x000006B1
#define RPC_S_NO_PROTSEQS_REGISTERED    0x000006B2
#define RPC_S_NOT_LISTENING 0x000006B3
#define RPC_S_UNKNOWN_MGR_TYPE  0x000006B4
#define RPC_S_UNKNOWN_IF    0x000006B5
#define RPC_S_NO_BINDINGS   0x000006B6
#define RPC_S_NO_PROTSEQS   0x000006B7
#define RPC_S_CANT_CREATE_ENDPOINT  0x000006B8
#define RPC_S_OUT_OF_RESOURCES  0x000006B9
#define RPC_S_SERVER_UNAVAILABLE    0x000006BA
#define RPC_S_SERVER_TOO_BUSY   0x000006BB
#define RPC_S_INVALID_NETWORK_OPTIONS   0x000006BC
#define RPC_S_NO_CALL_ACTIVE    0x000006BD
#define RPC_S_CALL_FAILED   0x000006BE
#define RPC_S_CALL_FAILED_DNE   0x000006BF
#define RPC_S_PROTOCOL_ERROR    0x000006C0
#define RPC_S_UNSUPPORTED_TRANS_SYN 0x000006C2
#define RPC_S_UNSUPPORTED_TYPE  0x000006C4
#define RPC_S_INVALID_TAG   0x000006C5
#define RPC_S_INVALID_BOUND 0x000006C6
#define RPC_S_NO_ENTRY_NAME 0x000006C7
#define RPC_S_INVALID_NAME_SYNTAX   0x000006C8
#define RPC_S_UNSUPPORTED_NAME_SYNTAX   0x000006C9
#define RPC_S_UUID_NO_ADDRESS   0x000006CB
#define RPC_S_DUPLICATE_ENDPOINT    0x000006CC
#define RPC_S_UNKNOWN_AUTHN_TYPE    0x000006CD
#define RPC_S_MAX_CALLS_TOO_SMALL   0x000006CE
#define RPC_S_STRING_TOO_LONG   0x000006CF
#define RPC_S_PROTSEQ_NOT_FOUND 0x000006D0
#define RPC_S_PROCNUM_OUT_OF_RANGE  0x000006D1
#define RPC_S_BINDING_HAS_NO_AUTH   0x000006D2
#define RPC_S_UNKNOWN_AUTHN_SERVICE 0x000006D3
#define RPC_S_UNKNOWN_AUTHN_LEVEL   0x000006D4
#define RPC_S_INVALID_AUTH_IDENTITY 0x000006D5
#define RPC_S_UNKNOWN_AUTHZ_SERVICE 0x000006D6
#define EPT_S_INVALID_ENTRY 0x000006D7
#define EPT_S_CANT_PERFORM_OP   0x000006D8
#define EPT_S_NOT_REGISTERED    0x000006D9
#define RPC_S_NOTHING_TO_EXPORT 0x000006DA
#define RPC_S_INCOMPLETE_NAME   0x000006DB
#define RPC_S_INVALID_VERS_OPTION   0x000006DC
#define RPC_S_NO_MORE_MEMBERS   0x000006DD
#define RPC_S_NOT_ALL_OBJS_UNEXPORTED   0x000006DE
#define RPC_S_INTERFACE_NOT_FOUND   0x000006DF
#define RPC_S_ENTRY_ALREADY_EXISTS  0x000006E0
#define RPC_S_ENTRY_NOT_FOUND   0x000006E1
#define RPC_S_NAME_SERVICE_UNAVAILABLE  0x000006E2
#define RPC_S_INVALID_NAF_ID    0x000006E3
#define RPC_S_CANNOT_SUPPORT    0x000006E4
#define RPC_S_NO_CONTEXT_AVAILABLE  0x000006E5
#define RPC_S_INTERNAL_ERROR    0x000006E6
#define RPC_S_ZERO_DIVIDE   0x000006E7
#define RPC_S_ADDRESS_ERROR 0x000006E8
#define RPC_S_FP_DIV_ZERO   0x000006E9
#define RPC_S_FP_UNDERFLOW  0x000006EA
#define RPC_S_FP_OVERFLOW   0x000006EB
#define RPC_X_NO_MORE_ENTRIES   0x000006EC
#define RPC_X_SS_CHAR_TRANS_OPEN_FAIL   0x000006ED
#define RPC_X_SS_CHAR_TRANS_SHORT_FILE  0x000006EE
#define RPC_X_SS_IN_NULL_CONTEXT    0x000006EF
#define RPC_X_SS_CONTEXT_DAMAGED    0x000006F1
#define RPC_X_SS_HANDLES_MISMATCH   0x000006F2
#define RPC_X_SS_CANNOT_GET_CALL_HANDLE 0x000006F3
#define RPC_X_NULL_REF_POINTER  0x000006F4
#define RPC_X_ENUM_VALUE_OUT_OF_RANGE   0x000006F5
#define RPC_X_BYTE_COUNT_TOO_SMALL  0x000006F6
#define RPC_X_BAD_STUB_DATA 0x000006F7
#define ERROR_INVALID_USER_BUFFER   0x000006F8
#define ERROR_UNRECOGNIZED_MEDIA    0x000006F9
#define ERROR_NO_TRUST_LSA_SECRET   0x000006FA
#define ERROR_NO_TRUST_SAM_ACCOUNT  0x000006FB
#define ERROR_TRUSTED_DOMAIN_FAILURE    0x000006FC
#define ERROR_TRUSTED_RELATIONSHIP_FAILURE  0x000006FD
#define ERROR_TRUST_FAILURE 0x000006FE
#define RPC_S_CALL_IN_PROGRESS  0x000006FF
#define ERROR_NETLOGON_NOT_STARTED  0x00000700
#define ERROR_ACCOUNT_EXPIRED   0x00000701
#define ERROR_REDIRECTOR_HAS_OPEN_HANDLES   0x00000702
#define ERROR_PRINTER_DRIVER_ALREADY_INSTALLED  0x00000703
#define ERROR_UNKNOWN_PORT  0x00000704
#define ERROR_UNKNOWN_PRINTER_DRIVER    0x00000705
#define ERROR_UNKNOWN_PRINTPROCESSOR    0x00000706
#define ERROR_INVALID_SEPARATOR_FILE    0x00000707
#define ERROR_INVALID_PRIORITY  0x00000708
#define ERROR_INVALID_PRINTER_NAME  0x00000709
#define ERROR_PRINTER_ALREADY_EXISTS    0x0000070A
#define ERROR_INVALID_PRINTER_COMMAND   0x0000070B
#define ERROR_INVALID_DATATYPE  0x0000070C
#define ERROR_INVALID_ENVIRONMENT   0x0000070D
#define RPC_S_NO_MORE_BINDINGS  0x0000070E
#define ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT 0x0000070F
#define ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT 0x00000710
#define ERROR_NOLOGON_SERVER_TRUST_ACCOUNT  0x00000711
#define ERROR_DOMAIN_TRUST_INCONSISTENT 0x00000712
#define ERROR_SERVER_HAS_OPEN_HANDLES   0x00000713
#define ERROR_RESOURCE_DATA_NOT_FOUND   0x00000714
#define ERROR_RESOURCE_TYPE_NOT_FOUND   0x00000715
#define ERROR_RESOURCE_NAME_NOT_FOUND   0x00000716
#define ERROR_RESOURCE_LANG_NOT_FOUND   0x00000717
#define ERROR_NOT_ENOUGH_QUOTA  0x00000718
#define RPC_S_NO_INTERFACES 0x00000719
#define RPC_S_CALL_CANCELLED    0x0000071A
#define RPC_S_BINDING_INCOMPLETE    0x0000071B
#define RPC_S_COMM_FAILURE  0x0000071C
#define RPC_S_UNSUPPORTED_AUTHN_LEVEL   0x0000071D
#define RPC_S_NO_PRINC_NAME 0x0000071E
#define RPC_S_NOT_RPC_ERROR 0x0000071F
#define RPC_S_UUID_LOCAL_ONLY   0x00000720
#define RPC_S_SEC_PKG_ERROR 0x00000721
#define RPC_S_NOT_CANCELLED 0x00000722
#define RPC_X_INVALID_ES_ACTION 0x00000723
#define RPC_X_WRONG_ES_VERSION  0x00000724
#define RPC_X_WRONG_STUB_VERSION    0x00000725
#define RPC_X_INVALID_PIPE_OBJECT   0x00000726
#define RPC_X_WRONG_PIPE_ORDER  0x00000727
#define RPC_X_WRONG_PIPE_VERSION    0x00000728
#define RPC_S_GROUP_MEMBER_NOT_FOUND    0x0000076A
#define EPT_S_CANT_CREATE   0x0000076B
#define RPC_S_INVALID_OBJECT    0x0000076C
#define ERROR_INVALID_TIME  0x0000076D
#define ERROR_INVALID_FORM_NAME 0x0000076E
#define ERROR_INVALID_FORM_SIZE 0x0000076F
#define ERROR_ALREADY_WAITING   0x00000770
#define ERROR_PRINTER_DELETED   0x00000771
#define ERROR_INVALID_PRINTER_STATE 0x00000772
#define ERROR_PASSWORD_MUST_CHANGE  0x00000773
#define ERROR_DOMAIN_CONTROLLER_NOT_FOUND   0x00000774
#define ERROR_ACCOUNT_LOCKED_OUT    0x00000775
#define OR_INVALID_OXID 0x00000776
#define OR_INVALID_OID  0x00000777
#define OR_INVALID_SET  0x00000778
#define RPC_S_SEND_INCOMPLETE   0x00000779
#define RPC_S_INVALID_ASYNC_HANDLE  0x0000077A
#define RPC_S_INVALID_ASYNC_CALL    0x0000077B
#define RPC_X_PIPE_CLOSED   0x0000077C
#define RPC_X_PIPE_DISCIPLINE_ERROR 0x0000077D
#define RPC_X_PIPE_EMPTY    0x0000077E
#define ERROR_NO_SITENAME   0x0000077F
#define ERROR_CANT_ACCESS_FILE  0x00000780
#define ERROR_CANT_RESOLVE_FILENAME 0x00000781
#define RPC_S_ENTRY_TYPE_MISMATCH   0x00000782
#define RPC_S_NOT_ALL_OBJS_EXPORTED 0x00000783
#define RPC_S_INTERFACE_NOT_EXPORTED    0x00000784
#define RPC_S_PROFILE_NOT_ADDED 0x00000785
#define RPC_S_PRF_ELT_NOT_ADDED 0x00000786
#define RPC_S_PRF_ELT_NOT_REMOVED   0x00000787
#define RPC_S_GRP_ELT_NOT_ADDED 0x00000788
#define RPC_S_GRP_ELT_NOT_REMOVED   0x00000789
#define ERROR_KM_DRIVER_BLOCKED 0x0000078A
#define ERROR_CONTEXT_EXPIRED   0x0000078B
#define ERROR_PER_USER_TRUST_QUOTA_EXCEEDED 0x0000078C
#define ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED 0x0000078D
#define ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED  0x0000078E
#define ERROR_AUTHENTICATION_FIREWALL_FAILED    0x0000078F
#define ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED  0x00000790
#define ERROR_INVALID_PIXEL_FORMAT  0x000007D0
#define ERROR_BAD_DRIVER    0x000007D1
#define ERROR_INVALID_WINDOW_STYLE  0x000007D2
#define ERROR_METAFILE_NOT_SUPPORTED    0x000007D3
#define ERROR_TRANSFORM_NOT_SUPPORTED   0x000007D4
#define ERROR_CLIPPING_NOT_SUPPORTED    0x000007D5
#define ERROR_INVALID_CMM   0x000007DA
#define ERROR_INVALID_PROFILE   0x000007DB
#define ERROR_TAG_NOT_FOUND 0x000007DC
#define ERROR_TAG_NOT_PRESENT   0x000007DD
#define ERROR_DUPLICATE_TAG 0x000007DE
#define ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE    0x000007DF
#define ERROR_PROFILE_NOT_FOUND 0x000007E0
#define ERROR_INVALID_COLORSPACE    0x000007E1
#define ERROR_ICM_NOT_ENABLED   0x000007E2
#define ERROR_DELETING_ICM_XFORM    0x000007E3
#define ERROR_INVALID_TRANSFORM 0x000007E4
#define ERROR_COLORSPACE_MISMATCH   0x000007E5
#define ERROR_INVALID_COLORINDEX    0x000007E6
#define ERROR_CONNECTED_OTHER_PASSWORD  0x0000083C
#define ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT  0x0000083D
#define ERROR_BAD_USERNAME  0x0000089A
#define ERROR_NOT_CONNECTED 0x000008CA
#define ERROR_OPEN_FILES    0x00000961
#define ERROR_ACTIVE_CONNECTIONS    0x00000962
#define ERROR_DEVICE_IN_USE 0x00000964
#define ERROR_UNKNOWN_PRINT_MONITOR 0x00000BB8
#define ERROR_PRINTER_DRIVER_IN_USE 0x00000BB9
#define ERROR_SPOOL_FILE_NOT_FOUND  0x00000BBA
#define ERROR_SPL_NO_STARTDOC   0x00000BBB
#define ERROR_SPL_NO_ADDJOB 0x00000BBC
#define ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED 0x00000BBD
#define ERROR_PRINT_MONITOR_ALREADY_INSTALLED   0x00000BBE
#define ERROR_INVALID_PRINT_MONITOR 0x00000BBF
#define ERROR_PRINT_MONITOR_IN_USE  0x00000BC0
#define ERROR_PRINTER_HAS_JOBS_QUEUED   0x00000BC1
#define ERROR_SUCCESS_REBOOT_REQUIRED   0x00000BC2
#define ERROR_SUCCESS_RESTART_REQUIRED  0x00000BC3
#define ERROR_PRINTER_NOT_FOUND 0x00000BC4
#define ERROR_PRINTER_DRIVER_WARNED 0x00000BC5
#define ERROR_PRINTER_DRIVER_BLOCKED    0x00000BC6
#define ERROR_WINS_INTERNAL 0x00000FA0
#define ERROR_CAN_NOT_DEL_LOCAL_WINS    0x00000FA1
#define ERROR_STATIC_INIT   0x00000FA2
#define ERROR_INC_BACKUP    0x00000FA3
#define ERROR_FULL_BACKUP   0x00000FA4
#define ERROR_REC_NON_EXISTENT  0x00000FA5
#define ERROR_RPL_NOT_ALLOWED   0x00000FA6
#define ERROR_DHCP_ADDRESS_CONFLICT 0x00001004
#define ERROR_WMI_GUID_NOT_FOUND    0x00001068
#define ERROR_WMI_INSTANCE_NOT_FOUND    0x00001069
#define ERROR_WMI_ITEMID_NOT_FOUND  0x0000106A
#define ERROR_WMI_TRY_AGAIN 0x0000106B
#define ERROR_WMI_DP_NOT_FOUND  0x0000106C
#define ERROR_WMI_UNRESOLVED_INSTANCE_REF   0x0000106D
#define ERROR_WMI_ALREADY_ENABLED   0x0000106E
#define ERROR_WMI_GUID_DISCONNECTED 0x0000106F
#define ERROR_WMI_SERVER_UNAVAILABLE    0x00001070
#define ERROR_WMI_DP_FAILED 0x00001071
#define ERROR_WMI_INVALID_MOF   0x00001072
#define ERROR_WMI_INVALID_REGINFO   0x00001073
#define ERROR_WMI_ALREADY_DISABLED  0x00001074
#define ERROR_WMI_READ_ONLY 0x00001075
#define ERROR_WMI_SET_FAILURE   0x00001076
#define ERROR_INVALID_MEDIA 0x000010CC
#define ERROR_INVALID_LIBRARY   0x000010CD
#define ERROR_INVALID_MEDIA_POOL    0x000010CE
#define ERROR_DRIVE_MEDIA_MISMATCH  0x000010CF
#define ERROR_MEDIA_OFFLINE 0x000010D0
#define ERROR_LIBRARY_OFFLINE   0x000010D1
#define ERROR_EMPTY 0x000010D2
#define ERROR_NOT_EMPTY 0x000010D3
#define ERROR_MEDIA_UNAVAILABLE 0x000010D4
#define ERROR_RESOURCE_DISABLED 0x000010D5
#define ERROR_INVALID_CLEANER   0x000010D6
#define ERROR_UNABLE_TO_CLEAN   0x000010D7
#define ERROR_OBJECT_NOT_FOUND  0x000010D8
#define ERROR_DATABASE_FAILURE  0x000010D9
#define ERROR_DATABASE_FULL 0x000010DA
#define ERROR_MEDIA_INCOMPATIBLE    0x000010DB
#define ERROR_RESOURCE_NOT_PRESENT  0x000010DC
#define ERROR_INVALID_OPERATION 0x000010DD
#define ERROR_MEDIA_NOT_AVAILABLE   0x000010DE
#define ERROR_DEVICE_NOT_AVAILABLE  0x000010DF
#define ERROR_REQUEST_REFUSED   0x000010E0
#define ERROR_INVALID_DRIVE_OBJECT  0x000010E1
#define ERROR_LIBRARY_FULL  0x000010E2
#define ERROR_MEDIUM_NOT_ACCESSIBLE 0x000010E3
#define ERROR_UNABLE_TO_LOAD_MEDIUM 0x000010E4
#define ERROR_UNABLE_TO_INVENTORY_DRIVE 0x000010E5
#define ERROR_UNABLE_TO_INVENTORY_SLOT  0x000010E6
#define ERROR_UNABLE_TO_INVENTORY_TRANSPORT 0x000010E7
#define ERROR_TRANSPORT_FULL    0x000010E8
#define ERROR_CONTROLLING_IEPORT    0x000010E9
#define ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA 0x000010EA
#define ERROR_CLEANER_SLOT_SET  0x000010EB
#define ERROR_CLEANER_SLOT_NOT_SET  0x000010EC
#define ERROR_CLEANER_CARTRIDGE_SPENT   0x000010ED
#define ERROR_UNEXPECTED_OMID   0x000010EE
#define ERROR_CANT_DELETE_LAST_ITEM 0x000010EF
#define ERROR_MESSAGE_EXCEEDS_MAX_SIZE  0x000010F0
#define ERROR_VOLUME_CONTAINS_SYS_FILES 0x000010F1
#define ERROR_INDIGENOUS_TYPE   0x000010F2
#define ERROR_NO_SUPPORTING_DRIVES  0x000010F3
#define ERROR_CLEANER_CARTRIDGE_INSTALLED   0x000010F4
#define ERROR_FILE_OFFLINE  0x000010FE
#define ERROR_REMOTE_STORAGE_NOT_ACTIVE 0x000010FF
#define ERROR_REMOTE_STORAGE_MEDIA_ERROR    0x00001100
#define ERROR_NOT_A_REPARSE_POINT   0x00001126
#define ERROR_REPARSE_ATTRIBUTE_CONFLICT    0x00001127
#define ERROR_INVALID_REPARSE_DATA  0x00001128
#define ERROR_REPARSE_TAG_INVALID   0x00001129
#define ERROR_REPARSE_TAG_MISMATCH  0x0000112A
#define ERROR_VOLUME_NOT_SIS_ENABLED    0x00001194
#define ERROR_DEPENDENT_RESOURCE_EXISTS 0x00001389
#define ERROR_DEPENDENCY_NOT_FOUND  0x0000138A
#define ERROR_DEPENDENCY_ALREADY_EXISTS 0x0000138B
#define ERROR_RESOURCE_NOT_ONLINE   0x0000138C
#define ERROR_HOST_NODE_NOT_AVAILABLE   0x0000138D
#define ERROR_RESOURCE_NOT_AVAILABLE    0x0000138E
#define ERROR_RESOURCE_NOT_FOUND    0x0000138F
#define ERROR_SHUTDOWN_CLUSTER  0x00001390
#define ERROR_CANT_EVICT_ACTIVE_NODE    0x00001391
#define ERROR_OBJECT_ALREADY_EXISTS 0x00001392
#define ERROR_OBJECT_IN_LIST    0x00001393
#define ERROR_GROUP_NOT_AVAILABLE   0x00001394
#define ERROR_GROUP_NOT_FOUND   0x00001395
#define ERROR_GROUP_NOT_ONLINE  0x00001396
#define ERROR_HOST_NODE_NOT_RESOURCE_OWNER  0x00001397
#define ERROR_HOST_NODE_NOT_GROUP_OWNER 0x00001398
#define ERROR_RESMON_CREATE_FAILED  0x00001399
#define ERROR_RESMON_ONLINE_FAILED  0x0000139A
#define ERROR_RESOURCE_ONLINE   0x0000139B
#define ERROR_QUORUM_RESOURCE   0x0000139C
#define ERROR_NOT_QUORUM_CAPABLE    0x0000139D
#define ERROR_CLUSTER_SHUTTING_DOWN 0x0000139E
#define ERROR_INVALID_STATE 0x0000139F
#define ERROR_RESOURCE_PROPERTIES_STORED    0x000013A0
#define ERROR_NOT_QUORUM_CLASS  0x000013A1
#define ERROR_CORE_RESOURCE 0x000013A2
#define ERROR_QUORUM_RESOURCE_ONLINE_FAILED 0x000013A3
#define ERROR_QUORUMLOG_OPEN_FAILED 0x000013A4
#define ERROR_CLUSTERLOG_CORRUPT    0x000013A5
#define ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE 0x000013A6
#define ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE    0x000013A7
#define ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND 0x000013A8
#define ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE   0x000013A9
#define ERROR_QUORUM_OWNER_ALIVE    0x000013AA
#define ERROR_NETWORK_NOT_AVAILABLE 0x000013AB
#define ERROR_NODE_NOT_AVAILABLE    0x000013AC
#define ERROR_ALL_NODES_NOT_AVAILABLE   0x000013AD
#define ERROR_RESOURCE_FAILED   0x000013AE
#define ERROR_CLUSTER_INVALID_NODE  0x000013AF
#define ERROR_CLUSTER_NODE_EXISTS   0x000013B0
#define ERROR_CLUSTER_JOIN_IN_PROGRESS  0x000013B1
#define ERROR_CLUSTER_NODE_NOT_FOUND    0x000013B2
#define ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND  0x000013B3
#define ERROR_CLUSTER_NETWORK_EXISTS    0x000013B4
#define ERROR_CLUSTER_NETWORK_NOT_FOUND 0x000013B5
#define ERROR_CLUSTER_NETINTERFACE_EXISTS   0x000013B6
#define ERROR_CLUSTER_NETINTERFACE_NOT_FOUND    0x000013B7
#define ERROR_CLUSTER_INVALID_REQUEST   0x000013B8
#define ERROR_CLUSTER_INVALID_NETWORK_PROVIDER  0x000013B9
#define ERROR_CLUSTER_NODE_DOWN 0x000013BA
#define ERROR_CLUSTER_NODE_UNREACHABLE  0x000013BB
#define ERROR_CLUSTER_NODE_NOT_MEMBER   0x000013BC
#define ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS  0x000013BD
#define ERROR_CLUSTER_INVALID_NETWORK   0x000013BE
#define ERROR_CLUSTER_NODE_UP   0x000013C0
#define ERROR_CLUSTER_IPADDR_IN_USE 0x000013C1
#define ERROR_CLUSTER_NODE_NOT_PAUSED   0x000013C2
#define ERROR_CLUSTER_NO_SECURITY_CONTEXT   0x000013C3
#define ERROR_CLUSTER_NETWORK_NOT_INTERNAL  0x000013C4
#define ERROR_CLUSTER_NODE_ALREADY_UP   0x000013C5
#define ERROR_CLUSTER_NODE_ALREADY_DOWN 0x000013C6
#define ERROR_CLUSTER_NETWORK_ALREADY_ONLINE    0x000013C7
#define ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE   0x000013C8
#define ERROR_CLUSTER_NODE_ALREADY_MEMBER   0x000013C9
#define ERROR_CLUSTER_LAST_INTERNAL_NETWORK 0x000013CA
#define ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS    0x000013CB
#define ERROR_INVALID_OPERATION_ON_QUORUM   0x000013CC
#define ERROR_DEPENDENCY_NOT_ALLOWED    0x000013CD
#define ERROR_CLUSTER_NODE_PAUSED   0x000013CE
#define ERROR_NODE_CANT_HOST_RESOURCE   0x000013CF
#define ERROR_CLUSTER_NODE_NOT_READY    0x000013D0
#define ERROR_CLUSTER_NODE_SHUTTING_DOWN    0x000013D1
#define ERROR_CLUSTER_JOIN_ABORTED  0x000013D2
#define ERROR_CLUSTER_INCOMPATIBLE_VERSIONS 0x000013D3
#define ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED  0x000013D4
#define ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED 0x000013D5
#define ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND   0x000013D6
#define ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED 0x000013D7
#define ERROR_CLUSTER_RESNAME_NOT_FOUND 0x000013D8
#define ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED    0x000013D9
#define ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST 0x000013DA
#define ERROR_CLUSTER_DATABASE_SEQMISMATCH  0x000013DB
#define ERROR_RESMON_INVALID_STATE  0x000013DC
#define ERROR_CLUSTER_GUM_NOT_LOCKER    0x000013DD
#define ERROR_QUORUM_DISK_NOT_FOUND 0x000013DE
#define ERROR_DATABASE_BACKUP_CORRUPT   0x000013DF
#define ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT 0x000013E0
#define ERROR_RESOURCE_PROPERTY_UNCHANGEABLE    0x000013E1
#define ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE  0x00001702
#define ERROR_CLUSTER_QUORUMLOG_NOT_FOUND   0x00001703
#define ERROR_CLUSTER_MEMBERSHIP_HALT   0x00001704
#define ERROR_CLUSTER_INSTANCE_ID_MISMATCH  0x00001705
#define ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP  0x00001706
#define ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH   0x00001707
#define ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP 0x00001708
#define ERROR_CLUSTER_PARAMETER_MISMATCH    0x00001709
#define ERROR_NODE_CANNOT_BE_CLUSTERED  0x0000170A
#define ERROR_CLUSTER_WRONG_OS_VERSION  0x0000170B
#define ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME  0x0000170C
#define ERROR_CLUSCFG_ALREADY_COMMITTED 0x0000170D
#define ERROR_CLUSCFG_ROLLBACK_FAILED   0x0000170E
#define ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT 0x0000170F
#define ERROR_CLUSTER_OLD_VERSION   0x00001710
#define ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME 0x00001711
#define ERROR_ENCRYPTION_FAILED 0x00001770
#define ERROR_DECRYPTION_FAILED 0x00001771
#define ERROR_FILE_ENCRYPTED    0x00001772
#define ERROR_NO_RECOVERY_POLICY    0x00001773
#define ERROR_NO_EFS    0x00001774
#define ERROR_WRONG_EFS 0x00001775
#define ERROR_NO_USER_KEYS  0x00001776
#define ERROR_FILE_NOT_ENCRYPTED    0x00001777
#define ERROR_NOT_EXPORT_FORMAT 0x00001778
#define ERROR_FILE_READ_ONLY    0x00001779
#define ERROR_DIR_EFS_DISALLOWED    0x0000177A
#define ERROR_EFS_SERVER_NOT_TRUSTED    0x0000177B
#define ERROR_BAD_RECOVERY_POLICY   0x0000177C
#define ERROR_EFS_ALG_BLOB_TOO_BIG  0x0000177D
#define ERROR_VOLUME_NOT_SUPPORT_EFS    0x0000177E
#define ERROR_EFS_DISABLED  0x0000177F
#define ERROR_EFS_VERSION_NOT_SUPPORT   0x00001780
#define ERROR_NO_BROWSER_SERVERS_FOUND  0x000017E6
#define SCHED_E_SERVICE_NOT_LOCALSYSTEM 0x00001838
#define ERROR_CTX_WINSTATION_NAME_INVALID   0x00001B59
#define ERROR_CTX_INVALID_PD    0x00001B5A
#define ERROR_CTX_PD_NOT_FOUND  0x00001B5B
#define ERROR_CTX_WD_NOT_FOUND  0x00001B5C
#define ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY    0x00001B5D
#define ERROR_CTX_SERVICE_NAME_COLLISION    0x00001B5E
#define ERROR_CTX_CLOSE_PENDING 0x00001B5F
#define ERROR_CTX_NO_OUTBUF 0x00001B60
#define ERROR_CTX_MODEM_INF_NOT_FOUND   0x00001B61
#define ERROR_CTX_INVALID_MODEMNAME 0x00001B62
#define ERROR_CTX_MODEM_RESPONSE_ERROR  0x00001B63
#define ERROR_CTX_MODEM_RESPONSE_TIMEOUT    0x00001B64
#define ERROR_CTX_MODEM_RESPONSE_NO_CARRIER 0x00001B65
#define ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE    0x00001B66
#define ERROR_CTX_MODEM_RESPONSE_BUSY   0x00001B67
#define ERROR_CTX_MODEM_RESPONSE_VOICE  0x00001B68
#define ERROR_CTX_TD_ERROR  0x00001B69
#define ERROR_CTX_WINSTATION_NOT_FOUND  0x00001B6E
#define ERROR_CTX_WINSTATION_ALREADY_EXISTS 0x00001B6F
#define ERROR_CTX_WINSTATION_BUSY   0x00001B70
#define ERROR_CTX_BAD_VIDEO_MODE    0x00001B71
#define ERROR_CTX_GRAPHICS_INVALID  0x00001B7B
#define ERROR_CTX_LOGON_DISABLED    0x00001B7D
#define ERROR_CTX_NOT_CONSOLE   0x00001B7E
#define ERROR_CTX_CLIENT_QUERY_TIMEOUT  0x00001B80
#define ERROR_CTX_CONSOLE_DISCONNECT    0x00001B81
#define ERROR_CTX_CONSOLE_CONNECT   0x00001B82
#define ERROR_CTX_SHADOW_DENIED 0x00001B84
#define ERROR_CTX_WINSTATION_ACCESS_DENIED  0x00001B85
#define ERROR_CTX_INVALID_WD    0x00001B89
#define ERROR_CTX_SHADOW_INVALID    0x00001B8A
#define ERROR_CTX_SHADOW_DISABLED   0x00001B8B
#define ERROR_CTX_CLIENT_LICENSE_IN_USE 0x00001B8C
#define ERROR_CTX_CLIENT_LICENSE_NOT_SET    0x00001B8D
#define ERROR_CTX_LICENSE_NOT_AVAILABLE 0x00001B8E
#define ERROR_CTX_LICENSE_CLIENT_INVALID    0x00001B8F
#define ERROR_CTX_LICENSE_EXPIRED   0x00001B90
#define ERROR_CTX_SHADOW_NOT_RUNNING    0x00001B91
#define ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE   0x00001B92
#define ERROR_ACTIVATION_COUNT_EXCEEDED 0x00001B93
#define FRS_ERR_INVALID_API_SEQUENCE    0x00001F41
#define FRS_ERR_STARTING_SERVICE    0x00001F42
#define FRS_ERR_STOPPING_SERVICE    0x00001F43
#define FRS_ERR_INTERNAL_API    0x00001F44
#define FRS_ERR_INTERNAL    0x00001F45
#define FRS_ERR_SERVICE_COMM    0x00001F46
#define FRS_ERR_INSUFFICIENT_PRIV   0x00001F47
#define FRS_ERR_AUTHENTICATION  0x00001F48
#define FRS_ERR_PARENT_INSUFFICIENT_PRIV    0x00001F49
#define FRS_ERR_PARENT_AUTHENTICATION   0x00001F4A
#define FRS_ERR_CHILD_TO_PARENT_COMM    0x00001F4B
#define FRS_ERR_PARENT_TO_CHILD_COMM    0x00001F4C
#define FRS_ERR_SYSVOL_POPULATE 0x00001F4D
#define FRS_ERR_SYSVOL_POPULATE_TIMEOUT 0x00001F4E
#define FRS_ERR_SYSVOL_IS_BUSY  0x00001F4F
#define FRS_ERR_SYSVOL_DEMOTE   0x00001F50
#define FRS_ERR_INVALID_SERVICE_PARAMETER   0x00001F51
#define DS_S_SUCCESS    0x00000000
#define ERROR_DS_NOT_INSTALLED  0x00002008
#define ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY   0x00002009
#define ERROR_DS_NO_ATTRIBUTE_OR_VALUE  0x0000200A
#define ERROR_DS_INVALID_ATTRIBUTE_SYNTAX   0x0000200B
#define ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED   0x0000200C
#define ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS  0x0000200D
#define ERROR_DS_BUSY   0x0000200E
#define ERROR_DS_UNAVAILABLE    0x0000200F
#define ERROR_DS_NO_RIDS_ALLOCATED  0x00002010
#define ERROR_DS_NO_MORE_RIDS   0x00002011
#define ERROR_DS_INCORRECT_ROLE_OWNER   0x00002012
#define ERROR_DS_RIDMGR_INIT_ERROR  0x00002013
#define ERROR_DS_OBJ_CLASS_VIOLATION    0x00002014
#define ERROR_DS_CANT_ON_NON_LEAF   0x00002015
#define ERROR_DS_CANT_ON_RDN    0x00002016
#define ERROR_DS_CANT_MOD_OBJ_CLASS 0x00002017
#define ERROR_DS_CROSS_DOM_MOVE_ERROR   0x00002018
#define ERROR_DS_GC_NOT_AVAILABLE   0x00002019
#define ERROR_SHARED_POLICY 0x0000201A
#define ERROR_POLICY_OBJECT_NOT_FOUND   0x0000201B
#define ERROR_POLICY_ONLY_IN_DS 0x0000201C
#define ERROR_PROMOTION_ACTIVE  0x0000201D
#define ERROR_NO_PROMOTION_ACTIVE   0x0000201E
#define ERROR_DS_OPERATIONS_ERROR   0x00002020
#define ERROR_DS_PROTOCOL_ERROR 0x00002021
#define ERROR_DS_TIMELIMIT_EXCEEDED 0x00002022
#define ERROR_DS_SIZELIMIT_EXCEEDED 0x00002023
#define ERROR_DS_ADMIN_LIMIT_EXCEEDED   0x00002024
#define ERROR_DS_COMPARE_FALSE  0x00002025
#define ERROR_DS_COMPARE_TRUE   0x00002026
#define ERROR_DS_AUTH_METHOD_NOT_SUPPORTED  0x00002027
#define ERROR_DS_STRONG_AUTH_REQUIRED   0x00002028
#define ERROR_DS_INAPPROPRIATE_AUTH 0x00002029
#define ERROR_DS_AUTH_UNKNOWN   0x0000202A
#define ERROR_DS_REFERRAL   0x0000202B
#define ERROR_DS_UNAVAILABLE_CRIT_EXTENSION 0x0000202C
#define ERROR_DS_CONFIDENTIALITY_REQUIRED   0x0000202D
#define ERROR_DS_INAPPROPRIATE_MATCHING 0x0000202E
#define ERROR_DS_CONSTRAINT_VIOLATION   0x0000202F
#define ERROR_DS_NO_SUCH_OBJECT 0x00002030
#define ERROR_DS_ALIAS_PROBLEM  0x00002031
#define ERROR_DS_INVALID_DN_SYNTAX  0x00002032
#define ERROR_DS_IS_LEAF    0x00002033
#define ERROR_DS_ALIAS_DEREF_PROBLEM    0x00002034
#define ERROR_DS_UNWILLING_TO_PERFORM   0x00002035
#define ERROR_DS_LOOP_DETECT    0x00002036
#define ERROR_DS_NAMING_VIOLATION   0x00002037
#define ERROR_DS_OBJECT_RESULTS_TOO_LARGE   0x00002038
#define ERROR_DS_AFFECTS_MULTIPLE_DSAS  0x00002039
#define ERROR_DS_SERVER_DOWN    0x0000203A
#define ERROR_DS_LOCAL_ERROR    0x0000203B
#define ERROR_DS_ENCODING_ERROR 0x0000203C
#define ERROR_DS_DECODING_ERROR 0x0000203D
#define ERROR_DS_FILTER_UNKNOWN 0x0000203E
#define ERROR_DS_PARAM_ERROR    0x0000203F
#define ERROR_DS_NOT_SUPPORTED  0x00002040
#define ERROR_DS_NO_RESULTS_RETURNED    0x00002041
#define ERROR_DS_CONTROL_NOT_FOUND  0x00002042
#define ERROR_DS_CLIENT_LOOP    0x00002043
#define ERROR_DS_REFERRAL_LIMIT_EXCEEDED    0x00002044
#define ERROR_DS_SORT_CONTROL_MISSING   0x00002045
#define ERROR_DS_OFFSET_RANGE_ERROR 0x00002046
#define ERROR_DS_ROOT_MUST_BE_NC    0x0000206D
#define ERROR_DS_ADD_REPLICA_INHIBITED  0x0000206E
#define ERROR_DS_ATT_NOT_DEF_IN_SCHEMA  0x0000206F
#define ERROR_DS_MAX_OBJ_SIZE_EXCEEDED  0x00002070
#define ERROR_DS_OBJ_STRING_NAME_EXISTS 0x00002071
#define ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA   0x00002072
#define ERROR_DS_RDN_DOESNT_MATCH_SCHEMA    0x00002073
#define ERROR_DS_NO_REQUESTED_ATTS_FOUND    0x00002074
#define ERROR_DS_USER_BUFFER_TO_SMALL   0x00002075
#define ERROR_DS_ATT_IS_NOT_ON_OBJ  0x00002076
#define ERROR_DS_ILLEGAL_MOD_OPERATION  0x00002077
#define ERROR_DS_OBJ_TOO_LARGE  0x00002078
#define ERROR_DS_BAD_INSTANCE_TYPE  0x00002079
#define ERROR_DS_MASTERDSA_REQUIRED 0x0000207A
#define ERROR_DS_OBJECT_CLASS_REQUIRED  0x0000207B
#define ERROR_DS_MISSING_REQUIRED_ATT   0x0000207C
#define ERROR_DS_ATT_NOT_DEF_FOR_CLASS  0x0000207D
#define ERROR_DS_ATT_ALREADY_EXISTS 0x0000207E
#define ERROR_DS_CANT_ADD_ATT_VALUES    0x00002080
#define ERROR_DS_SINGLE_VALUE_CONSTRAINT    0x00002081
#define ERROR_DS_RANGE_CONSTRAINT   0x00002082
#define ERROR_DS_ATT_VAL_ALREADY_EXISTS 0x00002083
#define ERROR_DS_CANT_REM_MISSING_ATT   0x00002084
#define ERROR_DS_CANT_REM_MISSING_ATT_VAL   0x00002085
#define ERROR_DS_ROOT_CANT_BE_SUBREF    0x00002086
#define ERROR_DS_NO_CHAINING    0x00002087
#define ERROR_DS_NO_CHAINED_EVAL    0x00002088
#define ERROR_DS_NO_PARENT_OBJECT   0x00002089
#define ERROR_DS_PARENT_IS_AN_ALIAS 0x0000208A
#define ERROR_DS_CANT_MIX_MASTER_AND_REPS   0x0000208B
#define ERROR_DS_CHILDREN_EXIST 0x0000208C
#define ERROR_DS_OBJ_NOT_FOUND  0x0000208D
#define ERROR_DS_ALIASED_OBJ_MISSING    0x0000208E
#define ERROR_DS_BAD_NAME_SYNTAX    0x0000208F
#define ERROR_DS_ALIAS_POINTS_TO_ALIAS  0x00002090
#define ERROR_DS_CANT_DEREF_ALIAS   0x00002091
#define ERROR_DS_OUT_OF_SCOPE   0x00002092
#define ERROR_DS_OBJECT_BEING_REMOVED   0x00002093
#define ERROR_DS_CANT_DELETE_DSA_OBJ    0x00002094
#define ERROR_DS_GENERIC_ERROR  0x00002095
#define ERROR_DS_DSA_MUST_BE_INT_MASTER 0x00002096
#define ERROR_DS_CLASS_NOT_DSA  0x00002097
#define ERROR_DS_INSUFF_ACCESS_RIGHTS   0x00002098
#define ERROR_DS_ILLEGAL_SUPERIOR   0x00002099
#define ERROR_DS_ATTRIBUTE_OWNED_BY_SAM 0x0000209A
#define ERROR_DS_NAME_TOO_MANY_PARTS    0x0000209B
#define ERROR_DS_NAME_TOO_LONG  0x0000209C
#define ERROR_DS_NAME_VALUE_TOO_LONG    0x0000209D
#define ERROR_DS_NAME_UNPARSEABLE   0x0000209E
#define ERROR_DS_NAME_TYPE_UNKNOWN  0x0000209F
#define ERROR_DS_NOT_AN_OBJECT  0x000020A0
#define ERROR_DS_SEC_DESC_TOO_SHORT 0x000020A1
#define ERROR_DS_SEC_DESC_INVALID   0x000020A2
#define ERROR_DS_NO_DELETED_NAME    0x000020A3
#define ERROR_DS_SUBREF_MUST_HAVE_PARENT    0x000020A4
#define ERROR_DS_NCNAME_MUST_BE_NC  0x000020A5
#define ERROR_DS_CANT_ADD_SYSTEM_ONLY   0x000020A6
#define ERROR_DS_CLASS_MUST_BE_CONCRETE 0x000020A7
#define ERROR_DS_INVALID_DMD    0x000020A8
#define ERROR_DS_OBJ_GUID_EXISTS    0x000020A9
#define ERROR_DS_NOT_ON_BACKLINK    0x000020AA
#define ERROR_DS_NO_CROSSREF_FOR_NC 0x000020AB
#define ERROR_DS_SHUTTING_DOWN  0x000020AC
#define ERROR_DS_UNKNOWN_OPERATION  0x000020AD
#define ERROR_DS_INVALID_ROLE_OWNER 0x000020AE
#define ERROR_DS_COULDNT_CONTACT_FSMO   0x000020AF
#define ERROR_DS_CROSS_NC_DN_RENAME 0x000020B0
#define ERROR_DS_CANT_MOD_SYSTEM_ONLY   0x000020B1
#define ERROR_DS_REPLICATOR_ONLY    0x000020B2
#define ERROR_DS_OBJ_CLASS_NOT_DEFINED  0x000020B3
#define ERROR_DS_OBJ_CLASS_NOT_SUBCLASS 0x000020B4
#define ERROR_DS_NAME_REFERENCE_INVALID 0x000020B5
#define ERROR_DS_CROSS_REF_EXISTS   0x000020B6
#define ERROR_DS_CANT_DEL_MASTER_CROSSREF   0x000020B7
#define ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD 0x000020B8
#define ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX  0x000020B9
#define ERROR_DS_DUP_RDN    0x000020BA
#define ERROR_DS_DUP_OID    0x000020BB
#define ERROR_DS_DUP_MAPI_ID    0x000020BC
#define ERROR_DS_DUP_SCHEMA_ID_GUID 0x000020BD
#define ERROR_DS_DUP_LDAP_DISPLAY_NAME  0x000020BE
#define ERROR_DS_SEMANTIC_ATT_TEST  0x000020BF
#define ERROR_DS_SYNTAX_MISMATCH    0x000020C0
#define ERROR_DS_EXISTS_IN_MUST_HAVE    0x000020C1
#define ERROR_DS_EXISTS_IN_MAY_HAVE 0x000020C2
#define ERROR_DS_NONEXISTENT_MAY_HAVE   0x000020C3
#define ERROR_DS_NONEXISTENT_MUST_HAVE  0x000020C4
#define ERROR_DS_AUX_CLS_TEST_FAIL  0x000020C5
#define ERROR_DS_NONEXISTENT_POSS_SUP   0x000020C6
#define ERROR_DS_SUB_CLS_TEST_FAIL  0x000020C7
#define ERROR_DS_BAD_RDN_ATT_ID_SYNTAX  0x000020C8
#define ERROR_DS_EXISTS_IN_AUX_CLS  0x000020C9
#define ERROR_DS_EXISTS_IN_SUB_CLS  0x000020CA
#define ERROR_DS_EXISTS_IN_POSS_SUP 0x000020CB
#define ERROR_DS_RECALCSCHEMA_FAILED    0x000020CC
#define ERROR_DS_TREE_DELETE_NOT_FINISHED   0x000020CD
#define ERROR_DS_CANT_DELETE    0x000020CE
#define ERROR_DS_ATT_SCHEMA_REQ_ID  0x000020CF
#define ERROR_DS_BAD_ATT_SCHEMA_SYNTAX  0x000020D0
#define ERROR_DS_CANT_CACHE_ATT 0x000020D1
#define ERROR_DS_CANT_CACHE_CLASS   0x000020D2
#define ERROR_DS_CANT_REMOVE_ATT_CACHE  0x000020D3
#define ERROR_DS_CANT_REMOVE_CLASS_CACHE    0x000020D4
#define ERROR_DS_CANT_RETRIEVE_DN   0x000020D5
#define ERROR_DS_MISSING_SUPREF 0x000020D6
#define ERROR_DS_CANT_RETRIEVE_INSTANCE 0x000020D7
#define ERROR_DS_CODE_INCONSISTENCY 0x000020D8
#define ERROR_DS_DATABASE_ERROR 0x000020D9
#define ERROR_DS_GOVERNSID_MISSING  0x000020DA
#define ERROR_DS_MISSING_EXPECTED_ATT   0x000020DB
#define ERROR_DS_NCNAME_MISSING_CR_REF  0x000020DC
#define ERROR_DS_SECURITY_CHECKING_ERROR    0x000020DD
#define ERROR_DS_SCHEMA_NOT_LOADED  0x000020DE
#define ERROR_DS_SCHEMA_ALLOC_FAILED    0x000020DF
#define ERROR_DS_ATT_SCHEMA_REQ_SYNTAX  0x000020E0
#define ERROR_DS_GCVERIFY_ERROR 0x000020E1
#define ERROR_DS_DRA_SCHEMA_MISMATCH    0x000020E2
#define ERROR_DS_CANT_FIND_DSA_OBJ  0x000020E3
#define ERROR_DS_CANT_FIND_EXPECTED_NC  0x000020E4
#define ERROR_DS_CANT_FIND_NC_IN_CACHE  0x000020E5
#define ERROR_DS_CANT_RETRIEVE_CHILD    0x000020E6
#define ERROR_DS_SECURITY_ILLEGAL_MODIFY    0x000020E7
#define ERROR_DS_CANT_REPLACE_HIDDEN_REC    0x000020E8
#define ERROR_DS_BAD_HIERARCHY_FILE 0x000020E9
#define ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED   0x000020EA
#define ERROR_DS_CONFIG_PARAM_MISSING   0x000020EB
#define ERROR_DS_COUNTING_AB_INDICES_FAILED 0x000020EC
#define ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED  0x000020ED
#define ERROR_DS_INTERNAL_FAILURE   0x000020EE
#define ERROR_DS_UNKNOWN_ERROR  0x000020EF
#define ERROR_DS_ROOT_REQUIRES_CLASS_TOP    0x000020F0
#define ERROR_DS_REFUSING_FSMO_ROLES    0x000020F1
#define ERROR_DS_MISSING_FSMO_SETTINGS  0x000020F2
#define ERROR_DS_UNABLE_TO_SURRENDER_ROLES  0x000020F3
#define ERROR_DS_DRA_GENERIC    0x000020F4
#define ERROR_DS_DRA_INVALID_PARAMETER  0x000020F5
#define ERROR_DS_DRA_BUSY   0x000020F6
#define ERROR_DS_DRA_BAD_DN 0x000020F7
#define ERROR_DS_DRA_BAD_NC 0x000020F8
#define ERROR_DS_DRA_DN_EXISTS  0x000020F9
#define ERROR_DS_DRA_INTERNAL_ERROR 0x000020FA
#define ERROR_DS_DRA_INCONSISTENT_DIT   0x000020FB
#define ERROR_DS_DRA_CONNECTION_FAILED  0x000020FC
#define ERROR_DS_DRA_BAD_INSTANCE_TYPE  0x000020FD
#define ERROR_DS_DRA_OUT_OF_MEM 0x000020FE
#define ERROR_DS_DRA_MAIL_PROBLEM   0x000020FF
#define ERROR_DS_DRA_REF_ALREADY_EXISTS 0x00002100
#define ERROR_DS_DRA_REF_NOT_FOUND  0x00002101
#define ERROR_DS_DRA_OBJ_IS_REP_SOURCE  0x00002102
#define ERROR_DS_DRA_DB_ERROR   0x00002103
#define ERROR_DS_DRA_NO_REPLICA 0x00002104
#define ERROR_DS_DRA_ACCESS_DENIED  0x00002105
#define ERROR_DS_DRA_NOT_SUPPORTED  0x00002106
#define ERROR_DS_DRA_RPC_CANCELLED  0x00002107
#define ERROR_DS_DRA_SOURCE_DISABLED    0x00002108
#define ERROR_DS_DRA_SINK_DISABLED  0x00002109
#define ERROR_DS_DRA_NAME_COLLISION 0x0000210A
#define ERROR_DS_DRA_SOURCE_REINSTALLED 0x0000210B
#define ERROR_DS_DRA_MISSING_PARENT 0x0000210C
#define ERROR_DS_DRA_PREEMPTED  0x0000210D
#define ERROR_DS_DRA_ABANDON_SYNC   0x0000210E
#define ERROR_DS_DRA_SHUTDOWN   0x0000210F
#define ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET   0x00002110
#define ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA  0x00002111
#define ERROR_DS_DRA_EXTN_CONNECTION_FAILED 0x00002112
#define ERROR_DS_INSTALL_SCHEMA_MISMATCH    0x00002113
#define ERROR_DS_DUP_LINK_ID    0x00002114
#define ERROR_DS_NAME_ERROR_RESOLVING   0x00002115
#define ERROR_DS_NAME_ERROR_NOT_FOUND   0x00002116
#define ERROR_DS_NAME_ERROR_NOT_UNIQUE  0x00002117
#define ERROR_DS_NAME_ERROR_NO_MAPPING  0x00002118
#define ERROR_DS_NAME_ERROR_DOMAIN_ONLY 0x00002119
#define ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING  0x0000211A
#define ERROR_DS_CONSTRUCTED_ATT_MOD    0x0000211B
#define ERROR_DS_WRONG_OM_OBJ_CLASS 0x0000211C
#define ERROR_DS_DRA_REPL_PENDING   0x0000211D
#define ERROR_DS_DS_REQUIRED    0x0000211E
#define ERROR_DS_INVALID_LDAP_DISPLAY_NAME  0x0000211F
#define ERROR_DS_NON_BASE_SEARCH    0x00002120
#define ERROR_DS_CANT_RETRIEVE_ATTS 0x00002121
#define ERROR_DS_BACKLINK_WITHOUT_LINK  0x00002122
#define ERROR_DS_EPOCH_MISMATCH 0x00002123
#define ERROR_DS_SRC_NAME_MISMATCH  0x00002124
#define ERROR_DS_SRC_AND_DST_NC_IDENTICAL   0x00002125
#define ERROR_DS_DST_NC_MISMATCH    0x00002126
#define ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC 0x00002127
#define ERROR_DS_SRC_GUID_MISMATCH  0x00002128
#define ERROR_DS_CANT_MOVE_DELETED_OBJECT   0x00002129
#define ERROR_DS_PDC_OPERATION_IN_PROGRESS  0x0000212A
#define ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD  0x0000212B
#define ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION    0x0000212C
#define ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS    0x0000212D
#define ERROR_DS_NC_MUST_HAVE_NC_PARENT 0x0000212E
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE  0x0000212F
#define ERROR_DS_DST_DOMAIN_NOT_NATIVE  0x00002130
#define ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER   0x00002131
#define ERROR_DS_CANT_MOVE_ACCOUNT_GROUP    0x00002132
#define ERROR_DS_CANT_MOVE_RESOURCE_GROUP   0x00002133
#define ERROR_DS_INVALID_SEARCH_FLAG    0x00002134
#define ERROR_DS_NO_TREE_DELETE_ABOVE_NC    0x00002135
#define ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE   0x00002136
#define ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE   0x00002137
#define ERROR_DS_SAM_INIT_FAILURE   0x00002138
#define ERROR_DS_SENSITIVE_GROUP_VIOLATION  0x00002139
#define ERROR_DS_CANT_MOD_PRIMARYGROUPID    0x0000213A
#define ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD    0x0000213B
#define ERROR_DS_NONSAFE_SCHEMA_CHANGE  0x0000213C
#define ERROR_DS_SCHEMA_UPDATE_DISALLOWED   0x0000213D
#define ERROR_DS_CANT_CREATE_UNDER_SCHEMA   0x0000213E
#define ERROR_DS_INSTALL_NO_SRC_SCH_VERSION 0x0000213F
#define ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE  0x00002140
#define ERROR_DS_INVALID_GROUP_TYPE 0x00002141
#define ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN 0x00002142
#define ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN  0x00002143
#define ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER  0x00002144
#define ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER  0x00002145
#define ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER   0x00002146
#define ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER    0x00002147
#define ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER   0x00002148
#define ERROR_DS_HAVE_PRIMARY_MEMBERS   0x00002149
#define ERROR_DS_STRING_SD_CONVERSION_FAILED    0x0000214A
#define ERROR_DS_NAMING_MASTER_GC   0x0000214B
#define ERROR_DS_DNS_LOOKUP_FAILURE 0x0000214C
#define ERROR_DS_COULDNT_UPDATE_SPNS    0x0000214D
#define ERROR_DS_CANT_RETRIEVE_SD   0x0000214E
#define ERROR_DS_KEY_NOT_UNIQUE 0x0000214F
#define ERROR_DS_WRONG_LINKED_ATT_SYNTAX    0x00002150
#define ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD  0x00002151
#define ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY    0x00002152
#define ERROR_DS_CANT_START 0x00002153
#define ERROR_DS_INIT_FAILURE   0x00002154
#define ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION   0x00002155
#define ERROR_DS_SOURCE_DOMAIN_IN_FOREST    0x00002156
#define ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST   0x00002157
#define ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED   0x00002158
#define ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN    0x00002159
#define ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER  0x0000215A
#define ERROR_DS_SRC_SID_EXISTS_IN_FOREST   0x0000215B
#define ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH  0x0000215C
#define ERROR_SAM_INIT_FAILURE  0x0000215D
#define ERROR_DS_DRA_SCHEMA_INFO_SHIP   0x0000215E
#define ERROR_DS_DRA_SCHEMA_CONFLICT    0x0000215F
#define ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT    0x00002160
#define ERROR_DS_DRA_OBJ_NC_MISMATCH    0x00002161
#define ERROR_DS_NC_STILL_HAS_DSAS  0x00002162
#define ERROR_DS_GC_REQUIRED    0x00002163
#define ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY 0x00002164
#define ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS 0x00002165
#define ERROR_DS_CANT_ADD_TO_GC 0x00002166
#define ERROR_DS_NO_CHECKPOINT_WITH_PDC 0x00002167
#define ERROR_DS_SOURCE_AUDITING_NOT_ENABLED    0x00002168
#define ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC    0x00002169
#define ERROR_DS_INVALID_NAME_FOR_SPN   0x0000216A
#define ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS   0x0000216B
#define ERROR_DS_UNICODEPWD_NOT_IN_QUOTES   0x0000216C
#define ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED 0x0000216D
#define ERROR_DS_MUST_BE_RUN_ON_DST_DC  0x0000216E
#define ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER  0x0000216F
#define ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ  0x00002170
#define ERROR_DS_INIT_FAILURE_CONSOLE   0x00002171
#define ERROR_DS_SAM_INIT_FAILURE_CONSOLE   0x00002172
#define ERROR_DS_FOREST_VERSION_TOO_HIGH    0x00002173
#define ERROR_DS_DOMAIN_VERSION_TOO_HIGH    0x00002174
#define ERROR_DS_FOREST_VERSION_TOO_LOW 0x00002175
#define ERROR_DS_DOMAIN_VERSION_TOO_LOW 0x00002176
#define ERROR_DS_INCOMPATIBLE_VERSION   0x00002177
#define ERROR_DS_LOW_DSA_VERSION    0x00002178
#define ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN 0x00002179
#define ERROR_DS_NOT_SUPPORTED_SORT_ORDER   0x0000217A
#define ERROR_DS_NAME_NOT_UNIQUE    0x0000217B
#define ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 0x0000217C
#define ERROR_DS_OUT_OF_VERSION_STORE   0x0000217D
#define ERROR_DS_INCOMPATIBLE_CONTROLS_USED 0x0000217E
#define ERROR_DS_NO_REF_DOMAIN  0x0000217F
#define ERROR_DS_RESERVED_LINK_ID   0x00002180
#define ERROR_DS_LINK_ID_NOT_AVAILABLE  0x00002181
#define ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER  0x00002182
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE   0x00002183
#define ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC    0x00002184
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG    0x00002185
#define ERROR_DS_MODIFYDN_WRONG_GRANDPARENT 0x00002186
#define ERROR_DS_NAME_ERROR_TRUST_REFERRAL  0x00002187
#define ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER  0x00002188
#define ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD  0x00002189
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2   0x0000218A
#define ERROR_DS_THREAD_LIMIT_EXCEEDED  0x0000218B
#define ERROR_DS_NOT_CLOSEST    0x0000218C
#define ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF 0x0000218D
#define ERROR_DS_SINGLE_USER_MODE_FAILED    0x0000218E
#define ERROR_DS_NTDSCRIPT_SYNTAX_ERROR 0x0000218F
#define ERROR_DS_NTDSCRIPT_PROCESS_ERROR    0x00002190
#define ERROR_DS_DIFFERENT_REPL_EPOCHS  0x00002191
#define ERROR_DS_DRS_EXTENSIONS_CHANGED 0x00002192
#define ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR  0x00002193
#define ERROR_DS_NO_MSDS_INTID  0x00002194
#define ERROR_DS_DUP_MSDS_INTID 0x00002195
#define ERROR_DS_EXISTS_IN_RDNATTID 0x00002196
#define ERROR_DS_AUTHORIZATION_FAILED   0x00002197
#define ERROR_DS_INVALID_SCRIPT 0x00002198
#define ERROR_DS_REMOTE_CROSSREF_OP_FAILED  0x00002199
#define ERROR_DS_CROSS_REF_BUSY 0x0000219A
#define ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN 0x0000219B
#define ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC  0x0000219C
#define ERROR_DS_DUPLICATE_ID_FOUND 0x0000219D
#define ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT 0x0000219E
#define ERROR_DS_GROUP_CONVERSION_ERROR 0x0000219F
#define ERROR_DS_CANT_MOVE_APP_BASIC_GROUP  0x000021A0
#define ERROR_DS_CANT_MOVE_APP_QUERY_GROUP  0x000021A1
#define ERROR_DS_ROLE_NOT_VERIFIED  0x000021A2
#define ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL    0x000021A3
#define ERROR_DS_DOMAIN_RENAME_IN_PROGRESS  0x000021A4
#define ERROR_DS_EXISTING_AD_CHILD_NC   0x000021A5
#define ERROR_DS_REPL_LIFETIME_EXCEEDED 0x000021A6
#define ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER 0x000021A7
#define ERROR_DS_LDAP_SEND_QUEUE_FULL   0x000021A8
#define DNS_ERROR_RESPONSE_CODES_BASE   0x00002328
#define DNS_ERROR_RCODE_NO_ERROR    0x00000000
#define DNS_ERROR_MASK  0x00002328
#define DNS_ERROR_RCODE_FORMAT_ERROR    0x00002329
#define DNS_ERROR_RCODE_SERVER_FAILURE  0x0000232A
#define DNS_ERROR_RCODE_NAME_ERROR  0x0000232B
#define DNS_ERROR_RCODE_NOT_IMPLEMENTED 0x0000232C
#define DNS_ERROR_RCODE_REFUSED 0x0000232D
#define DNS_ERROR_RCODE_YXDOMAIN    0x0000232E
#define DNS_ERROR_RCODE_YXRRSET 0x0000232F
#define DNS_ERROR_RCODE_NXRRSET 0x00002330
#define DNS_ERROR_RCODE_NOTAUTH 0x00002331
#define DNS_ERROR_RCODE_NOTZONE 0x00002332
#define DNS_ERROR_RCODE_BADSIG  0x00002338
#define DNS_ERROR_RCODE_BADKEY  0x00002339
#define DNS_ERROR_RCODE_BADTIME 0x0000233A
#define DNS_ERROR_RCODE_LAST    0x0000233A
#define DNS_ERROR_PACKET_FMT_BASE   0x0000251C
#define DNS_INFO_NO_RECORDS 0x0000251D
#define DNS_ERROR_BAD_PACKET    0x0000251E
#define DNS_ERROR_NO_PACKET 0x0000251F
#define DNS_ERROR_RCODE 0x00002520
#define DNS_ERROR_UNSECURE_PACKET   0x00002521
#define DNS_STATUS_PACKET_UNSECURE  0x00002521
#define DNS_ERROR_NO_MEMORY 0x0000000E
#define DNS_ERROR_INVALID_NAME  0x0000007B
#define DNS_ERROR_INVALID_DATA  0x0000000D
#define DNS_ERROR_GENERAL_API_BASE  0x0000254E
#define DNS_ERROR_INVALID_TYPE  0x0000254F
#define DNS_ERROR_INVALID_IP_ADDRESS    0x00002550
#define DNS_ERROR_INVALID_PROPERTY  0x00002551
#define DNS_ERROR_TRY_AGAIN_LATER   0x00002552
#define DNS_ERROR_NOT_UNIQUE    0x00002553
#define DNS_ERROR_NON_RFC_NAME  0x00002554
#define DNS_STATUS_FQDN 0x00002555
#define DNS_STATUS_DOTTED_NAME  0x00002556
#define DNS_STATUS_SINGLE_PART_NAME 0x00002557
#define DNS_ERROR_INVALID_NAME_CHAR 0x00002558
#define DNS_ERROR_NUMERIC_NAME  0x00002559
#define DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER    0x0000255A
#define DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION  0x0000255B
#define DNS_ERROR_CANNOT_FIND_ROOT_HINTS    0x0000255C
#define DNS_ERROR_INCONSISTENT_ROOT_HINTS   0x0000255D
#define DNS_ERROR_ZONE_BASE 0x00002580
#define DNS_ERROR_ZONE_DOES_NOT_EXIST   0x00002581
#define DNS_ERROR_NO_ZONE_INFO  0x00002582
#define DNS_ERROR_INVALID_ZONE_OPERATION    0x00002583
#define DNS_ERROR_ZONE_CONFIGURATION_ERROR  0x00002584
#define DNS_ERROR_ZONE_HAS_NO_SOA_RECORD    0x00002585
#define DNS_ERROR_ZONE_HAS_NO_NS_RECORDS    0x00002586
#define DNS_ERROR_ZONE_LOCKED   0x00002587
#define DNS_ERROR_ZONE_CREATION_FAILED  0x00002588
#define DNS_ERROR_ZONE_ALREADY_EXISTS   0x00002589
#define DNS_ERROR_AUTOZONE_ALREADY_EXISTS   0x0000258A
#define DNS_ERROR_INVALID_ZONE_TYPE 0x0000258B
#define DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP  0x0000258C
#define DNS_ERROR_ZONE_NOT_SECONDARY    0x0000258D
#define DNS_ERROR_NEED_SECONDARY_ADDRESSES  0x0000258E
#define DNS_ERROR_WINS_INIT_FAILED  0x0000258F
#define DNS_ERROR_NEED_WINS_SERVERS 0x00002590
#define DNS_ERROR_NBSTAT_INIT_FAILED    0x00002591
#define DNS_ERROR_SOA_DELETE_INVALID    0x00002592
#define DNS_ERROR_FORWARDER_ALREADY_EXISTS  0x00002593
#define DNS_ERROR_ZONE_REQUIRES_MASTER_IP   0x00002594
#define DNS_ERROR_ZONE_IS_SHUTDOWN  0x00002595
#define DNS_ERROR_DATAFILE_BASE 0x000025B2
#define DNS_ERROR_PRIMARY_REQUIRES_DATAFILE 0x000025B3
#define DNS_ERROR_INVALID_DATAFILE_NAME 0x000025B4
#define DNS_ERROR_DATAFILE_OPEN_FAILURE 0x000025B5
#define DNS_ERROR_FILE_WRITEBACK_FAILED 0x000025B6
#define DNS_ERROR_DATAFILE_PARSING  0x000025B7
#define DNS_ERROR_DATABASE_BASE 0x000025E4
#define DNS_ERROR_RECORD_DOES_NOT_EXIST 0x000025E5
#define DNS_ERROR_RECORD_FORMAT 0x000025E6
#define DNS_ERROR_NODE_CREATION_FAILED  0x000025E7
#define DNS_ERROR_UNKNOWN_RECORD_TYPE   0x000025E8
#define DNS_ERROR_RECORD_TIMED_OUT  0x000025E9
#define DNS_ERROR_NAME_NOT_IN_ZONE  0x000025EA
#define DNS_ERROR_CNAME_LOOP    0x000025EB
#define DNS_ERROR_NODE_IS_CNAME 0x000025EC
#define DNS_ERROR_CNAME_COLLISION   0x000025ED
#define DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT  0x000025EE
#define DNS_ERROR_RECORD_ALREADY_EXISTS 0x000025EF
#define DNS_ERROR_SECONDARY_DATA    0x000025F0
#define DNS_ERROR_NO_CREATE_CACHE_DATA  0x000025F1
#define DNS_ERROR_NAME_DOES_NOT_EXIST   0x000025F2
#define DNS_WARNING_PTR_CREATE_FAILED   0x000025F3
#define DNS_WARNING_DOMAIN_UNDELETED    0x000025F4
#define DNS_ERROR_DS_UNAVAILABLE    0x000025F5
#define DNS_ERROR_DS_ZONE_ALREADY_EXISTS    0x000025F6
#define DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE    0x000025F7
#define DNS_ERROR_OPERATION_BASE    0x00002616
#define DNS_INFO_AXFR_COMPLETE  0x00002617
#define DNS_ERROR_AXFR  0x00002618
#define DNS_INFO_ADDED_LOCAL_WINS   0x00002619
#define DNS_ERROR_SECURE_BASE   0x00002648
#define DNS_STATUS_CONTINUE_NEEDED  0x00002649
#define DNS_ERROR_SETUP_BASE    0x0000267A
#define DNS_ERROR_NO_TCPIP  0x0000267B
#define DNS_ERROR_NO_DNS_SERVERS    0x0000267C
#define DNS_ERROR_DP_BASE   0x000026AC
#define DNS_ERROR_DP_DOES_NOT_EXIST 0x000026AD
#define DNS_ERROR_DP_ALREADY_EXISTS 0x000026AE
#define DNS_ERROR_DP_NOT_ENLISTED   0x000026AF
#define DNS_ERROR_DP_ALREADY_ENLISTED   0x000026B0
#define DNS_ERROR_DP_NOT_AVAILABLE  0x000026B1
#define WSABASEERR  0x00002710
#define WSAEINTR    0x00002714
#define WSAEBADF    0x00002719
#define WSAEACCES   0x0000271D
#define WSAEFAULT   0x0000271E
#define WSAEINVAL   0x00002726
#define WSAEMFILE   0x00002728
#define WSAEWOULDBLOCK  0x00002733
#define WSAEINPROGRESS  0x00002734
#define WSAEALREADY 0x00002735
#define WSAENOTSOCK 0x00002736
#define WSAEDESTADDRREQ 0x00002737
#define WSAEMSGSIZE 0x00002738
#define WSAEPROTOTYPE   0x00002739
#define WSAENOPROTOOPT  0x0000273A
#define WSAEPROTONOSUPPORT  0x0000273B
#define WSAESOCKTNOSUPPORT  0x0000273C
#define WSAEOPNOTSUPP   0x0000273D
#define WSAEPFNOSUPPORT 0x0000273E
#define WSAEAFNOSUPPORT 0x0000273F
#define WSAEADDRINUSE   0x00002740
#define WSAEADDRNOTAVAIL    0x00002741
#define WSAENETDOWN 0x00002742
#define WSAENETUNREACH  0x00002743
#define WSAENETRESET    0x00002744
#define WSAECONNABORTED 0x00002745
#define WSAECONNRESET   0x00002746
#define WSAENOBUFS  0x00002747
#define WSAEISCONN  0x00002748
#define WSAENOTCONN 0x00002749
#define WSAESHUTDOWN    0x0000274A
#define WSAETOOMANYREFS 0x0000274B
#define WSAETIMEDOUT    0x0000274C
#define WSAECONNREFUSED 0x0000274D
#define WSAELOOP    0x0000274E
#define WSAENAMETOOLONG 0x0000274F
#define WSAEHOSTDOWN    0x00002750
#define WSAEHOSTUNREACH 0x00002751
#define WSAENOTEMPTY    0x00002752
#define WSAEPROCLIM 0x00002753
#define WSAEUSERS   0x00002754
#define WSAEDQUOT   0x00002755
#define WSAESTALE   0x00002756
#define WSAEREMOTE  0x00002757
#define WSASYSNOTREADY  0x0000276B
#define WSAVERNOTSUPPORTED  0x0000276C
#define WSANOTINITIALISED   0x0000276D
#define WSAEDISCON  0x00002775
#define WSAENOMORE  0x00002776
#define WSAECANCELLED   0x00002777
#define WSAEINVALIDPROCTABLE    0x00002778
#define WSAEINVALIDPROVIDER 0x00002779
#define WSAEPROVIDERFAILEDINIT  0x0000277A
#define WSASYSCALLFAILURE   0x0000277B
#define WSASERVICE_NOT_FOUND    0x0000277C
#define WSATYPE_NOT_FOUND   0x0000277D
#define WSA_E_NO_MORE   0x0000277E
#define WSA_E_CANCELLED 0x0000277F
#define WSAEREFUSED 0x00002780
#define WSAHOST_NOT_FOUND   0x00002AF9
#define WSATRY_AGAIN    0x00002AFA
#define WSANO_RECOVERY  0x00002AFB
#define WSANO_DATA  0x00002AFC
#define WSA_QOS_RECEIVERS   0x00002AFD
#define WSA_QOS_SENDERS 0x00002AFE
#define WSA_QOS_NO_SENDERS  0x00002AFF
#define WSA_QOS_NO_RECEIVERS    0x00002B00
#define WSA_QOS_REQUEST_CONFIRMED   0x00002B01
#define WSA_QOS_ADMISSION_FAILURE   0x00002B02
#define WSA_QOS_POLICY_FAILURE  0x00002B03
#define WSA_QOS_BAD_STYLE   0x00002B04
#define WSA_QOS_BAD_OBJECT  0x00002B05
#define WSA_QOS_TRAFFIC_CTRL_ERROR  0x00002B06
#define WSA_QOS_GENERIC_ERROR   0x00002B07
#define WSA_QOS_ESERVICETYPE    0x00002B08
#define WSA_QOS_EFLOWSPEC   0x00002B09
#define WSA_QOS_EPROVSPECBUF    0x00002B0A
#define WSA_QOS_EFILTERSTYLE    0x00002B0B
#define WSA_QOS_EFILTERTYPE 0x00002B0C
#define WSA_QOS_EFILTERCOUNT    0x00002B0D
#define WSA_QOS_EOBJLENGTH  0x00002B0E
#define WSA_QOS_EFLOWCOUNT  0x00002B0F
#define WSA_QOS_EUNKOWNPSOBJ    0x00002B10
#define WSA_QOS_EPOLICYOBJ  0x00002B11
#define WSA_QOS_EFLOWDESC   0x00002B12
#define WSA_QOS_EPSFLOWSPEC 0x00002B13
#define WSA_QOS_EPSFILTERSPEC   0x00002B14
#define WSA_QOS_ESDMODEOBJ  0x00002B15
#define WSA_QOS_ESHAPERATEOBJ   0x00002B16
#define WSA_QOS_RESERVED_PETYPE 0x00002B17
#define ERROR_SXS_SECTION_NOT_FOUND 0x000036B0
#define ERROR_SXS_CANT_GEN_ACTCTX   0x000036B1
#define ERROR_SXS_INVALID_ACTCTXDATA_FORMAT 0x000036B2
#define ERROR_SXS_ASSEMBLY_NOT_FOUND    0x000036B3
#define ERROR_SXS_MANIFEST_FORMAT_ERROR 0x000036B4
#define ERROR_SXS_MANIFEST_PARSE_ERROR  0x000036B5
#define ERROR_SXS_ACTIVATION_CONTEXT_DISABLED   0x000036B6
#define ERROR_SXS_KEY_NOT_FOUND 0x000036B7
#define ERROR_SXS_VERSION_CONFLICT  0x000036B8
#define ERROR_SXS_WRONG_SECTION_TYPE    0x000036B9
#define ERROR_SXS_THREAD_QUERIES_DISABLED   0x000036BA
#define ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET   0x000036BB
#define ERROR_SXS_UNKNOWN_ENCODING_GROUP    0x000036BC
#define ERROR_SXS_UNKNOWN_ENCODING  0x000036BD
#define ERROR_SXS_INVALID_XML_NAMESPACE_URI 0x000036BE
#define ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED    0x000036BF
#define ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED    0x000036C0
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE   0x000036C1
#define ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE   0x000036C2
#define ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE   0x000036C3
#define ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT    0x000036C4
#define ERROR_SXS_DUPLICATE_DLL_NAME    0x000036C5
#define ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME    0x000036C6
#define ERROR_SXS_DUPLICATE_CLSID   0x000036C7
#define ERROR_SXS_DUPLICATE_IID 0x000036C8
#define ERROR_SXS_DUPLICATE_TLBID   0x000036C9
#define ERROR_SXS_DUPLICATE_PROGID  0x000036CA
#define ERROR_SXS_DUPLICATE_ASSEMBLY_NAME   0x000036CB
#define ERROR_SXS_FILE_HASH_MISMATCH    0x000036CC
#define ERROR_SXS_POLICY_PARSE_ERROR    0x000036CD
#define ERROR_SXS_XML_E_MISSINGQUOTE    0x000036CE
#define ERROR_SXS_XML_E_COMMENTSYNTAX   0x000036CF
#define ERROR_SXS_XML_E_BADSTARTNAMECHAR    0x000036D0
#define ERROR_SXS_XML_E_BADNAMECHAR 0x000036D1
#define ERROR_SXS_XML_E_BADCHARINSTRING 0x000036D2
#define ERROR_SXS_XML_E_XMLDECLSYNTAX   0x000036D3
#define ERROR_SXS_XML_E_BADCHARDATA 0x000036D4
#define ERROR_SXS_XML_E_MISSINGWHITESPACE   0x000036D5
#define ERROR_SXS_XML_E_EXPECTINGTAGEND 0x000036D6
#define ERROR_SXS_XML_E_MISSINGSEMICOLON    0x000036D7
#define ERROR_SXS_XML_E_UNBALANCEDPAREN 0x000036D8
#define ERROR_SXS_XML_E_INTERNALERROR   0x000036D9
#define ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE   0x000036DA
#define ERROR_SXS_XML_E_INCOMPLETE_ENCODING 0x000036DB
#define ERROR_SXS_XML_E_MISSING_PAREN   0x000036DC
#define ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE 0x000036DD
#define ERROR_SXS_XML_E_MULTIPLE_COLONS 0x000036DE
#define ERROR_SXS_XML_E_INVALID_DECIMAL 0x000036DF
#define ERROR_SXS_XML_E_INVALID_HEXIDECIMAL 0x000036E0
#define ERROR_SXS_XML_E_INVALID_UNICODE 0x000036E1
#define ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK    0x000036E2
#define ERROR_SXS_XML_E_UNEXPECTEDENDTAG    0x000036E3
#define ERROR_SXS_XML_E_UNCLOSEDTAG 0x000036E4
#define ERROR_SXS_XML_E_DUPLICATEATTRIBUTE  0x000036E5
#define ERROR_SXS_XML_E_MULTIPLEROOTS   0x000036E6
#define ERROR_SXS_XML_E_INVALIDATROOTLEVEL  0x000036E7
#define ERROR_SXS_XML_E_BADXMLDECL  0x000036E8
#define ERROR_SXS_XML_E_MISSINGROOT 0x000036E9
#define ERROR_SXS_XML_E_UNEXPECTEDEOF   0x000036EA
#define ERROR_SXS_XML_E_BADPEREFINSUBSET    0x000036EB
#define ERROR_SXS_XML_E_UNCLOSEDSTARTTAG    0x000036EC
#define ERROR_SXS_XML_E_UNCLOSEDENDTAG  0x000036ED
#define ERROR_SXS_XML_E_UNCLOSEDSTRING  0x000036EE
#define ERROR_SXS_XML_E_UNCLOSEDCOMMENT 0x000036EF
#define ERROR_SXS_XML_E_UNCLOSEDDECL    0x000036F0
#define ERROR_SXS_XML_E_UNCLOSEDCDATA   0x000036F1
#define ERROR_SXS_XML_E_RESERVEDNAMESPACE   0x000036F2
#define ERROR_SXS_XML_E_INVALIDENCODING 0x000036F3
#define ERROR_SXS_XML_E_INVALIDSWITCH   0x000036F4
#define ERROR_SXS_XML_E_BADXMLCASE  0x000036F5
#define ERROR_SXS_XML_E_INVALID_STANDALONE  0x000036F6
#define ERROR_SXS_XML_E_UNEXPECTED_STANDALONE   0x000036F7
#define ERROR_SXS_XML_E_INVALID_VERSION 0x000036F8
#define ERROR_SXS_XML_E_MISSINGEQUALS   0x000036F9
#define ERROR_SXS_PROTECTION_RECOVERY_FAILED    0x000036FA
#define ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT   0x000036FB
#define ERROR_SXS_PROTECTION_CATALOG_NOT_VALID  0x000036FC
#define ERROR_SXS_UNTRANSLATABLE_HRESULT    0x000036FD
#define ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING   0x000036FE
#define ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE   0x000036FF
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME  0x00003700
#define ERROR_IPSEC_QM_POLICY_EXISTS    0x000032C8
#define ERROR_IPSEC_QM_POLICY_NOT_FOUND 0x000032C9
#define ERROR_IPSEC_QM_POLICY_IN_USE    0x000032CA
#define ERROR_IPSEC_MM_POLICY_EXISTS    0x000032CB
#define ERROR_IPSEC_MM_POLICY_NOT_FOUND 0x000032CC
#define ERROR_IPSEC_MM_POLICY_IN_USE    0x000032CD
#define ERROR_IPSEC_MM_FILTER_EXISTS    0x000032CE
#define ERROR_IPSEC_MM_FILTER_NOT_FOUND 0x000032CF
#define ERROR_IPSEC_TRANSPORT_FILTER_EXISTS 0x000032D0
#define ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND  0x000032D1
#define ERROR_IPSEC_MM_AUTH_EXISTS  0x000032D2
#define ERROR_IPSEC_MM_AUTH_NOT_FOUND   0x000032D3
#define ERROR_IPSEC_MM_AUTH_IN_USE  0x000032D4
#define ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND 0x000032D5
#define ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND   0x000032D6
#define ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND 0x000032D7
#define ERROR_IPSEC_TUNNEL_FILTER_EXISTS    0x000032D8
#define ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND 0x000032D9
#define ERROR_IPSEC_MM_FILTER_PENDING_DELETION  0x000032DA
#define ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION   0x000032DB
#define ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION  0x000032DC
#define ERROR_IPSEC_MM_POLICY_PENDING_DELETION  0x000032DD
#define ERROR_IPSEC_MM_AUTH_PENDING_DELETION    0x000032DE
#define ERROR_IPSEC_QM_POLICY_PENDING_DELETION  0x000032DF
#define WARNING_IPSEC_MM_POLICY_PRUNED  0x000032E0
#define WARNING_IPSEC_QM_POLICY_PRUNED  0x000032E1
#define ERROR_IPSEC_IKE_NEG_STATUS_BEGIN    0x000035E8
#define ERROR_IPSEC_IKE_AUTH_FAIL   0x000035E9
#define ERROR_IPSEC_IKE_ATTRIB_FAIL 0x000035EA
#define ERROR_IPSEC_IKE_NEGOTIATION_PENDING 0x000035EB
#define ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR    0x000035EC
#define ERROR_IPSEC_IKE_TIMED_OUT   0x000035ED
#define ERROR_IPSEC_IKE_NO_CERT 0x000035EE
#define ERROR_IPSEC_IKE_SA_DELETED  0x000035EF
#define ERROR_IPSEC_IKE_SA_REAPED   0x000035F0
#define ERROR_IPSEC_IKE_MM_ACQUIRE_DROP 0x000035F1
#define ERROR_IPSEC_IKE_QM_ACQUIRE_DROP 0x000035F2
#define ERROR_IPSEC_IKE_QUEUE_DROP_MM   0x000035F3
#define ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM    0x000035F4
#define ERROR_IPSEC_IKE_DROP_NO_RESPONSE    0x000035F5
#define ERROR_IPSEC_IKE_MM_DELAY_DROP   0x000035F6
#define ERROR_IPSEC_IKE_QM_DELAY_DROP   0x000035F7
#define ERROR_IPSEC_IKE_ERROR   0x000035F8
#define ERROR_IPSEC_IKE_CRL_FAILED  0x000035F9
#define ERROR_IPSEC_IKE_INVALID_KEY_USAGE   0x000035FA
#define ERROR_IPSEC_IKE_INVALID_CERT_TYPE   0x000035FB
#define ERROR_IPSEC_IKE_NO_PRIVATE_KEY  0x000035FC
#define ERROR_IPSEC_IKE_DH_FAIL 0x000035FE
#define ERROR_IPSEC_IKE_INVALID_HEADER  0x00003600
#define ERROR_IPSEC_IKE_NO_POLICY   0x00003601
#define ERROR_IPSEC_IKE_INVALID_SIGNATURE   0x00003602
#define ERROR_IPSEC_IKE_KERBEROS_ERROR  0x00003603
#define ERROR_IPSEC_IKE_NO_PUBLIC_KEY   0x00003604
#define ERROR_IPSEC_IKE_PROCESS_ERR 0x00003605
#define ERROR_IPSEC_IKE_PROCESS_ERR_SA  0x00003606
#define ERROR_IPSEC_IKE_PROCESS_ERR_PROP    0x00003607
#define ERROR_IPSEC_IKE_PROCESS_ERR_TRANS   0x00003608
#define ERROR_IPSEC_IKE_PROCESS_ERR_KE  0x00003609
#define ERROR_IPSEC_IKE_PROCESS_ERR_ID  0x0000360A
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT    0x0000360B
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ    0x0000360C
#define ERROR_IPSEC_IKE_PROCESS_ERR_HASH    0x0000360D
#define ERROR_IPSEC_IKE_PROCESS_ERR_SIG 0x0000360E
#define ERROR_IPSEC_IKE_PROCESS_ERR_NONCE   0x0000360F
#define ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY  0x00003610
#define ERROR_IPSEC_IKE_PROCESS_ERR_DELETE  0x00003611
#define ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR  0x00003612
#define ERROR_IPSEC_IKE_INVALID_PAYLOAD 0x00003613
#define ERROR_IPSEC_IKE_LOAD_SOFT_SA    0x00003614
#define ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN   0x00003615
#define ERROR_IPSEC_IKE_INVALID_COOKIE  0x00003616
#define ERROR_IPSEC_IKE_NO_PEER_CERT    0x00003617
#define ERROR_IPSEC_IKE_PEER_CRL_FAILED 0x00003618
#define ERROR_IPSEC_IKE_POLICY_CHANGE   0x00003619
#define ERROR_IPSEC_IKE_NO_MM_POLICY    0x0000361A
#define ERROR_IPSEC_IKE_NOTCBPRIV   0x0000361B
#define ERROR_IPSEC_IKE_SECLOADFAIL 0x0000361C
#define ERROR_IPSEC_IKE_FAILSSPINIT 0x0000361D
#define ERROR_IPSEC_IKE_FAILQUERYSSP    0x0000361E
#define ERROR_IPSEC_IKE_SRVACQFAIL  0x0000361F
#define ERROR_IPSEC_IKE_SRVQUERYCRED    0x00003620
#define ERROR_IPSEC_IKE_GETSPIFAIL  0x00003621
#define ERROR_IPSEC_IKE_INVALID_FILTER  0x00003622
#define ERROR_IPSEC_IKE_OUT_OF_MEMORY   0x00003623
#define ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED   0x00003624
#define ERROR_IPSEC_IKE_INVALID_POLICY  0x00003625
#define ERROR_IPSEC_IKE_UNKNOWN_DOI 0x00003626
#define ERROR_IPSEC_IKE_INVALID_SITUATION   0x00003627
#define ERROR_IPSEC_IKE_DH_FAILURE  0x00003628
#define ERROR_IPSEC_IKE_INVALID_GROUP   0x00003629
#define ERROR_IPSEC_IKE_ENCRYPT 0x0000362A
#define ERROR_IPSEC_IKE_DECRYPT 0x0000362B
#define ERROR_IPSEC_IKE_POLICY_MATCH    0x0000362C
#define ERROR_IPSEC_IKE_UNSUPPORTED_ID  0x0000362D
#define ERROR_IPSEC_IKE_INVALID_HASH    0x0000362E
#define ERROR_IPSEC_IKE_INVALID_HASH_ALG    0x0000362F
#define ERROR_IPSEC_IKE_INVALID_HASH_SIZE   0x00003630
#define ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG 0x00003631
#define ERROR_IPSEC_IKE_INVALID_AUTH_ALG    0x00003632
#define ERROR_IPSEC_IKE_INVALID_SIG 0x00003633
#define ERROR_IPSEC_IKE_LOAD_FAILED 0x00003634
#define ERROR_IPSEC_IKE_RPC_DELETE  0x00003635
#define ERROR_IPSEC_IKE_BENIGN_REINIT   0x00003636
#define ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY   0x00003637
#define ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN 0x00003639
#define ERROR_IPSEC_IKE_MM_LIMIT    0x0000363A
#define ERROR_IPSEC_IKE_NEGOTIATION_DISABLED    0x0000363B
#define ERROR_IPSEC_IKE_NEG_STATUS_END  0x0000363C
#endif /* __WINERR_H__ */
