
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <malloc.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/neutrino.h>
#include <termios.h>
#include <devctl.h>
#include <sys/dcmd_chr.h>
#include <sys/iomsg.h>
#include <atomic.h>
#include <hw/inout.h>
#include <hw/8250.h>
#include <sys/io-char.h>
#include <sys/mman.h>

typedef struct dev_8250 {
	TTYDEV			tty;
	struct dev_8250	*next;
	unsigned		intr;
	unsigned		clk;
	unsigned		div;
	unsigned 		dev_id;
	unsigned 		rx_fifo; /* rx fifo size */
	unsigned 		tx_fifo; /* tx fifo size */
	unsigned 		fifo_override; /* fifo transmit override */
	uint32_t		port[0xF]; // we will be accessing upto XR_RXFIFOTRIG_REGISTER only; if we need to access others, need to increase the array 
} DEV_8250;

struct dev_list {
	struct dev_list	*next;
	DEV_8250		*device;
	int				iid;
};

TTYCTRL						ttyctrl;
struct dev_list				*devices;

/* Value used as an argument to TTO to override the check if the tx buffer
 * is empty.  This should only be used in the isr at the tx interrupt 
 * since this is the only time we can be sure that the tx fifo is empty.
 * This is required since there is no way to determine the number of char's
 * in the TX fifo - i.e. the amount of free space in the TX fifo.
 * Since the TX buffer empty flag is cleared in the II REG on both reading
 * the II REG and writing to the TX fifo, there shouldn't be any issues 
 * regarding nested TX interrupts overwriting data in the TX fifo. */
#define FIFO_XMIT_OVERRIDE		0x80

#define XR_EXTENDED_FCTR   0x08
#define XR_TXFIFOTRIG_REGISTER		   0x0a
#define XR_RXFIFOTRIG_REGISTER		   0x0b

#define XR_DIVISOR_LATCH_FRACTION 2

#include "proto.h"
