
#include "externs.h"


unsigned
options(int argc, char *argv[]) {
	int numports = 0;
	unsigned unit;
	static TTYINIT devinit ={
		0, 0, 0, 57600,
		2048, 2048, 256,
		0, 0, 0, 0, 64, 14745600, 16,
		"/dev/ser" };

	// Initialize the devinit to raw mode
	ttc(TTC_INIT_RAW, &devinit, 0);
	
	int pidx;
	void* hdl;
    void* retval;
    int phdl;
    struct pci_dev_info inf;

    phdl = pci_attach( 0 );
    if( phdl == -1 ) {
        fprintf( stderr, "Unable to initialize PCI server\n" );

        return(numports);
    }

    unsigned int devid[]={0x158, 0x154, 0x152, 0x258, 0x254, 0x252, 0x358, 0x354, 0x352};
    unit = 1;
    int i, j;
    i = 0;
    pidx = 0;
    while( i < ( sizeof(devid)/sizeof(devid[0]) ) )
    {
    	memset( &inf, 0, sizeof( inf ) );	    
	    inf.VendorId = 0x13a8;
    	inf.DeviceId = devid[i];
	    hdl = pci_attach_device( NULL, 0, pidx, &inf );
	    if( hdl != NULL ) 
	    {
	    	numports = devid[i] & 0xf;
	    	retval = pci_attach_device( hdl, PCI_INIT_ALL, pidx, &inf );
	        if( retval )	        
	        {	        	
        		for( j=0; j<numports; j++ )
        		{
        			if( devid[i] > 0x258 ) // for PCIe devices
        				devinit.port = inf.CpuBaseAddress[0] + (j*0x400);
        			else // for PCI devices
        				devinit.port = inf.CpuBaseAddress[0] + (j*0x200);
        			devinit.port_shift = 0;
        			devinit.intr = inf.Irq;
        			create_device(&devinit, unit++, devid[i]);
        		}
	        }
	        else
	        {
	        	fprintf( stderr, "Unable allocate PCI resources for 0x%x device\n", devid[i] );        	
	        }
	        
	        // find the next card of the same devid 
	        // hence, need not to increment i
	        pidx++; 
	    }
	    else
	    {	    	
	    	// increment i to search for the next devid
	    	// initialize pidx to zero instance
	    	i++;	    	
	    	pidx = 0;	    	
	    }
    }
    
    numports = unit-1;
    
	return(numports);
}
