#!/bin/sh
# This script was generated using Makeself 2.1.5

CRCsum="3697551422"
MD5="611a46665701b9060036d7de3fd90393"
TMPROOT=${TMPDIR:=/tmp}

label="Systembase PCI/PCIe device drvier installer"
script="./Install"
scriptargs=""
targetdir="sysbas_mpdrv.v23.0"
filesizes="38357"
keep=y

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

unset CDPATH

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf .
    done
}

MS_diskspace()
{
	(
	if test -d /usr/xpg4/bin; then
		PATH=/usr/xpg4/bin:$PATH
	fi
	df -kP "$1" | tail -1 | awk '{print $4}'
	)
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
Makeself version 2.1.5
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [--] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --noexec              Do not run embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --nochown             Do not give the extracted files to the current user
  --target NewDirectory Extract in NewDirectory
  --tar arg1 [arg2 ...] Access the contents of the archive through the tar command
  --                    Following arguments will be passed to the embedded script
EOH
}

MS_Check()
{
    OLD_PATH="$PATH"
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_ARG=""
    MD5_PATH=`exec <&- 2>&-; which md5sum || type md5sum`
    test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which md5 || type md5`
	test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which digest || type digest`
    PATH="$OLD_PATH"

    MS_Printf "Verifying archive integrity..."
    offset=`head -n 402 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
		crc=`echo $CRCsum | cut -d" " -f$i`
		if test -x "$MD5_PATH"; then
			if test `basename $MD5_PATH` = digest; then
				MD5_ARG="-a md5"
			fi
			md5=`echo $MD5 | cut -d" " -f$i`
			if test $md5 = "00000000000000000000000000000000"; then
				test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
			else
				md5sum=`MS_dd "$1" $offset $s | eval "$MD5_PATH $MD5_ARG" | cut -b-32`;
				if test "$md5sum" != "$md5"; then
					echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
					exit 2
				else
					test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
				fi
				crc="0000000000"; verb=n
			fi
		fi
		if test $crc = "0000000000"; then
			test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
		else
			sum1=`MS_dd "$1" $offset $s | CMD_ENV=xpg4 cksum | awk '{print $1}'`
			if test "$sum1" = "$crc"; then
				test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
			else
				echo "Error in checksums: $sum1 is different from $crc"
				exit 2;
			fi
		fi
		i=`expr $i + 1`
		offset=`expr $offset + $s`
    done
    echo " All good."
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 240 KB
	echo Compression: bzip2
	echo Date of packaging: Tue Feb 11 11:27:27 KST 2020
	echo Built with Makeself version 2.1.5 on linux-gnu
	echo Build command was: "./makeself-2.1.6/makeself.sh \\
    \"--bzip2\" \\
    \"sysbas_mpdrv.v23.0\" \\
    \"sysbas_mpdrv.v23.0.sh\" \\
    \"Systembase PCI/PCIe device drvier installer\" \\
    \"./Install\""
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"" = xcopy; then
		echo "Archive will copy itself to a temporary location"
	fi
	if test x"y" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --dumpconf)
	echo LABEL=\"$label\"
	echo SCRIPT=\"$script\"
	echo SCRIPTARGS=\"$scriptargs\"
	echo archdirname=\"sysbas_mpdrv.v23.0\"
	echo KEEP=y
	echo COMPRESS=bzip2
	echo filesizes=\"$filesizes\"
	echo CRCsum=\"$CRCsum\"
	echo MD5sum=\"$MD5\"
	echo OLDUSIZE=240
	echo OLDSKIP=403
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | UnTAR t
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
	--tar)
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
	--noexec)
	script=""
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --nochown)
	ownership=n
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    --)
	shift
	break ;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    tmpdir=$TMPROOT/makeself.$RANDOM.`date +"%y%m%d%H%M%S"`.$$
    mkdir "$tmpdir" || {
	echo "Could not create temporary directory $tmpdir" >&2
	exit 1
    }
    SCRIPT_COPY="$tmpdir/makeself"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2 -- $initargs
    ;;
phase2)
    finish="$finish ; rm -rf `dirname $0`"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir" >&2
	tmpdir="$targetdir"
	dashp="-p"
    else
	tmpdir="$TMPROOT/selfgz$$$RANDOM"
	dashp=""
    fi
    mkdir $dashp $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 402 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 240 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

MS_Printf "Uncompressing $label"
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15
fi

leftspace=`MS_diskspace $tmpdir`
if test $leftspace -lt 240; then
    echo
    echo "Not enough space left in "`dirname $tmpdir`" ($leftspace KB) to decompress $0 (240 KB)" >&2
    if test "$keep" = n; then
        echo "Consider setting TMPDIR to a directory with more free space."
   fi
    eval $finish; exit 1
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "bzip2 -d" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
if test "$keep" = n; then
    cd $TMPROOT
    /bin/rm -rf $tmpdir
fi
eval $finish; exit $res
BZh91AY&SYY;}b ^_:R}oqsǠx;0 y   ݫ
 컦}ѥ']Tl_`塽}>qϯt}\>ws6}wjѓ={t<[m6*
xv5*Tmoz|_oW
ox{'0o{vk}>N{.ͻ}pdP=GϽ}u{ky<\]F=s[cvـMVO>^wwN{_{|slgNG%;9os״3jwޞ}Mrɝ17)e|%}Ҿاܷzsvz{|6Y}ۥ=wwoww[ыw]wgv}oYmLmud{jE۾_[Sk=|
\Kkv{s[A[u{Z]۩vm}{7]s.  D	  	ɠ &  4C aO?jzR~M'ɤ4OOPLɚҞzjzЀ  xƩ<OO=@QPhzQڀ @         H$ASS#M6j=bhڃF z   h            M$ЌiM*~%<F~3Ԛz'!
j  @@ 6@        $F@M O)U=<HSihA"<1=4&
&FCMih4    $  M	h5<4SʟTȣzCڦz    @        5)xX?Y~K*i1ޤnD*1xy	#>XoF HMȊ!N;W;?nڔZWܮG}?Nl`ٻoᶹ)/p'"/]0io=UӸp&%%geXd~zEU,'9+eeQ%	ۦڭG,{h0οV㮌
e:5lPZϋGTNfeghKzG-O{FR~
M<99gIIdyML6KS	б"liLS_O
RG?_kZzS6.n>Wuަ=|<AR׻OYtñz_ZǤAv0Baa'4$ݔ?OXoo
L;Ԑfcn g&d ܙt[*]|]N_|_V?[{Ghz_fJi)a~vi{'/,Ao㾆esϡC3}giB_ɧryEA37Lavc%_*AL6c"Nϫ'Pޤ85?#C3e}Oo!#G{CҪŴ7Tc~{Uq(SNܥ{AWELá٩LThq%o&@hífbI~; o>'g>l'[sen) d+pūe@؆eD9F~`
АdP'di QV-z5eT*g:tg<7&K=/VbGv1Џx<v:	ևrU+$"|FB%mhfQ{(|y+o3!+0mJ[]MC"<6u4j_OUmDF2؈$q7AyD a((=
 ]alr	SDh9@16!?ҟ\f@Ӡb́GPrDb=>Ԍ;ГJ*7 A
J@>PW|iD, ݀F+$ND׋ޛdud&XpwfͼvUɬ|LHdd6.KOIVӵ9RcʠEơI>|WIR<HQ˚nDo3hskK4A5]AMb! 
}wSS1G(񴨶L1ֿP"b6Ҙye4f|W&󺪕(=_|
'L}V@˪nXF<UeCnIYInh|m7ƫ18n!isfA}<9TmM_
`RqK52No̱yߟ]0ՇciDPG!W kɃOJܩgPoe8\]2pB%2#ã&itZ 2||$o1NdآȢLYFg)O:̘*TVJ0vV6_TƬrH1)2Ϸ	d'X`{NP8)A6Apht]/](wESL/IysV#Ǿ?>ʻ GRXe"g
Pw)*@w#^mS}?5A"iYiBZ!XE$~'%ˈV`
doD|):h&7(*\7
?K#?<B?[·W{մ!np(?UAL"ӡgy>u&Z)~,c?3HD٭jQP][֯0W]zf##"4;_~_?c)`mi Ć0i7_Aui`dt;j(u&OP96d#aK~&@,*gMp|&D؋	4
/??<?kS\cbq?c5A  Z!!&&LLzӻIؑ|Ҹ}[r/>#S} x4-N㿫i0W[؋:Joc\mOްN?fGJISREY/`T!$¼G#P43@tSjyNh~wC
]֐`vR2;ףGiq`An%Pg,hS{iwi;&	efH׭vnĩ 
B`HAD2
`2C~ulaAHEC"$
@Eq /,@ b1J!s,QG_0#H/|.<w4:>siId)^vYN:o5n'\R)uiUZDZn>:46G?hvHIrX\+Of*X_-fd`]XكvGi(phBVCWt!~׷_sx{ױu*e (aP" 1&*0(,AkF1Q*2҉b0c0`1F UeɄX+Q_HXŋ>Qb*Vb  ,Xc$db

~ ¬DTb@(#"FEDPAE@H"A"$OQvTUVXV @QDP0`FD"޿&vΟĦhx&!'C/kn6S(~d^$9
#!KZ PkrƦf=_%}7UhhȪ!jZ/])ZayΒ 0:L"!5ҚV\IfED`uHrt&w-a'bQR`y%
4n+Osz$
{ٜL&HB3j_N3*.FH1`Zg@XQ@=!bUE@`(_
 Tل֪HXDX,a,FDDfR1#!HYAX"cUȀ( PQcAE"1UATX)<0QDEPPY#D,V)r"(v+XdQw)V(YXDV*I6sfazX5(;RTc(1X@Uc  HRFH%0""",X	6%*AAg*$Db*0X2*2! b*TE$E1)b1dY"*ł(ȇV"$AfUD$EPUAc"H*AHT Ab2*,P`FH1@X*b	_{'󗺾=NeTD 2eԱӷzﳚ^
u(hc
(?@ Rh*	9):"i٦Q۷YtPNuTZMB&4-Fn=pI2n
-RSL#+D(T+
ipxlZVoXZ-|b,Q"*!(4
<_nbeUu &UPd&Pd+{9]ЧPL+qYωio,VQY80Rj%
*.ggmQMV4o;suF'ZP+"+BQRiӾJzsE
0lA]cNdD};7v(8(PwFM:[8\/'Y9D+z,$y*qŅ<ESHcf-i%dPNI
\0ITPAD+CmVE)ܙw,.qݭmCIcߥ7e&◟=igLz$4P6aP9Hhj'Wܴg-QC;7!Iq]-ΔŬ1tiFJ!IekU0TMZ҅(PcO2+[C`g'2SElWIۂȨʐ3a(A4"x`(+ϋ:YxlqST͛6ښMR[Ei![)e(,ͱDĈMX'y[fܩ1]Vc^'L3aEN\d1DMUI\ɑ玳{A쨻Ǔ5Mr
	MYoNiX=(]Y޾ͩs^ܖ[c<,( Ｕˑg6S&Ύ'jJjf^EP
ój.Db"&	rMi
4gڐxCy譜7d;z].+1""&!Wz
#lwo	s-e̸DIya@DYXJ"
"b " `|&@ueV()9!q"F"

@Y
evږՐm9!Z"N̛2M0(TDw2`b,U6æ"GVXf*ũ%L@`܈Vv%f]RP^
a4kL&b(ꇉI&2<ըQ
z
0"&q0$xPlcMmΊ܀>Q}p}i:k.NY	m'K#Y(9(Mw95גyUjΰ96[i^먬+ڪYVYj2ԩ#5Yyo5Xhs+̉6<7f
(,$2s?_{*~:@A0'7,fȵ,C5):9ݮ+X[f !N:ee1˖3s "9'mm[obҘfG
XlvXz}>_	ډ2B=u:($N؝6+W5,:	W*#-MzYv|YՓ[DQ7{i<I#qA򏵊ZU"W=#xH(*2GJX"A@P
5*~ە VnǍ8*ǬH~vřsF~R<0*~}{kr!՜9>oxk̵2X8BԔLL_&[њ
J'@<S&e5 !
TW;|)ߴX{Ӡ~;WQE8Fx[S~W|uf1yg;ym̵.k$CV].(E1˽rx?g&[Ev-G>JK8Zz7Ma%xBTx
̫&ڠ5:-$2d<ƷpבꊬEL.*g{TUv-|UўΫUUta}ľK]ǌY.*UUw.8UUQUUWUV*4fY?b`Tg3Hr@E YijQ XJۉ#!M^L.f@X s=SiC~a5i=GўR>i˪&lso֙$" +A'(~`d(n3)8G?+V?kMyl;lDj=d쿛'4>"؇pvR/B_>/֐~U>HGW~GU3k1;"]nC2<pe)C̐eO}?>X2#5Px!]'\qDqXG5A쒋ˆZ>x-N Ϸ<(~T0_KO=ۈoTWٻfE84V;_2H镈	'MN8
KtO;3uu<SlWjzjniaȖHDS6!vdaF
*;~VUgr`B>u#/WńR #33=Ze_f7}/kۿh`k|ܞk?Z>6I`tGcО=VD00~.\ *cMvfK45&>ׄ/pׁܭA	^?e)[mj
'``isOoDU_iZ~@P1U3U3!nȓ7oq,8s#Z;n%rMjO2RWJ,z3PJg]8mUѹSnfiKN ^D2ItUp@L_7F0yF+ u@u]ֶp噽viL0`w۩@TLZu;{HNCٵ0#7	}UNn`#0#kVK4<k5sF.RpK:>zicyC8	+NvDL0"ԱzͱD)䐥xLp|*H9@d-	$ٔzd12(v =PD.V1?7eKjiq֞l[{8??ru-ỺHrQs#簚;D4~ i9i6b5ŘN٬XNDX2$xnŐ
LJ8wFNԵ
]98|2h	! I $(KR =JKhzRT){HKÛ՟DPQS$x훳ب;9ĘrLR) E
АmNtBNef!ْM4089CfƝRНM`n@5Gr3?-	K|5}cpCg!\OΞFI[^,P@q"H@v!1 '`	ً3oB|/Gm}{f|ikJ|^Mb;[mѾ^F<T|PC"H]_:Xx]Vmӳqޛҳ]=|5mWp㗆_IuR/Xk<	_2qkӾ{	cպUaSݱ`4*Iy)@d UCHD܂ȭ\wuÜчycHº
fC8c!rh-AaƅVD3I;zuziQkQ7ȜHId t0;y3wuMv<xӋ+86wy)=,7DLLAtCʠw]hU c,!K~o#T%sdwv&	pΧ~B-!-!8u"I"),J,'Ϻs[okpwekgW7ټ4**"7x&WvaI.&vbXqMimHE֢?$Q/c[~ZTZ54"Yًrnmp㔒JۖXgRܛK+

lrZmcQ	=#@Pe;!,9)N~UGgɊ
H%$H|H"=܄1k#Ʋ9~lĢoѺnsPJ7(@vVŦ'73u0!Ӿ\܊:hׯYcvmZA~icrfo;~(BC$nw)-IiMJ: AAb_"nS0s[d©ȁ

56s@I͊3Z}\s+V1;K7T#rw79M2/cJjlب6a칛b|$Z?!$*_%)).дvKb!cpU[Uݕ4ԀaEW\|\Yg4+6
veN|Șl9G
0J&s3jNj33VA!;z3S(} Tǻ^14&Ȫ Ү傸M	vVہ.{vHH=~_yH
!D(F<Zy<1n>*ruWah@f@h(9|vXTطdt/W]Gi(J
dIƑPYU8\&&\Q%pFХll/i&ѰA4_^Gh=ԝτPu$`g0L'YkkdͱysǄ!$}J+U$Ҿs
N{JmCsjT+D#bp+ DI^Boza(nո!<"=H$ Q۽Řo±)[(?߿nvB`~Sa,8}jlIY$IjBc 
U),Mhը+!!! DDA:kA?AKADPD%KJvE$ꏜ$ѐÊ
(0P> ,$Y|< %BN3엶̛]f5DF1Gr~cg|]=mMK2,I$q3Q~d""	
0?LaCLI!Tj]ú`;fL[$-sφ쁒s)qqd弲bkׁDmx&ID!+`̆P,hIL"@K:xt.5@Lc,2e㟦ˈ҉CH#H)Be1"cmѷ
e]
srH[iiEQPUEܥ\V$20
߸>@
/8#
4Аٴr#	1
y5imhA&_w}v<O?^M ;cϿȉ݊xz0ؿK|>g7q%TLds~2Z5Xu?hr/Uyу}O=}͞faUbj!|Nۀ6:^B1zٴ䨨r~뻳BH`YhyP,eı	5ul\y<nE4T`ҕU
RTӽ}:PvL}nu6GHR4)msdHMA#X3\v3Gp*j&]Mo@{dG
sфd]l~&WFN3]>+ޱ
x2Sup	KUzZ*W盌W:vspd5jng7EMCo}x>t-PFA`Ʌ%KJRB "PQ
",bQ"K
ݿG7~uǫ>M9O'{,ՠvg%3c=~"+i5+;r SJm>a
p0[ZP`I`oGEaĳZaڒaU%R|JN qaޒ(EҞ l(P)J&%00A㘰6))&䌔(Y	
R2Jȍi(F(mpy
W~{AΘ(PZ:CtY	ږѮFbJ ÓhlA#-ws%TIa.=<y\рӈ[S#8Pm8n}\\9灸ˎ|/|R\އj/{>lfDR?-PRMт ]85!t&?%(.w{ɨqp1#8shh6M;#))_vעWm;::?Vc))&A]!~؄ƈ9aɺw.%q0h{Tk3u)(t@ƀ!6Qts=NyiZS4ᰞ]뼃5fOfIO
Wp6N}[uH}`т܈DpiM7u`2Xz[^a~Ts*{E7C1AzXn(ݯ]}G;m׮qأlsC=r`&"A::fsݶÐ	l](B EB78u{CŤHu=]i@R,B*Cn9+Vܱ՘߄\mliBcplgHsEI(|ÖZ5g^Tv|4.amӐ5Ы@vvnsYݍprad: `LL	:XܤZϹ	NeSS;aV\HJvt=d BqZ$vcL+ˬ^Co*H"Wq:|`[
JOcNq5	UT0H<wbv{;{qs!S&;vKV7UTM2MKsɾgh%ϰ-#O1!`UUTUUUTUFQk5K9XД`m`
'/!#4z>IMIL:|@UܠH n@(H, ٹ]a<xQǧCKr9Ѧ~!syoj|L9laP)?D:cDۆ:eQ&3+(Vh?	_,~{݀fPA @N!lPQ"IO.	aRF1bXA
ňHJF$aiF!S<oܘ4Pܮ-\aG= 4"q"atbA}
TQ
{\m0苧gbNfNp袲T?7BB~^*?+ބ6LR:I
<R>/5pR&DnXK	euP7) DNxFJB>8݅"N`~hXvKכCOZYny}3
sx1TcC6XCu00ߣ6QҌGIڮօș#ӎB&I!WM
{3nQ.~|7j1؄9L,GK8$M!47|8 Ğdib#8d?z^˻
.- YMD/N87>ӳwV4$X)%[dP(V>.bR,b
pJ+mG9>לּ*N߷8j5HBBBI/wp\<)3{t-;C$@@#6)1>k3,'A"wAMZKiSw+rNLR!jpp޳YceNf\l?J.HSC(2>n-ΆP	 /!؆fn9ݜaI0oqPIcPGf5dBCnK^`QQ9q	,s,&ZKGR9"JAI@D+"DA7B`ћ;qG#.Qa'fqz,~{s=RMMU 9`I<^P4B ,Z~jgNRNuR^gDm4|	x.FirZofK	F&.oIi_sF|T` mQ\^M4zw\<gJ(<I|G?5͹s؛zxZNxתŴoUpGǶy?f\-c$
6	#X<E)zf{;ZhB˖4LjZfMtkag걭}ly*
Bm1^L{(MAWN5QMJJ59Mun4zB]hU'YT12NS44"]~}m	Ј⏇G	ޒiR]Chr᱔p66`ĹT6y^c4 HvmQkP4KO;`T꼗ޯZ&@n6B%<a7UVrqӜYepIs͜YZSٮ׌fcC	90J!AК۔.a49YZ##[EG7UVX$(-kW;O;ߵ%Y>g\.@h;WlQky?-^D8]<7VׅZ_ނg<ޗb(߭&*۷LַC	4-P9uG$sGocPl;lL_|'Wj\k,ɩ|*zY3-m[}5$aeB[w%~nn9q="|0žçsJ0(pၓ`x@3$1-/p3maCߤ/5Y$5aU|g0m1CŞkI*~":&
JBдE=&;a`obbSr.)ߧ|_{NFNvĤ$ZF|/.wVv;%5|V5*ʄ|
Il=^~_*m%~.ovƈ:<	QoOxsϧZ%Am*WL٦
TL36hNVH	|${9Si&2iۿq}{xzb\u~/Tvj},<6Re7]-*K:0ՙEd
YkVv-ѮnEr<*V]Iw(I,x|zM
=cf莮8߆Tb'mCO9ɦ-isn!C7h
&2xX<Mx鞎\y+,Ĝf]r4m'*Y-\Sܻeg4{<q!cAߘUĞ<G*a	y*:M&VSoi1[WV١jP<%|}<O`㾃Z/o>g{w)`Ay')>$kF֗{CPBG^m # 	" H,Ȏ	JEP  "_ 7\Ae'TBާ?()m$Gx;`=Ti0Fm|
q!P%ZA؋i;$
=[AWxܫos@Ni3#ҚIE[X!3`0\acǾ[ 7?5-g*5kT>W}w/c}$0ȧI$8P8dHrjvх<rS+^b=x| sQ=؃ut1+hx0PfkN$7s]s蜕1'!j1'gE.^D HEjg	I{%ε]V<mK4OO`}Rv˃=Gs`5BL
8s>v@It#؂L*3sq AC/֖5 s
2dP	ߺJ%Գ;Nln5DѼIoxO!wjgt)7jjl[y8W[Cv9<zq];ٗ]Vr50Nsf.QÉ]dAz`1d͝7rnlx3o8NEtPlTl/m^^93*g	EVnDf|9L.3FxH:gB[IӪCKv<f
Jcni$]BD)BU^Dvf&дl%!^{;:^L=p9Mb4ZۮvB|i4e!;|UB'o~&$\u:у/N{6qi"MSÕ,,w' $zo`BY%ENC!:03ղIh+UAa0%c`1dET,d$	"&!tC
&@\#p73Ťb-G"7tOdjtoLMポ|gw~du#ǫxܹ{iw.%nQ~g qWZ൝>dqQ;1P}"L(fIO/D>L$~qI!?)G>lYf4rެ47;m'4Dʇh.a8vlqªE$[ފYwdEk1[ѠU5Xbk[m_xWU(g4*wUS;^cjh"
QI0#T"9-B9
a6̋hS'Ddb"BHZ=
udL
"ɎRtޕnwK	~>^bN	F kn7Q9B(*쁉[XLq8w`BH6DIj|*PU`XrD xBiȔ?fSCn2k*SZgKLfA`zHoᳯKlLQ ~xlbozn),y'G@1@9i'kw,-)NJYeH}d4ǒwdL3xp1.MZ$BR'@x&λ )DAO`x*ls4di%P33 D&MW+:|6sf7Arhc
PZ|~G~vЪxqkzq29-u͹zbvjTszvt+7Q^u!YӨ]tkįvDF:TW8B+w%%A\h*/IjMP霸?Jö&,L6/9
Mu'	v2J(,42
u}tGWxvYn՚d6Xn"N<
DGn!(14%K]iTLz2Y&bׅϩ|egM;-!	fjSla0fW.Y-vaJAAA`X2OCrD,uj"%cș~E$"kR1ɼyXFumM&zlj>T%FA!dQV2Xg H"ajVZI!@=[ZM1njQ)DaâJj a464HD?^'Wv@IF4/V8cbNYAY]\JgЙ`WX\(er
ڞUa6TҢUUQUUUQV*'I}Y\V	~Y2!|BZ6olj1a׆,Uӳipu/YC!-XˑC1w,_FZy($~vPYnyu}o}ݼY݋NKb;x==AЧHNIv/!ysz<<  V;7n[qJvZQ4wuT
8|&]pFln=@Nٍ$
eo|Y:H!75FB/E"D߿m
utamUʹzHEv3f畉Rn٬ɤjIA*z?{|mC,ux$/
 AFpąk6I^Y
Cu-64zBPI2JLe|ș?I*('wي`3˗Gƌ3`m=>ۼf۝}?%"OZ*B"I,>MG~^;#nAioGsx&ENh؈aYL8+O.$KM$R4v6O34bQD=}lŜgn,d.HtifD_M
 $xb`i-nC`dq]ybpH='y\Z)hEm[,ڰ0 N]_Ǫ+؄·7e(Ȼlx٤s ZfZiw->>N8pr7
dW9d׭ϮRh*Ä)AKڭ<ۼ
nҷ@-<=ʨ"Y$o$MPRx33K=Z@,J,Q@6bBPG|ʺ)ϟ1IډI<rv`5k9\Ac}_MD'Dn+f#ӼW!x*d8}2أ<spd!V\֚"t,.,{RnbI$!!`3`\`:|90^A%?-%Ua,FIx$(Pۺ )yKDIA;h
,dwȆnķHsO&j.6a	<9$׼(ПIA,lpK{zW5竧}՗~|Ӹf]!aX3Y DS볗;l)3plV,^qv:
}@̳;w9_SS8ۗ@8XƼWL@ԃ wh1v]Sg:4c<wnk8WǨ\vh-3"A2BN\>[:.]M׆\~
0O{wխûUN=cbcQ-Qvkp#ZubId]RJEgW'M(<$nM&r(<ObUJaJ$`*ZҨ¡rUxBEhhPEÂyqo65ln2YlV^.+2I|q+Z ]/KȇLU "f*r.u?ng}jpRY+>'}㰘@ 4]ՈaE+M	eK	5oibuWD
"nr3\Et%e/=`!ֲq/mQ1ቂB(-qE^t2B
+YA"4kFUj{RstL7?a5%q^.ؼحpΨ(dVJP_~4DҽµrjV~,<IeyeJi[vk0`rTǂӇAa~3o.ɢyT¤֓OڼU SeЙjkur#0%$-Dj<=+/jfk-W2G$>aLh2=69OiV'|+{g1N_4Rwjw􍢤BIQ190'EutEyi?*}⅜?\k7)gU\n/M(PP 0e5`;ԥ!,:|WK9I=.\QS¼	6]үե9fR	qVLsTR3GB)*sas -ʷw]2gt3n1啇nк!u>]uUW҅6VH&j!b+y5[Ma&;:\!zty9^TP_4~4C{kw5o^"<*ӞVT1S-: +ȝƤmTњyq  ~low.vN*`s?S8VRF`Tg&ĜڣpQ35n1N[GCzVV3cSJzwϚDITJf{lG.i(St{Y5Ss3	%ÎXTOoq1u	0	;6'),gqIx-:1MRt&"e>
y_XL5Z߷!6gG4

ކtIہmnXj,;EW§6 !> Rb	=k 'Q;;7SaߤaŞ45`Id$9霩"09.B$V|%nzB&
Xz.6í)Q^LbHf;4p׸h#E6VH3t,W{!
Fc]7FhԡAQ5q &.Y|RG{WdZiglF;΍ʈ!	WPYVLtYڅmaU
-'o,t(dXD"H8؄1la,HF n`J{/]BBdMȶ.7gCqL2N@|Hzn7/7ݟPBy\BI|} mwg7P ÈGJd qNr)2;?¢}>ߪU6Fo2SØWh2AI#ĤGQ7~DjE%LWOyheT64}ߓ2[l_;p$Hj~gٓ0$<nwR^^_ݥOȶ'ќ]		<"E'~A$d̈́ο$g Md49d@]Ѯsz5rv-L.Bāv?
! DD/Yg_VAu]M:^]gHw?e!?Ÿ!Bm#TXg}xJ~go,X.@ݗ[~'j89ð!` >&"QG{:̀I_B5"l	),n=X~H;ӷ>hw)`r~6&5MICvM,x3ǬB?6|W-KPi9 ΐH,Gh)f =BM'2ԁRc0Xl錣B"/``(qUtHqp~k,k5#m\{.56%$(N!Ac@dd	EU 0n4#2)^a&(vJB	.!,+fl]Nv{cV\l#GسXƞخ[i*}V~1Jk]EYz"%22EwLӯù4lUCI	!2Ӧ`bYDeQcUAZTPr$`
n8=̖`C=
Cq 2`@a3fF,L.uYX7Xԣ5QP9"1P>ܞcf*nX=[[$G ;Ȓ^kM~$+Ю޳KϢ=oצּv(hOl9Z+WV>Ij\gl,~Ъ]P^؛a7^u0f,ۯ ֊:wd#;CFgDAPq6a(pĲ"஻A)k^@K(G!LMBPH", W(vNHΑ .7@\&i-
a$kyi}h
̲
Ȁ{&~|=!|Q3w8>n팘u/If6CC-y*TSȕPPe'vA4$x5h'ia-v,dDzIs *UB>*T
!젝hoˑ<6s:ˡ7BRb0asaW{Y2s@ h;%碐[0J$.OԠ~=VT+2%C^؆=Dq^|BA2X9Sƣ(}(t=^
M6BbWHoJ=E{ޯ;j$E
}w>θͪ6l zY[Cnxu;UHIrE=M6Ҍ7~'ǀ-s' Gge"
!l}o4Ŵ"Q
}ģp"LlG
8цBBF	';,Ʈ,םs
}$Ң<ifCCPTdEzT$`!dBADUW7q7&)35HvAuEŭ j;P(l f<6qhwh,imz<~-7m	EUϏTA3kT`YIX^.ΰ[{|74(./qO$͊lPRF{|\;#b
wD\>:wM\EiLqy]w\/a
rsD*!O;6E EPAjO*N6tex@sL੡*3
m_ֆIB6ھwyTC"u'7Ǟ"ĬaLHC4/]uhm$,XrbU	{l7W*q=fIaOy
a4I!X8J4F=Sm*#p rNc"1!z]=ȠgD>ϝ B%5$r~G<qw.](IM@X/`V8QX(F]Ý"C|T ~A IA!21|0-BL
xh1LNᘲ \^cRd(qSw{㑶/f7rFDtH1!?p>.)6veMɈ>/tz4l.707)
 61gb A|2p7a{SjcG0lmSt訔ģvߏkhAKP/Wz8tjImԍS@AEi!J?l;~|Uy`a0ɒ12_8[t<̂ ]t}1m$36F,@-!CP:|a*
`LSiw;P̄$M7&ÿ6@"a-=1
΁/h p
O]րR})}ZC4*l LF3`<2H	tX#}lΙ:;~Pu)Z7mʠ@c%͆s
oq,-/bw}r[8<[<kGl)4rL{;[4oj=@ދfcT!y
CKFA)l$qLٜ|Q]TR=CDXL'XS99shf ë;eba`*-bl̓ؓ{CԱ\Q\'=BdΜjk8c (S>2'Y4nr>F-B3R>Eg@oPĔ#k
c B"
1#f1ٗ\ڗek2%ä(zFXr4>. 0\
A&:GN(U5.dXT6"C{+Aaށ7@aߵI*lrk-m,8w5*D:$9@) (iv2DmuNBF K/mPrzs=($ +1a> $
PRB@0r"!栛QvCNuz2htR.ʘUK2c`5K4ص7Κ Zr0PHNV4l6&{MƛcQl-D!TDEYuo`:BYVjy_[אwv6
Ukg>l\ GO	ٚa6w'C_[| fBMIhwO34ltǵjV)BV޶a^u9X_o@#),X&c0lJ gGn{&^Pff>!((,:A$ Ed\Ȅӆԛ@.Ngv9RvF\DQ?fd
@b*,A`	&.M<tCz%pdZ	!eJ%YF@l+".6vvf ( [$v
![E.;{q{:⏂Rz81 4RD9">d˫$A
T%E<Psv|۱5aFu;"'_(Mo}S-
 o^6u7ܪn 3ѿX!gn@ԧ<TE#a/(/nmߝ3V
ۗ(.؟&[~pB Ñua9
P "I`6NU0N84Ӂ`ׯ!E >圏rn㯯Ha]t6p8˰I%$[A8#yI}"Qxwcr6ƛ\---u&U V!39_NY~l99o|˼#XTUZ*e\&SLQZ&^zky1,~~or
~1>Є)xh.a>&	b^E>eJ ]ʭr"(Xީ?YZu9qKh&]c^TQrN'2v7?L<Td"vz? plPmC$}TK8?HP`
I528YA!HaMg< mRI$"""D` ðP	'X>\m8 $Dfc#ZZᷧkAk! ovD
!$#i,Rr
)kNLt-J0Թ0"{ =)"AU:uEm&N YEX;n)AdV1UTPUD@QEUI! |&F51tnޝZ#4m"YRrpahHo ځ2QFt4
MA#]9^9ƵLP9Pbꤕ2"#nۅ4m9S4$
 hgG%hkXQ״X0rpBt?Z	J	(GA줔W.5c%q3ށ*C·My^fX0($.PUx;a$wpHs?)H%&B1'	4I@jIٓVBGCXsz3D"513՚SzY t>0I	{tǁu;XYבwFM+9mײu9DTv?X^a30vhJ8Ztb #ĠJ{:$ɣ=A(dϑ)`aNC(&q/PX!aw.8;.k_6
"7	פJ$([[Q'̧8Y؁ם5q	2Mw(ٹQrDPn^p85:,@BlH]V8R8ffM%R%L:Bpm Xnma;[1\b ho$m P-wx1Xw!z1ó$9r4$\ܚs=8:L=I<͑(ADH8D
McHJDu\tNQs\! ut
hdG,͹Wc9lt5!	$!,bLL[!N6DE76( 9X-x=.zͭ33
u<6Zv*s0f6<S>_?O`P ՗o|?(vڮG{|b#1[nSV,b2OVJu>/f:Q-p,3؁(p=PvNhQȰ}"*xZ^Q^2r!	"K$$!8o2
e A#W"y  ت
i(\Kty֓;8`R*!bI`$ Ivh\*  
Ct;9u?z42 ɕ"3(H*4$hzX@0
)2"$ HsnJ7!	$ IBnR@	{æ9/tq#ؠ'ől-3~=}8:(}RN-ȁ"T"ޫH$D1H{eqB2,:5.;)
l p' )؍\QdT*Q#@rwTV1l'\EEwȫmo!TQ{#qDrA`@`}?1B"A%wI8iODu K
<h )?;-FUb:m
-QʐI}%bHis9P :@SYpd0Ż^!.(
&uQo 9mR74' HDEmi%'C׷ڢ<DG3]-Fo7~WTrsfadgs#%<X{kÛ8satI>c9!ue`^H/Pq8v8Zޢc)ttθb`&$R(1FHumPS	NF
·KCv:$@$;H|I$	u8D]>0=pН-R(h* t× "ŇCaf2C
<	;/]d2f`E"m,Ș֐+St1Δku!p,27 C 02GQZVH4P4E1_Kq	3z?u [3CYdUK'Nڪv .2K	Ҙ&!ϲS{,!fۘyl;DQVk^Q5drb?]e8C!@nci05<?Jw?	5"YV`QSeU!>X&y"E"@Ȣ)e$7
$R#!]G9F{+	A:r0HQmO~G
DZAN<rOMk@zH  *0XXS ְh3eŚPѼFA Ta`Q H df01b16j-$͎[SՈBkS/[H`+(-Hk>f6xf/2@±#Q &&15F>]ȱY3'`*A^h Tl۶b?C{)%4K6XԪmlg$H7bRRhjfLk{NCS{㉘:rXye*PDQWx.4Zum+|c	!lCl xv 0IcP17ӏ>,~OZr,bN\e$V aTPݪib,H451, * 7'ׅP.R)Ao?Rm63
mbnL
;ƾL
V0pS֫BH+D"4BHk#P'	H<"p~l](DS@C 8k? z;wKGH"0ъVRΙCu;Fޖ]=⎆ʒR*OB/
e$f#30Jl/OƲj!vuO>rm[M.79xtZt#_F&v1T/JB2QvC*;_t3H!DF5sD!9Pjiq7\3{p`I'wdN\ΉU:f:T4HH@2mXSHNLdK0[6
&ժQEәQu;w1bň@F"gEb(%8HYqPŰϿ"efyg{{dMF
8qɹnx5;;1!vH^H"!+hXB5`"5(ZHo)Bh@P\]=M^b*h=e$蜣&	A(hLफ7v췭痐J187ˆ-2yrfɲo&Hqd@hH<d9bs`s&Lc!x)K$;%ʛ=E%2f,!dv8
@USbP#Iҳp\k6ⵉaɲ*VVWCsV]YfW
(75h|\Xp6wڙ9)=b=@< JJgg^yXH~T$f@%S{PL&t
}xH0
j1˛ag:,ګ" Ak#.ڊԱ<^Κ7wMc"uێ1RA@uvHT0&1^a@u\j-M	`]pʢU
0a0$(Q#$Y'
E=!fw@0b1HB$Io6(ôH B,,] ,<>GӚ&҃BEx jq/i67}v=JF5oA wp};G3̽O!y6DhKRF\ENtPw;Xg@{"oA`,Bv56Ma*jѡ۽WsgAˁP"ش(GG5phA 9Yߏ`McxR/$t2 _r 
N(L
	 HBD{1~HO
9u풖B$00r9Ch"#DBB0ADC{bRLHi7,ɸdTFV"DUUEcUDnhr
Nq1E.6x$+ "@`	 '8m$& 6
|6%#!SzHS9ERMBǿ30{mU2nKS6ktP`hpc!2FgE/$
h]"c`%eDAZE	;q}]`ݣ[MBF(wT*A*LΑn$7[,E<LC$PhRRıEK=}p%=%KD*"Y7M29FQIRMKGFG$$	8Q#ӗ|<r} g!(
uNdt-m(,2FFtq1W'ѹ6@Lf^6Z
Oo&v~VUF$'i)ĀTY$APˁ8aݲӰ㼊$x,gѨě<dhC!2&ט(#Ps2s7՘aOR
&7+Z`kýv8qL	HvFTay|Rj#6D3qK2:цaaf1up,ʕ-h4mrj
0[HMn=@≕B#J@rf'q`fF
@G yGyZQWhqt|T	 VF|"<S)F "@.o=B

$Si0F@b1EIt܎Hq,#d?&A	5H}ԅ?@4V">1
B͒B%qIRp<*\ƀ?'`ͅa#"3 HF!;Yho9Āi@aa	3
ChXsHEHHX$Q# #<f-/tpgM>U>1|Our	:*-im-Z[8|ިMA 	H@
2D
:-)B|8 m+H-|BۭB)23+IVDix}B d5$ >tCX:=yxw \PC] 0+zgDy9͕>
^`g #qex(pAL{Rr	717̌5GC'M<@:]u):H!;DD`SSGoDE'قAI	sxdCJ,{]}hoi֕1T@ ^%dc-yPxpWޠ,|OZB]=v+/阅boXc X`bV£$$;2X$YDxb,&6
0X@XmE	Ʌ3,,6~'51v+Wz,'3S[uRÜw豭7A$uu3a,E	1o`0	H$D	\MTjVF4_G7kAt}}4]5-%lcWt&uXB1&(z Hh0Y ;S;5PoIq*((kW5JRahU)Z&HddHb(CrΆF!H^4_)~BB1f7k徵5KC?WݴC|'
KM8!<M!
']-LejD4jHsmeڹfbRU"v)WŠ6^\_2	{km|TR܇|_!*2eY$Ɉra`g+0HkLq(KPƷh5 ad(J T0W7
jQ rVl\ba$F A͵s~hޮ%v"fE]^2Y)2S9evK#ȁ޹k+
wՏ
 \*KֱQlQT$~e$@%V(	6te\&R&
u<EG#`$#)%<E%/}bc}WÝ0Qyd̆هgSh!Vsi iZl"/9BIwq5@[ $ڶP}zf)aAf?^y^*TE;FH'0{-
E`$M1:تqaHnCI®:PW>kq9D*At -(KGo6N]8Qd%!`{׽;!f]hlΝ>YsQ&rs

۬4'm%ηmj
c"Nm`QIsl9DwҦqK&*@ϠIavTb,ER!ĠK38{z}S`awh뜡H%|
A (tx0:f4b4VAXSXL[mrB#`WT	v|-:8_;
"PD
H1CWx~
Ѡ,Q FlAZ4{QHBz&P~d84{,Ag#Qʑ@i">Ģ̄2<03Mƈ28O$ hP%53<#(6Ǚ伯px$>9p2	"([W(.,^C{ΗcX6|7?(
9ٱ$lbRRuw4RFBŨ60<ԉt"
+V[6Z2U(@)x:>kV%;[΁Jd҄WF	ehP-t,_H"04k!NGv4'sPܡ oux`PL&LY<_
EW`9T<s0 {ҋ""$<Ec<P#dq3BKZeK+Sa`{'OaƊ@e)`b	,X%
@u,El xCV~8@%v[0$ H)6B^>C\~򝛎/y2A	S(29rѨ#iE
jXVT T 
uB
KbAZك!UB DQ)[PzPwisQ6F&:\ȍP0rM"M`HPy@]D
on\y+`!cM'c>5.
`na:)!>I#!*DQ	`(Ind")]c毱GbB;4Fj
+ l$? =Gi6ςo]R(Đ	k)I3GlHNwrz@y"G
Bz3<h>XVQՂ1GR'[鯽
F\bD7^o+H!y-(--wP	{y_صB@t#YPurН0AVfPI9eTCQќ]&\ bU/7F+XIR	E9ʉ;yiu{
ʃUpP4-=,wHTbx%6e93t$)>X8AQgr+ȏ-Fҋv:BgDoـ7:x{jOX12~Дvuhev6gxH͍Z<a"9=އaD)$!7fZզg2\`Np)#E )b($!N$|{1vÑ."Wt6ᆧð@bmQI-MzhxlB
Ay얽3;K9_:CcȪC:S^2OCd롒 *!Y0"u!]޲tdDPY9I_y\,Y
fH	V"XImCbeg]z}L,<⽎,DXFs>LnTn1,Xp[htYv1`mHaNG}
&hׁ6ڪ'4,(f˯'ZHrpñmzc
72uP:v$~6uwN'e~	挢D	$CBT% tǟᴲYFڞKqVp<Bh%dT( V+ABo<C}K EPPh9|ĒS$.`6}&.%4d9!,D@AS6"<-ĉ*DMoQcn3qyH(1X4D$R([P6Ag26w5 Taʈ,Db#PCiVŘ	lNKihHTKj"uITL\ؙf 2uI!pSTXCR+/Vĵƙ)0TkfL!Hjnٶ #L1 JL!3Z0
^&OmB*LB::7jE!0x a`ՁM4$9L$'~ɵJo[Lﳇf쓴PX!I@@(BpB͔pɒz˩S1%l*&P9dc!Y_E.HՖ}%BdϤJ=yAY8A3ؑh%A]H4 Ɋ
SB:kKfƒ8
ӕ*<Q<x/5,t=a@`cXǀPFvҲ<a}@iT
Hp؃1
$IK6*Q@N\9*^6SHho, uðPddK([G8 U4Ń;r9r˂$a,PPAB ARDDRD	@d b DEȂqt=^-0C^6( <$ǅ)j7[8PUE9=3B6kAJlRߪlI_devM0T$LY1	.сӌ;*P8`%B(8Tbakl,e|Z#mF$P!$@ZLH{-JoU2@B)uG!ݳvL[ںZ#'DHT9;Y>xEr,S0Xl)xDo
4БK8IP)
VM
3!@(fdE6$l(=AB*|75~L
ɲ7߸}E&Ұx}jmj
iɔjֵ#:>P+lT\$ 
\jAu6f(DH$@AׯC;;0^~KaBHg~}+9I1wC
Q*ψKs"
$L#C@hpeO+G|i
O8!+vIx'cVDAQ#)z򃂯?%D'P3!0,,g6&@  PHP:bCQƼMNEPtCRD[!"xrxޛzv^Bv1+
;bUGlv 9<b᝴Ļh6x34=f-
|$8
bж[Ό%G&HbM5fC x?.
wvC$PvvZ[oN|LHAVJ!iQԲH9 lnD xk\"a84ce
g s0-,҈h'/1wn=Nwa%:fMl"@}J1 ؔRDI"u`K	Pb)b@"f$&^N<*Q(swi
v09Z~ s,Mv I7	;<?Rcp݊4L:EIM;8?$ܮ#({7zzl-1
kC3dqic5R `QKͤ\1Ԉ?R@תkL32cp#蘄;B
v$yP3[n;8pʅA%
eָLˁ$fvfh2ŉ`_PA$,T(a/`Dsh	n7Q@4ZkZFͩdgafjF$Ew:!b:@0&U`q@	C޶DB" q76N	0VY%JQ9(6<`c-մZ&hftD[Ep!FRuh0y?"hlTfC2饮#ƠݮWHoyv鍭!bn<2w,#QT$C!eQ)7f=L%m!3h!aAlDjhjV8 dA.]jRDR E@$T$`*Ie_Ma `d0B,(Û|d8$:J
0TtZDt"NVilΙRi},U)XYk5#H{
}Wpc&Sjܳ^WJ+bIpk"l%$lFb]v`,܎@. 1u ,HF+1+ FJ$Z dp
;B@
yXR2AB!"XوC	HRA(X;|ӀQ3b,\M$h9\!9	a7
0!e*#j!" ^`b-ۊv,iB)秂\|ДtbC>|La,Pijd1ڂN&BZGtx4@B|1Ȱ-\KYzq7&$@y낃7:ԄC:a&usm85+to*7As@Ҷ,2 S/Ԃ'dFSh<WMo`nV
@D$FP"}. $n/8"mR.&T
JI$I$·K:'a$5igo"89Nbx03zQhoʕYq O;t=~cen:(Q LB%H$b잺Mqg=X:]c,mp=y=')5sRaOkv|wl"
^s%CyQ!+t7GёOX!(ц@PmF$˘ٖH ϱrAiݾce3( 9n6d1jxNFf7*cZpc:B6#ry\vXL`D&
3 {>Ҡy{T"'h='@(u`~>!\5"E`|`ʌ	r__)OMa#&޷Ӹ4l4@5i?m;(	"2LhdaD%R,V5aT>F5R^":3saʏߚ
FJZCG
9v6a%R r+s+	= 9z^)2,(I	H@=NwW.QW懲~\tC# +n,	ȴEk`	a"B, 26DfP$Y&	"EA8|q:}7y	M@i5"܏0`"I7V4tg>抙zFb")(S(>1y[5F=rOB9w!B*^(9C/ku2X{ ]]'b<:
1pB#81۟{e'ϐi#ɒja>CD/I赍` +7]#Ch9|@zO7t&du}/&D:LW]FxBp4OzFRN~HPIMC7hy9\9w^ 0Թ}8a@HEP$jS3C犧30dXE ` bЁ3` !U@FP|! ?ʁ<䣎lੁET"1(bX2*DEQ-1BZXI`R
D>!+2$$!meCaV2_&Ʃ;Ex%cDDR
H
 ?e~OPYyןp\/ @sЗAbW*
6H@.OJkl B@֑
ئz\"$}=V?ʐ}gv3~v7\Fx{H$ÎxZ~m6_XjY?DtW~MI45Ͻ9
|cGñ#Xlj 顛!?cՎ>+JFt`SPfZ묊BkfBҾD4 NxlH~k;0y}/.'soyـ\RɆzPp>5BO,V.xohvE9?kvJgw C4iׄZ[kS58A\C{jj[2_]Ej{Dp|~,]4}nƳF0WӑI!%Xκt@&/CjmF[%5tFdRH;!~(ʦʆ<lP.HɌ
ݻ	lrx6'{1W`mU@;2Rn%Af7z;XfbjZN<Jj3o lo]
W}VH٫VkP5᷵^bWI2ROص,:ku^[!dG0H&CLf d.g6ZZfK_jZ)p#Wy*Q	j:_f~Цz?w|]B=j&IEz]&!J+03&>En^TG%^uW{^ﰿ%ǛO`a?fbf=f`5Nۊ*m7}24;I~%ٙ!xu1x"U3~o_O=?{xa_"(H, 